/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.actions.search.comment.CommentSearchData;
import com.atlassian.crucible.event.CommentCreatedEventImpl;
import com.atlassian.crucible.event.CommentDeletedEventImpl;
import com.atlassian.crucible.event.CommentUpdatedEventImpl;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentReadStatus;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.discussion.CommentOperator;
import com.cenqua.crucible.model.discussion.DiscussionBrowser;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.discussion.FRXDiscussionBrowser;
import com.cenqua.crucible.model.discussion.ReviewDiscussionBrowser;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.DiscussionBrowserImpl;
import com.cenqua.crucible.model.managers.FRXDiscussionBrowserImpl;
import com.cenqua.crucible.model.managers.LogItemBuilder;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.ReviewDiscussionBrowserImpl;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.cenqua.crucible.util.HqlUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="commentManager")
@AvailableToPlugins(value=CommentManager.class)
public class DefaultCommentManager
implements CommentManager {
    private final UnreadManager unreadManager;
    private final SPIUserUtils spiUserUtils;
    private final EventPublisher eventPublisher;
    private final SecureProjectManager secureProjectManager;
    private final CurrentSessionProvider sessionProvider;
    private final LogItemManager logItemManager;

    @Autowired
    public DefaultCommentManager(EventPublisher eventPublisher, SPIUserUtils spiUserUtils, UnreadManager unreadManager, SecureProjectManager secureProjectManager, CurrentSessionProvider sessionProvider, LogItemManager logItemManager) {
        this.eventPublisher = eventPublisher;
        this.spiUserUtils = spiUserUtils;
        this.unreadManager = unreadManager;
        this.secureProjectManager = secureProjectManager;
        this.sessionProvider = sessionProvider;
        this.logItemManager = logItemManager;
    }

    public static CommentManager getInstance() {
        return (CommentManager)SpringContext.getComponent("commentManager");
    }

    @Override
    public ReviewDiscussionBrowser comments(final Review review) {
        return new ReviewDiscussionBrowserImpl(){

            @Override
            public void visit(CommentOperator operator) {
                this.traverseReviewDiscussions(review, operator);
            }
        };
    }

    @Override
    public FRXDiscussionBrowser comments(final FileRevisionExtraInfo frx) {
        return new FRXDiscussionBrowserImpl(){

            @Override
            public void visit(CommentOperator operator) {
                this.traverseFRXDiscussions(frx, operator);
            }
        };
    }

    @Override
    public DiscussionBrowser comments(final Comment comment) {
        return new DiscussionBrowserImpl(){

            @Override
            public void visit(CommentOperator operator) {
                this.traverseDiscussion(comment, operator);
            }
        };
    }

    private Session session() {
        return this.sessionProvider.currentSession();
    }

    @Override
    public Comment createComment(String message, Review review, FecruUser user) {
        Comment c2 = new Comment();
        c2.setMessage(message);
        c2.setUser(user);
        c2.setReview(review);
        this.session().save((Object)c2);
        this.unreadManager.markAsRead(user, c2);
        return c2;
    }

    @Override
    public Comment getById(Integer id) {
        return (Comment)this.session().get(Comment.class, (Serializable)id);
    }

    @Override
    public List<Comment> getByIds(Collection<Integer> ids) {
        Query q2 = this.session().createQuery("from Comment comment where comment.id in (:ids)");
        HqlBatchedInClauseHelper helper = new HqlBatchedInClauseHelper(q2, "ids", ImmutableList.copyOf(ids));
        return helper.executeAndFetchAll();
    }

    @Override
    public Comment getByPermId(PermId<CommentData> id) {
        String[] components = id.getId().split(":");
        if (components.length != 2) {
            throw new RuntimeException("Bad comment permid '" + id.getId() + "'");
        }
        try {
            return this.getById(Integer.parseInt(components[1]));
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Bad comment permid '" + id.getId() + "'", nfe);
        }
    }

    public static Comment getByIdStatic(Integer id) {
        return DefaultCommentManager.getInstance().getById(id);
    }

    @Override
    public void deleteCommentAndAnnounce(Comment comment, Review review) {
        LogItem logItem = LogItemBuilder.buildCommentDeleted(comment);
        for (CommentReadStatus status : comment.getCommentReadStatus()) {
            this.session().delete((Object)status);
        }
        this.announceCommentDeletion(comment);
        comment.setReview(null);
        review.removeComment(comment);
        this.session().delete((Object)comment);
        this.logItemManager.addLogItem(logItem);
    }

    @Override
    public void deleteComment(Comment comment) throws IllegalArgumentException {
        int children = this.comments(comment).where(DiscussionClauses.and(DiscussionClauses.not(DiscussionClauses.depth(0)), DiscussionClauses.visibleToAll(), new DiscussionClause[0])).count();
        if (children > 0) {
            throw new IllegalArgumentException("This comment can't be deleted because there are replies.");
        }
        final Date now = new Date();
        this.comments(comment).visit(new CommentOperator(){

            @Override
            public void operate(Comment c2) {
                c2.setDeleted(true);
                c2.setUpdatedDate(now);
            }
        });
        if (!comment.isDraft()) {
            this.announceCommentDeletion(comment);
            LogItem logItem = LogItemBuilder.buildCommentDeleted(comment);
            this.logItemManager.addLogItem(logItem);
        }
    }

    @Override
    public List<Comment> getReviewComments(Review review, FecruUser user, Boolean draft, Boolean deleted, Boolean defect) {
        Query q2 = this.session().createQuery("select comment from Comment comment where :review = comment.review " + (user != null ? "and comment.user = :user " : "") + (defect != null ? "and comment.defectRaised = :defect " : "") + (deleted != null ? "and comment.deleted = :deleted " : "") + (draft != null ? "and comment.draft = :draft" : ""));
        q2.setEntity("review", (Object)review);
        if (defect != null) {
            q2.setBoolean("defect", defect.booleanValue());
        }
        if (deleted != null) {
            q2.setBoolean("deleted", deleted.booleanValue());
        }
        if (draft != null) {
            q2.setBoolean("draft", draft.booleanValue());
        }
        if (user != null) {
            q2.setEntity("user", (Object)user);
        }
        return q2.list();
    }

    @Override
    public void cleanReviewComments(Review review) {
        List<Comment> comments = this.getReviewComments(review, null, null, null, null);
        for (Comment comment : comments) {
            comment.deleteAllComments();
            comment.clearFields();
            try {
                this.deleteCommentAndAnnounce(comment, review);
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)("problem deleteing comment " + comment.getId()), (Throwable)e2);
            }
        }
    }

    @Override
    public int getReviewCommentCount(Review review, FecruUser user, Boolean draft, Boolean deleted, Boolean defect, FecruUser readByUser) {
        String whereReadStatusCondition;
        String joinWithReadStatus;
        if (null == readByUser) {
            joinWithReadStatus = "";
            whereReadStatusCondition = "";
        } else {
            joinWithReadStatus = " join comment.commentReadStatus crs ";
            whereReadStatusCondition = " and crs.read = TRUE and crs.user = :readByUser ";
        }
        String queryString = "select count(distinct comment.id) from Comment comment " + joinWithReadStatus + "where :review = comment.review and " + (user != null ? "comment.user = :user and " : "") + (defect != null ? "comment.defectRaised = :defect and " : "") + (deleted != null ? "comment.deleted = :deleted and " : "") + (draft != null ? "comment.draft = :draft" : "") + whereReadStatusCondition;
        Query q2 = this.session().createQuery(queryString);
        q2.setEntity("review", (Object)review);
        if (defect != null) {
            q2.setBoolean("defect", defect.booleanValue());
        }
        if (deleted != null) {
            q2.setBoolean("deleted", deleted.booleanValue());
        }
        if (draft != null) {
            q2.setBoolean("draft", draft.booleanValue());
        }
        if (user != null) {
            q2.setEntity("user", (Object)user);
        }
        if (null != readByUser) {
            q2.setEntity("readByUser", (Object)readByUser);
        }
        return ((Number)q2.uniqueResult()).intValue();
    }

    @Override
    public int countReviewGeneralComment(Review review, FecruUser user, Boolean draft, Boolean deleted, Boolean defect) {
        Query q2 = this.session().createQuery("select count(distinct comment.id) from Review review join review.comments comment where :review = review and " + (user != null ? "comment.user = :user and " : "") + (defect != null ? "comment.defectRaised = :defect and " : "") + (deleted != null ? "comment.deleted = :deleted and " : "") + (draft != null ? "comment.draft = :draft" : ""));
        q2.setEntity("review", (Object)review);
        if (defect != null) {
            q2.setBoolean("defect", defect.booleanValue());
        }
        if (deleted != null) {
            q2.setBoolean("deleted", deleted.booleanValue());
        }
        if (draft != null) {
            q2.setBoolean("draft", draft.booleanValue());
        }
        if (user != null) {
            q2.setEntity("user", (Object)user);
        }
        return ((Number)q2.uniqueResult()).intValue();
    }

    @Override
    public int getReviewFrxsCommentCount(Review review, FecruUser user, Boolean draft, Boolean deleted, Boolean defect) {
        SearchOpts opts = new SearchOpts();
        opts.review = review;
        opts.commentTable = "InlineComment";
        opts.author = user;
        opts.draft = draft;
        opts.deleted = deleted;
        opts.defect = defect;
        int inlineCommentCount = this.getFrxCommentCount(opts);
        int inlineCommentReplyCount = this.getFrxCommentReplyCount(opts);
        int totalInlineComments = inlineCommentCount + inlineCommentReplyCount;
        opts.commentTable = "FRXComment";
        int frxCommentCount = this.getFrxCommentCount(opts);
        int frxCommentReplyCount = this.getFrxCommentReplyCount(opts);
        int totalFrxComments = frxCommentCount + frxCommentReplyCount;
        return totalFrxComments + totalInlineComments;
    }

    private int getFrxCommentCount(SearchOpts opts) {
        if (!(opts.review == null ^ opts.frx == null)) {
            throw new IllegalArgumentException("Review and frx are mutually exclusive and required arguments");
        }
        if (Strings.isNullOrEmpty((String)opts.commentTable)) {
            throw new IllegalArgumentException("commentTable cannot be empty");
        }
        Query q2 = this.session().createQuery("select count(c) from " + opts.commentTable + " c" + opts.addJoins("c.comment") + " where" + opts.addRestrictions("c.comment"));
        q2 = opts.bindParameters(q2);
        return ((Number)q2.uniqueResult()).intValue();
    }

    private int getFrxCommentReplyCount(SearchOpts opts) {
        if (!(opts.review == null ^ opts.frx == null)) {
            throw new IllegalArgumentException("Review and frx are mutually exclusive and required arguments");
        }
        if (Strings.isNullOrEmpty((String)opts.commentTable)) {
            throw new IllegalArgumentException("commentTable cannot be empty");
        }
        Query q2 = this.session().createQuery("select count(reply) from Comment reply, " + opts.commentTable + " c" + opts.addJoins("reply") + " where reply.replyToComment = c.comment.id and " + opts.addRestrictions("reply"));
        q2 = opts.bindParameters(q2);
        return ((Number)q2.uniqueResult()).intValue();
    }

    @Override
    public int getFrxCommentCount(FileRevisionExtraInfo frx) {
        SearchOpts opts = new SearchOpts();
        opts.frx = frx;
        opts.commentTable = "InlineComment";
        int inlineCommentCount = this.getFrxCommentCount(opts);
        int inlineCommentReplyCount = this.getFrxCommentReplyCount(opts);
        int totalInlineComments = inlineCommentCount + inlineCommentReplyCount;
        opts.commentTable = "FRXComment";
        int frxCommentCount = this.getFrxCommentCount(opts);
        int frxCommentReplyCount = this.getFrxCommentReplyCount(opts);
        int totalFrxComments = frxCommentCount + frxCommentReplyCount;
        return totalFrxComments + totalInlineComments;
    }

    @Override
    public List<FRXComment> getFrxComments(Review review) {
        Query q2 = this.session().createQuery("select rc from FileRevisionExtraInfo frx join frx.frxComments rc where frx.review = :review");
        q2.setEntity("review", (Object)review);
        return q2.list();
    }

    @Override
    public List<InlineComment> getInlineComments(Review review) {
        Query q2 = this.session().createQuery("select ic from FileRevisionExtraInfo frx join frx.inlineComments ic where frx.review = :review");
        q2.setEntity("review", (Object)review);
        return q2.list();
    }

    @Override
    public FRXComment findFrxComment(Comment comment) {
        if (comment.isRevision()) {
            Query q2 = this.session().createQuery("Select frxComment from FRXComment frxComment where frxComment.comment.id = :commentId");
            q2.setInteger("commentId", comment.getId().intValue());
            return (FRXComment)HqlUtil.getFirstResultOrNull(q2);
        }
        return null;
    }

    @Override
    public InlineComment findInlineComment(Comment comment) {
        if (comment.isRevision()) {
            Query q2 = this.session().createQuery("Select inlineComment from InlineComment inlineComment where inlineComment.comment.id = :commentId");
            q2.setInteger("commentId", comment.getId().intValue());
            return (InlineComment)HqlUtil.getFirstResultOrNull(q2);
        }
        return null;
    }

    @Override
    public FileRevisionExtraInfo getFrxForComment(Comment comment) {
        if (comment.isRevision()) {
            Query q2 = this.session().createQuery("Select inlineComment.frx from InlineComment inlineComment where inlineComment.comment.id = :commentId");
            q2.setInteger("commentId", comment.getId().intValue());
            FileRevisionExtraInfo frx = (FileRevisionExtraInfo)HqlUtil.getFirstResultOrNull(q2);
            if (frx != null) {
                return frx;
            }
            q2 = this.session().createQuery("Select frxComment.frx from FRXComment frxComment where frxComment.comment.id = :commentId");
            q2.setInteger("commentId", comment.getId().intValue());
            frx = (FileRevisionExtraInfo)HqlUtil.getFirstResultOrNull(q2);
            if (frx != null) {
                return frx;
            }
        } else if (comment.isReply()) {
            return this.getFrxForComment(comment.getReplyToComment());
        }
        return null;
    }

    @Override
    public boolean isFrxForComment(Comment comment) {
        return this.getFrxForComment(comment) != null;
    }

    @Override
    public String getFilePath(Comment comment) {
        Path path = this.getPath(comment);
        return path == null ? "" : path.getPath();
    }

    @Override
    public String getFileName(Comment comment) {
        Path path = this.getPath(comment);
        return path == null ? "" : path.getName();
    }

    private Path getPath(Comment comment) {
        FileRevisionExtraInfo frx = null;
        FRXComment rc = this.findFrxComment(comment);
        if (rc == null) {
            InlineComment ic = this.findInlineComment(comment);
            if (ic == null) {
                return null;
            }
            frx = ic.getFrx();
        } else {
            frx = rc.getFrx();
        }
        if (frx == null) {
            return null;
        }
        return frx.getFePath();
    }

    @Override
    public List<Comment> searchComments(Principal principal, CommentSearchData searchData, String selector) {
        List<Project> accessibleProjects = this.secureProjectManager.getVisibleProjects(principal);
        if (accessibleProjects.isEmpty()) {
            return Collections.emptyList();
        }
        return this.searchComments(accessibleProjects, searchData, selector);
    }

    @Override
    public Long countComments(CommentSearchData searchData) {
        return HqlUtil.getCountFromSet(this.searchComments((Collection<Project>)null, searchData, "count(distinct comment.id)"));
    }

    private List<Comment> searchComments(Collection<Project> projects, CommentSearchData searchData, String selector) {
        Object sep;
        StringBuilder builder;
        if (!Strings.isNullOrEmpty((String)searchData.getPermaId())) {
            ReviewManager reviewManager = DefaultReviewManager.get();
            if (reviewManager.reviewExists(searchData.getPermaId())) {
                Review review = reviewManager.getReviewByPermaId(searchData.getPermaId());
                searchData.setReview(review);
            } else {
                return Collections.emptyList();
            }
        }
        String where = "";
        where = HqlUtil.whereBuilder(where, "comment.draft = false", HqlUtil.Operator.AND);
        if (searchData.getPeriod().getFrom() != null) {
            where = HqlUtil.whereBuilder(where, "comment.createDateTime >= :from", HqlUtil.Operator.AND);
        }
        if (searchData.getPeriod().getTo() != null) {
            where = HqlUtil.whereBuilder(where, "comment.createDateTime <= :to", HqlUtil.Operator.AND);
        }
        if (!Strings.isNullOrEmpty((String)searchData.getText())) {
            where = HqlUtil.whereBuilder(where, "comment.message like :message", HqlUtil.Operator.AND);
        }
        if (!Strings.isNullOrEmpty((String)searchData.getAuthorName())) {
            where = HqlUtil.whereBuilder(where, "comment.user.username = :user", HqlUtil.Operator.AND);
        }
        if (searchData.getProjectId() != null) {
            where = HqlUtil.whereBuilder(where, "comment.review.project.id = :project", HqlUtil.Operator.AND);
        }
        if (projects != null && !projects.isEmpty()) {
            builder = new StringBuilder("comment.review.project.id in (");
            sep = "";
            for (Project proj : projects) {
                builder.append((String)sep).append(proj.getId());
                sep = ",";
            }
            builder.append(")");
            where = HqlUtil.whereBuilder(where, builder.toString(), HqlUtil.Operator.AND);
        }
        if (searchData.getReview() != null) {
            where = HqlUtil.whereBuilder(where, "comment.review = :review", HqlUtil.Operator.AND);
        }
        if (searchData.getReviewsIds() != null && !searchData.getReviewsIds().isEmpty()) {
            builder = new StringBuilder("comment.review.id in (");
            sep = "";
            for (Integer r2 : searchData.getReviewsIds()) {
                builder.append((String)sep).append(r2);
                sep = ",";
            }
            builder.append(" )");
            where = HqlUtil.whereBuilder(where, builder.toString(), HqlUtil.Operator.AND);
        }
        if (searchData.getPath() != null && Strings.isNullOrEmpty((String)searchData.getRepoName())) {
            where = HqlUtil.whereBuilder(where, "frxRevision.revision.storedPath.path like :path", HqlUtil.Operator.AND);
            where = HqlUtil.whereBuilder(where, "frxRevision.revision.sourceName = :repoName", HqlUtil.Operator.AND);
            where = HqlUtil.whereBuilder(where, "comment.review.id = review.id", HqlUtil.Operator.AND);
        }
        if (searchData.getState() != null && searchData.getState().length > 0) {
            where = HqlUtil.whereBuilder(where, "comment.review.stateName IN (:reviewStateName)", HqlUtil.Operator.AND);
        }
        if (searchData.isComments() && !searchData.isDefects()) {
            where = HqlUtil.whereBuilder(where, "comment.defectRaised != true", HqlUtil.Operator.AND);
        }
        if (!searchData.isComments() && searchData.isDefects()) {
            where = HqlUtil.whereBuilder(where, "comment.defectRaised = true", HqlUtil.Operator.AND);
        }
        if (searchData.isNotDeleted()) {
            where = HqlUtil.whereBuilder(where, "comment.deleted = false", HqlUtil.Operator.AND);
        }
        int i2 = 0;
        for (CommentSearchData.MetricDO mdo : searchData.getMetrics()) {
            if (!mdo.isSelected()) continue;
            where = HqlUtil.whereBuilder(where, "field" + ++i2 + ".name = '" + mdo.getMetricName() + "'", HqlUtil.Operator.AND);
            where = HqlUtil.whereBuilder(where, "field" + i2 + ".intVal = " + mdo.getFieldId(), HqlUtil.Operator.AND);
        }
        StringBuilder qstr = new StringBuilder("select ").append(selector).append(" from Comment comment ");
        for (int j2 = 1; j2 <= i2; ++j2) {
            qstr.append("join comment.fieldList field").append(j2).append(" ");
        }
        if (searchData.getPath() != null && Strings.isNullOrEmpty((String)searchData.getRepoName())) {
            qstr.append("join comment.review review join review.frxs frx join frx.frxRevisions frxRevision ");
        }
        qstr.append(where);
        if (searchData.getOrderBy() != null) {
            qstr.append(" order by ").append(searchData.getOrderBy().getFieldName()).append(searchData.getOrderBy().isDesc() ? " desc " : " ");
        }
        Query q2 = this.session().createQuery(qstr.toString());
        if (searchData.getPeriod().getFrom() != null) {
            q2.setLong("from", searchData.getPeriod().getFrom().getTime());
        }
        if (searchData.getPeriod().getTo() != null) {
            q2.setLong("to", searchData.getPeriod().getTo().getTime());
        }
        if (!Strings.isNullOrEmpty((String)searchData.getText())) {
            q2.setString("message", "%" + searchData.getText() + "%");
        }
        if (!Strings.isNullOrEmpty((String)searchData.getAuthorName())) {
            q2.setString("user", searchData.getAuthorName());
        }
        if (searchData.getProjectId() != null) {
            q2.setInteger("project", searchData.getProjectId().intValue());
        }
        if (searchData.getReview() != null) {
            q2.setEntity("review", (Object)searchData.getReview());
        }
        if (searchData.getPath() != null && Strings.isNullOrEmpty((String)searchData.getRepoName())) {
            q2.setString("path", StringUtil.escapeSQL(searchData.getPath()) + "%");
            q2.setString("repoName", searchData.getRepoName());
        }
        if (searchData.getState() != null && searchData.getState().length > 0) {
            q2.setParameterList("reviewStateName", (Object[])searchData.getState());
        }
        if (searchData.getMaxResults() != null) {
            q2.setMaxResults(searchData.getMaxResults().intValue());
        }
        return q2.list();
    }

    @Override
    public long countCommentsOnDay(Date day, boolean defects, Project project) {
        TimeZone tz = AppConfig.getsConfig().getTimezone();
        return this.countComments(DateHelper.getStartOfDay(day, tz), DateHelper.getEndOfDay(day, tz), defects, project);
    }

    @Override
    public long countComments(Date from, Date to, boolean defects, Project project) {
        String where = null;
        where = HqlUtil.whereBuilder(where, "review.project = :project", "and");
        where = HqlUtil.whereBuilder(where, "comment.createDateTime >= :from", "and");
        where = HqlUtil.whereBuilder(where, "comment.createDateTime < :to", "and");
        where = HqlUtil.whereBuilder(where, "comment.draft = false", "and");
        where = HqlUtil.whereBuilder(where, "comment.deleted = false", "and");
        if (defects) {
            where = HqlUtil.whereBuilder(where, "(comment.defectRaised = true", "and");
            where = HqlUtil.whereBuilder(where, "comment.defectApproved = true)", "or");
        } else {
            where = HqlUtil.whereBuilder(where, "(comment.defectRaised = false", "and");
            where = HqlUtil.whereBuilder(where, "comment.defectApproved = false)", "and");
        }
        String qstr = "select count(distinct comment.id) from Comment comment join comment.review review " + where;
        Query q2 = this.session().createQuery(qstr);
        q2.setLong("to", to.getTime());
        q2.setLong("from", from.getTime());
        q2.setEntity("project", (Object)project);
        return (Long)q2.uniqueResult();
    }

    @Override
    public void publishCommentAndAnnounce(Comment comment) {
        if (comment.isReply() && !comment.getReplyToComment().isVisibleToAll()) {
            throw new IllegalArgumentException("Can't post replies to drafts.");
        }
        if (!comment.isDraft()) {
            throw new IllegalArgumentException(String.format("Can't post draft comment %s since it is not a draft.", comment.getPermaId()));
        }
        comment.setDraft(false);
        LogItem logItem = LogItemBuilder.buildCommentAdded(comment.getReview(), comment);
        this.logItemManager.addLogItem(logItem);
        this.announceCommentUpdate(comment, comment.getMessage(), true);
    }

    @Override
    public void announceCommentCreation(Comment comment) {
        this.eventPublisher.publish((Object)new CommentCreatedEventImpl(comment.getReview().getPermId(), this.spiUserUtils.createUserData(comment.getUser()), comment.getPermId(), comment.isDraft(), comment.getReview().getType()));
    }

    @Override
    public void announceCommentUpdate(Comment comment, String oldText, boolean wasDraft) {
        this.eventPublisher.publish((Object)new CommentUpdatedEventImpl(comment.getReview().getPermId(), this.spiUserUtils.createUserData(comment.getUser()), comment.getPermId(), oldText, wasDraft, comment.isDraft(), comment.getReview().getType()));
    }

    @Override
    public void announceCommentDeletion(Comment comment) {
        this.eventPublisher.publish((Object)new CommentDeletedEventImpl(comment.getReview().getPermId(), this.spiUserUtils.createUserData(comment.getUser()), comment.getPermId(), comment.getReview().getType()));
    }

    @Override
    public void publishDraftCommentsAndAnnounce(Review review, FecruUser user) {
        this.comments(review).where(DiscussionClauses.and(DiscussionClauses.draft(user), DiscussionClauses.not(DiscussionClauses.deleted()), new DiscussionClause[0])).visit(comment -> this.publishCommentAndAnnounce(comment));
    }

    @Override
    public List<DefectReportDO> getDefectReports(Project project, Period period, String metric) {
        CommentSearchData sd = new CommentSearchData(DefaultReviewManager.get());
        sd.setProjectId(project.getId());
        sd.setPeriod(period);
        sd.setDefects(true);
        return this.getDefectReports(sd, metric);
    }

    @Override
    public List<DefectReportDO> getDefectReports(CommentSearchData sd, String metric) {
        ArrayList<DefectReportDO> defectReps = new ArrayList<DefectReportDO>();
        Collection<CommentSearchData.MetricDO> mdos = sd.getMetrics();
        if (mdos != null) {
            long otherDefects = this.countComments(sd);
            for (CommentSearchData.MetricDO mdo : mdos) {
                if (!mdo.getMetricName().equals(metric)) continue;
                sd.setMetric(mdo.getId(), true);
                DefectReportDO dr = this.getDefectReport(sd, mdo);
                defectReps.add(dr);
                sd.setMetric(mdo.getId(), false);
                otherDefects -= dr.getCount().longValue();
            }
            defectReps.add(new DefectReportDO(metric, "Unclassified", otherDefects));
        }
        return defectReps;
    }

    @Override
    public DefectReportDO getDefectReport(CommentSearchData sd, CommentSearchData.MetricDO mdo) {
        long numberOfComments = this.countComments(sd);
        return new DefectReportDO(mdo.getMetricLabel(), mdo.getFieldName(), numberOfComments);
    }

    public static class CommentPairComparator
    implements Comparator<InlineComment> {
        @Override
        public int compare(InlineComment c1, InlineComment c2) {
            if (c1 == null) {
                if (c2 == null) {
                    return 0;
                }
                return 1;
            }
            if (c2 == null) {
                return -1;
            }
            return CompareUtil.compareTo(c1.getHighestLineNumber(), c2.getHighestLineNumber());
        }
    }

    private static class SearchOpts {
        Review review;
        FileRevisionExtraInfo frx;
        Boolean defect;
        Boolean deleted = false;
        Boolean draft = false;
        FecruUser author;
        String commentTable;
        Boolean readStatus;
        FecruUser readUser;
        static final String INLINE_COMMENT_TABLE = "InlineComment";
        static final String FRX_COMMENT_TABLE = "FRXComment";

        private SearchOpts() {
        }

        boolean checkReadUser() {
            return this.readStatus != null && this.readUser != null;
        }

        String addJoins(String comment) {
            StringBuilder joins = new StringBuilder();
            joins.append(this.review != null ? ", Review review join review.frxs frx" : "");
            joins.append(this.readStatus != null ? " join " + comment + ".commentReadStatus crs" : "");
            return joins.toString();
        }

        String addRestrictions(String comment) {
            StringBuilder conds = new StringBuilder();
            conds.append(this.review != null ? " review = :review and frx = c.frx" : "");
            conds.append(this.frx != null ? " c.frx = :frx" : "");
            conds.append(this.author != null ? " and " + comment + ".user = :author" : "");
            conds.append(this.defect != null ? " and " + comment + ".defectRaised = :defect" : "");
            conds.append(this.draft != null ? " and " + comment + ".draft = :draft" : "");
            conds.append(this.deleted != null ? " and " + comment + ".deleted = :deleted" : "");
            conds.append(this.readStatus != null ? " and crs.read = :readStatus" : "");
            conds.append(this.checkReadUser() ? " and crs.user = :readUser" : "");
            return conds.toString();
        }

        Query bindParameters(Query q2) {
            if (this.review != null) {
                q2.setEntity("review", (Object)this.review);
            }
            if (this.frx != null) {
                q2.setEntity("frx", (Object)this.frx);
            }
            if (this.author != null) {
                q2.setEntity("author", (Object)this.author);
            }
            if (this.defect != null) {
                q2.setBoolean("defect", this.defect.booleanValue());
            }
            if (this.draft != null) {
                q2.setBoolean("draft", this.draft.booleanValue());
            }
            if (this.deleted != null) {
                q2.setBoolean("deleted", this.deleted.booleanValue());
            }
            if (this.readStatus != null) {
                q2.setBoolean("readStatus", this.readStatus.booleanValue());
            }
            if (this.checkReadUser()) {
                q2.setEntity("readUser", (Object)this.readUser);
            }
            return q2;
        }
    }
}

