/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ActionManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.fisheye.config.SpringContext;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="actionManager")
public class DefaultActionManager
implements ActionManager {
    public static ActionManager getInstance() {
        return (ActionManager)SpringContext.getComponent("actionManager");
    }

    @Override
    public void doAction(String action, FecruUser user, Review review) {
        if (action.startsWith("markReviewed")) {
            this.markReviewed(review);
        } else if (action.startsWith("cleanup")) {
            review.cleanupAllComments();
        }
    }

    private void markReviewed(Review review) {
        List<FileRevisionExtraInfo> frxs = FRXManager.getFRXs(review, null, false);
        Iterator<FileRevisionExtraInfo> iterator = frxs.iterator();
        while (iterator.hasNext()) {
            FileRevisionExtraInfo frx1;
            FileRevisionExtraInfo frx = frx1 = iterator.next();
            frx.setReviewed(0);
        }
    }
}

