/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.GroupManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="crucibleUserManager")
@Deprecated
public class CrucibleUserManager
implements GroupManager {
    private final GroupMembershipManager groupMembershipManager;

    @Autowired
    public CrucibleUserManager(GroupMembershipManager groupMembershipManager) {
        this.groupMembershipManager = groupMembershipManager;
    }

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static FecruUser getUserByName(String userName) {
        if (userName == null) {
            return null;
        }
        return SpringContext.getComponent(UserManager.class, "userManager").getUser(userName);
    }

    public FecruUser findUserByName(String userName) throws DbException {
        return CrucibleUserManager.getUserByName(userName);
    }

    private List<FecruUser> usernamesToUsers(List<String> names) throws DbException {
        ArrayList<FecruUser> users = new ArrayList<FecruUser>(names.size());
        for (String name : names) {
            users.add(this.findUserByName(name));
        }
        Collections.sort(users, new Comparator<FecruUser>(){

            @Override
            public int compare(FecruUser o1, FecruUser o2) {
                return StringComparator.IGNORE_CASE_INSTANCE.compare(o1.getDisplayName(), o2.getDisplayName());
            }
        });
        return Collections.unmodifiableList(users);
    }

    public List<FecruUser> getGroupOfUsers(String groupName) throws DbException {
        return this.usernamesToUsers(this.groupMembershipManager.getUsersInGroup(groupName).stream().map(user -> user.getUsername()).collect(Collectors.toList()));
    }

    @Override
    public List<String> getPrincipalGroups(Principal p2) throws DbException {
        return this.groupMembershipManager.getGroupsForUser(p2.getUserName());
    }

    public static FecruUser getUserById(Integer id) {
        if (id == null) {
            return null;
        }
        return (FecruUser)CrucibleUserManager.session().get(FecruUser.class, (Serializable)id);
    }
}

