/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class CrucibleActivityItemParameter {
    private final ActivityItemKey key;
    private final Operator operator;
    private final Set<?> values;

    private CrucibleActivityItemParameter(Builder builder) {
        this.key = builder.key;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public static Builder builder(ActivityItemKey key, Operator operator) {
        return new Builder(key, operator);
    }

    public ActivityItemKey getKey() {
        return this.key;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Set<?> getValues() {
        return this.values;
    }

    public static enum Operator {
        EQ,
        NOT,
        IN,
        NOT_IN,
        GT,
        GE,
        LT,
        LE,
        IS_EMPTY,
        IS_NOT_EMPTY,
        IS_NULL,
        IS_NOT_NULL;

    }

    public static enum ActivityItemKey {
        REVIEW_ID("reviewId"),
        PROJECT_KEY("project.projKey"),
        USER_ID("userId"),
        USERNAME("userId"),
        ACTION("action"),
        LOG_ACTION("action"),
        CREATE_DATE("createDateTime");

        private String key;

        private ActivityItemKey(String key) {
            this.key = key;
        }

        public String value() {
            return this.key;
        }
    }

    public static class Builder {
        private final ActivityItemKey key;
        private final Operator operator;
        private Set<?> values;

        private Builder(ActivityItemKey key, Operator operator) {
            this.key = (ActivityItemKey)((Object)Preconditions.checkNotNull((Object)((Object)key), (Object)"key"));
            this.operator = (Operator)((Object)Preconditions.checkNotNull((Object)((Object)operator), (Object)"operator"));
            this.values = ImmutableSet.of();
        }

        public Builder values(Iterable<?> v2) {
            if (v2 != null) {
                if (this.values != null && !this.values.isEmpty()) {
                    throw new IllegalArgumentException("'values' is already set");
                }
                this.values = ImmutableSet.copyOf(v2);
            } else {
                this.values = ImmutableSet.of();
            }
            return this;
        }

        public Builder value(Object v2) {
            if (v2 != null) {
                if (this.values != null && !this.values.isEmpty()) {
                    throw new IllegalArgumentException("'values' is already set");
                }
                this.values = ImmutableSet.of((Object)v2);
            }
            return this;
        }

        public CrucibleActivityItemParameter build() {
            return new CrucibleActivityItemParameter(this);
        }
    }
}

