/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.actions.search.comment.CommentSearchData;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.discussion.DiscussionBrowser;
import com.cenqua.crucible.model.discussion.FRXDiscussionBrowser;
import com.cenqua.crucible.model.discussion.ReviewDiscussionBrowser;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public interface CommentManager {
    public ReviewDiscussionBrowser comments(Review var1);

    public FRXDiscussionBrowser comments(FileRevisionExtraInfo var1);

    public DiscussionBrowser comments(Comment var1);

    public Comment createComment(String var1, Review var2, FecruUser var3);

    public Comment getById(Integer var1);

    public List<Comment> getByIds(Collection<Integer> var1);

    public Comment getByPermId(PermId<CommentData> var1);

    public void deleteCommentAndAnnounce(Comment var1, Review var2);

    public void deleteComment(Comment var1) throws IllegalArgumentException;

    public List<Comment> getReviewComments(Review var1, FecruUser var2, Boolean var3, Boolean var4, Boolean var5);

    public void cleanReviewComments(Review var1);

    public int getReviewCommentCount(Review var1, FecruUser var2, Boolean var3, Boolean var4, Boolean var5, FecruUser var6);

    public int countReviewGeneralComment(Review var1, FecruUser var2, Boolean var3, Boolean var4, Boolean var5);

    public int getReviewFrxsCommentCount(Review var1, FecruUser var2, Boolean var3, Boolean var4, Boolean var5);

    public int getFrxCommentCount(FileRevisionExtraInfo var1);

    public List<FRXComment> getFrxComments(Review var1);

    public List<InlineComment> getInlineComments(Review var1);

    public FRXComment findFrxComment(Comment var1);

    public InlineComment findInlineComment(Comment var1);

    public FileRevisionExtraInfo getFrxForComment(Comment var1);

    public boolean isFrxForComment(Comment var1);

    public String getFilePath(Comment var1);

    public String getFileName(Comment var1);

    public List<Comment> searchComments(Principal var1, CommentSearchData var2, String var3);

    public Long countComments(CommentSearchData var1);

    public long countCommentsOnDay(Date var1, boolean var2, Project var3);

    public long countComments(Date var1, Date var2, boolean var3, Project var4);

    public void publishCommentAndAnnounce(Comment var1);

    public void announceCommentCreation(Comment var1);

    public void announceCommentUpdate(Comment var1, String var2, boolean var3);

    public void announceCommentDeletion(Comment var1);

    public void publishDraftCommentsAndAnnounce(Review var1, FecruUser var2);

    public List<DefectReportDO> getDefectReports(Project var1, Period var2, String var3);

    public List<DefectReportDO> getDefectReports(CommentSearchData var1, String var2);

    public DefectReportDO getDefectReport(CommentSearchData var1, CommentSearchData.MetricDO var2);
}

