/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.discussion;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.regex.Pattern;

public final class DiscussionClauses {
    private static final DiscussionClause IS_TRUE = new DiscussionClause(){

        @Override
        public boolean test(Comment comment, int depth) {
            return true;
        }
    };

    private DiscussionClauses() {
    }

    public static DiscussionClause isTrue() {
        return IS_TRUE;
    }

    public static DiscussionClause deleted() {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return comment.isDeleted();
            }
        };
    }

    public static DiscussionClause draft() {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return comment.isDraft();
            }
        };
    }

    public static DiscussionClause draft(FecruUser user) {
        return DiscussionClauses.and(DiscussionClauses.author(user), DiscussionClauses.draft(), new DiscussionClause[0]);
    }

    public static DiscussionClause defect() {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return comment.isDefectRaised();
            }
        };
    }

    public static DiscussionClause hasJira() {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return !Strings.isNullOrEmpty((String)comment.getJiraIssueKey());
            }
        };
    }

    public static DiscussionClause contains(String regexp) {
        final Pattern pattern = Pattern.compile(regexp);
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return pattern.matcher(comment.getMessage()).matches();
            }
        };
    }

    public static DiscussionClause createdBefore(final Date date, final boolean inclusive) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                int diff = comment.getCreateDate().compareTo(date);
                return inclusive ? diff <= 0 : diff < 0;
            }
        };
    }

    public static DiscussionClause createdAfter(final Date date, final boolean inclusive) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                int diff = comment.getCreateDate().compareTo(date);
                return inclusive ? diff >= 0 : diff > 0;
            }
        };
    }

    public static DiscussionClause author(final FecruUser user) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return comment.getUser() == null ? user == null : comment.getUser().equals(user);
            }
        };
    }

    public static DiscussionClause unread(FecruUser user) {
        return DiscussionClauses.not(DiscussionClauses.read(user));
    }

    public static DiscussionClause read(final FecruUser user) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return comment.isRead(user);
            }
        };
    }

    public static DiscussionClause and(final DiscussionClause clause1, final DiscussionClause clause2, final DiscussionClause ... clauses) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                if (clause1.test(comment, depth) && clause2.test(comment, depth)) {
                    for (DiscussionClause p2 : clauses) {
                        if (p2.test(comment, depth)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static DiscussionClause or(final DiscussionClause clause1, final DiscussionClause clause2, final DiscussionClause ... clauses) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                if (clause1.test(comment, depth) || clause2.test(comment, depth)) {
                    return true;
                }
                if (clauses != null) {
                    for (DiscussionClause p2 : clauses) {
                        if (!p2.test(comment, depth)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static DiscussionClause not(final DiscussionClause clause) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return !clause.test(comment, depth);
            }
        };
    }

    public static DiscussionClause visibleToAll() {
        return DiscussionClauses.and(DiscussionClauses.not(DiscussionClauses.deleted()), DiscussionClauses.not(DiscussionClauses.draft()), new DiscussionClause[0]);
    }

    public static DiscussionClause visibleTo(final FecruUser user) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int depth) {
                return comment.isVisible(user);
            }
        };
    }

    public static DiscussionClause depth(final int depth) {
        return new DiscussionClause(){

            @Override
            public boolean test(Comment comment, int currentDepth) {
                return depth == currentDepth;
            }
        };
    }
}

