/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.dao.StateChangeLogDAO;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateStateChangeLogDAO
implements StateChangeLogDAO {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public HibernateStateChangeLogDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void add(StateChangeLog stateChangeLog) {
        this.session().save((Object)stateChangeLog);
    }

    @Override
    public void delete(StateChangeLog stateChangeLog) {
        this.session().delete((Object)stateChangeLog);
    }

    @Override
    public Map<String, Long> countStatesOn(Date date, Project project) {
        String qstr = "select log from StateChangeLog log where log.reviewId in (select review.id from Review review where review.project = :project) and log.dateTimeStamp < :date order by log.dateTimeStamp desc";
        Query q2 = this.session().createQuery(qstr);
        q2.setLong("date", date.getTime());
        q2.setEntity("project", (Object)project);
        List logs = q2.list();
        HashSet<Integer> reviews = new HashSet<Integer>();
        Object2LongOpenHashMap stateCounts = new Object2LongOpenHashMap();
        stateCounts.defaultReturnValue(0L);
        for (StateChangeLog log : logs) {
            if (reviews.contains(log.getReviewId())) continue;
            long count = stateCounts.getLong((Object)log.getNewState());
            stateCounts.put((Object)log.getNewState(), ++count);
            reviews.add(log.getReviewId());
        }
        return stateCounts;
    }

    @Override
    public List<StateChangeLog> list(Date from, Date to, Project project) {
        String qstr = "select log from StateChangeLog log, Review review where log.dateTimeStamp < :to and (log.supersededTime = null or log.supersededTime > :from) and review.id = log.reviewId and review.project = :project order by log.reviewId, log.dateTimeStamp";
        Query q2 = this.session().createQuery(qstr);
        q2.setLong("to", to.getTime());
        q2.setLong("from", from.getTime());
        q2.setEntity("project", (Object)project);
        return HibernateUtil.typedList(q2);
    }
}

