/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.fugue.Option;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewProperty;
import com.cenqua.crucible.model.dao.ReviewPropertyDAO;
import com.cenqua.crucible.model.dao.ReviewPropertyDAOSearchCriteria;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateReviewPropertyDAO
implements ReviewPropertyDAO {
    private final CurrentSessionProvider currentSessionProvider;
    private static final Pattern VALID_LIKE_PREFIX = Pattern.compile("[^_%\\[\\]]*");

    @Autowired
    public HibernateReviewPropertyDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    @Override
    public Option<ReviewProperty> get(Review review, String name) {
        if (review == null || name == null) {
            return Option.none();
        }
        ReviewPropertyDAOSearchCriteria searchCriteria = new ReviewPropertyDAOSearchCriteria(review, Collections.singleton(name), null, null, 1);
        return Option.option((Object)Iterables.getFirst(this.list(searchCriteria), null));
    }

    @Override
    public Option<String> put(Review review, String name, String value) {
        Option<ReviewProperty> reviewProperty = this.get(review, name);
        if (reviewProperty.isEmpty()) {
            if (value != null) {
                this.session().save((Object)new ReviewProperty(review, name, value));
            }
            return Option.none();
        }
        String oldValue = ((ReviewProperty)reviewProperty.get()).getValue();
        if (value != null) {
            ((ReviewProperty)reviewProperty.get()).setValue(value);
            this.session().save(reviewProperty.get());
        } else {
            this.session().delete(reviewProperty.get());
        }
        return Option.some((Object)oldValue);
    }

    @Override
    public Option<String> remove(Review review, String name) {
        Option<ReviewProperty> reviewProperty = this.get(review, name);
        if (!reviewProperty.isEmpty()) {
            this.session().delete(reviewProperty.get());
            return Option.some((Object)((ReviewProperty)reviewProperty.get()).getValue());
        }
        return Option.none();
    }

    @Override
    public int remove(Review review) {
        Query query = this.session().createQuery("delete from ReviewProperty where review=?").setEntity(0, (Object)review);
        return query.executeUpdate();
    }

    @Override
    public List<ReviewProperty> list(ReviewPropertyDAOSearchCriteria searchCriteria) {
        Iterable<String> reviewStates;
        String namePrefix;
        Criteria criteria = this.session().createCriteria(ReviewProperty.class);
        if (searchCriteria.getReview() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"review", (Object)searchCriteria.getReview()));
        }
        if (searchCriteria.getNames() != null && !Iterables.isEmpty(searchCriteria.getNames())) {
            criteria.add(Restrictions.in((String)"name", (Collection)ImmutableList.copyOf(searchCriteria.getNames())));
        }
        if (!Strings.isNullOrEmpty((String)(namePrefix = searchCriteria.getNamePrefix()))) {
            HibernateReviewPropertyDAO.validateLikePrefix(namePrefix);
            criteria.add((Criterion)Restrictions.like((String)"name", (Object)(namePrefix + '%')));
        }
        if ((reviewStates = searchCriteria.getReviewStateNames()) != null && !Iterables.isEmpty(reviewStates)) {
            criteria.createAlias("review_property_name.review", "r");
            criteria.add(Restrictions.in((String)"r.stateName", (Collection)ImmutableList.copyOf(reviewStates)));
        }
        if (searchCriteria.getLimit() != Integer.MAX_VALUE) {
            criteria.setMaxResults(searchCriteria.getLimit());
        }
        return criteria.list();
    }

    static void validateLikePrefix(String namePrefix) {
        Preconditions.checkArgument((boolean)VALID_LIKE_PREFIX.matcher(namePrefix).matches(), (Object)"Property name prefix cannot contain '%', '_', '[' or ']' characters");
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }
}

