/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.dao.ReviewPermaIdDAO;
import com.cenqua.fisheye.logging.Logs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateReviewPermaIdDAO
implements ReviewPermaIdDAO {
    private static final Logger log = Logs.loggerFor(HibernateReviewPermaIdDAO.class);
    private final CurrentSessionProvider currentSessionProvider;
    private static final String DEFAULT_ORDER_PROPERTY = "id";

    @Autowired
    public HibernateReviewPermaIdDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void add(ReviewPermaId reviewPermaId) {
        this.session().save((Object)reviewPermaId);
    }

    @Override
    public void delete(ReviewPermaId reviewPermaId) {
        this.session().delete((Object)reviewPermaId);
    }

    @Override
    public boolean deleteWithProjectKey(String projectKey) {
        Query q2 = this.session().createQuery("delete ReviewPermaId where permaIdKey.projKey = :projectKey");
        q2.setString("projectKey", projectKey);
        return q2.executeUpdate() > 0;
    }

    @Override
    public ReviewPermaId getByPermaIdKey(PermaIdKey permaIdKey) {
        return (ReviewPermaId)this.session().get(ReviewPermaId.class, (Serializable)permaIdKey);
    }

    @Override
    public Integer getMaxNumberForProject(String projectKey) {
        return (Integer)this.session().createCriteria(ReviewPermaId.class).add((Criterion)Restrictions.eq((String)"permaIdKey.projKey", (Object)projectKey).ignoreCase()).setProjection((Projection)Projections.max((String)"permaIdKey.number")).uniqueResult();
    }

    @Override
    public List<String> listProjectKeys() {
        LinkedHashSet result = new LinkedHashSet();
        Query q2 = this.session().createQuery("select distinct p.permaIdKey.projKey from ReviewPermaId p");
        q2.setCacheable(true);
        result.addAll(HibernateUtil.typedList(q2));
        return new ArrayList<String>(result);
    }

    @Override
    public List<ReviewPermaId> listWithReview(Review review) {
        Criteria criteria = this.session().createCriteria(ReviewPermaId.class);
        criteria.add((Criterion)Restrictions.eq((String)"review", (Object)review));
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public List<ReviewPermaId> listWithProjectKey(String projectKey) {
        Query q2 = this.session().createQuery("from ReviewPermaId where permaIdKey.projKey = :projectKey");
        q2.setString("projectKey", projectKey);
        return HibernateUtil.typedList(q2);
    }

    @Override
    public Review getReviewByPermaId(PermaIdKey permaIdKey) {
        Query q2 = this.session().createQuery("select rpid.review from ReviewPermaId rpid where rpid.permaIdKey.projKey = :projKey and rpid.permaIdKey.number = :number");
        q2.setString("projKey", permaIdKey.getProjKey());
        q2.setInteger("number", permaIdKey.getNumber());
        return (Review)q2.uniqueResult();
    }
}

