/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateReviewDAO
implements ReviewDAO {
    private static final Joiner JOINER_ON_AND = Joiner.on((String)" and ");
    private final CurrentSessionProvider currentSessionProvider;
    private static final String DEFAULT_ORDER_PROPERTY = "id";

    @Autowired
    public HibernateReviewDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void ensureInSession(Review review) {
        if (review != null && !this.session().contains((Object)review)) {
            throw new IllegalStateException("Review not in session: " + review);
        }
    }

    @Override
    public void add(Review review) {
        this.session().save((Object)review);
    }

    @Override
    public void delete(Review review) {
        this.session().delete((Object)review);
    }

    @Override
    public Review getById(Integer reviewId) {
        return (Review)this.session().get(Review.class, (Serializable)reviewId);
    }

    @Override
    public Review getReviewByPermaId(PermaIdKey permaIdKey) {
        ReviewPermaId reviewPermaId = (ReviewPermaId)this.session().createCriteria(ReviewPermaId.class).add((Criterion)Restrictions.eq((String)"permaIdKey.projKey", (Object)permaIdKey.getProjKey())).add((Criterion)Restrictions.eq((String)"permaIdKey.number", (Object)permaIdKey.getNumber())).uniqueResult();
        return reviewPermaId.getReview();
    }

    @Override
    public List<Review> list() {
        Criteria criteria = this.session().createCriteria(Review.class);
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public List<Review> listWithProject(Project project, int start, int limit) {
        Criteria criteria = this.session().createCriteria(Review.class);
        criteria.add((Criterion)Restrictions.eq((String)"project", (Object)project));
        criteria.setFirstResult(start);
        criteria.setMaxResults(limit);
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public List<Review> listWithProject(Project project) {
        Criteria criteria = this.session().createCriteria(Review.class);
        criteria.add((Criterion)Restrictions.eq((String)"project", (Object)project));
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public List<Review> listWithJiraIssueKey(String jiraIssueKey) {
        Criteria criteria = this.session().createCriteria(Review.class);
        criteria.add((Criterion)Restrictions.eq((String)"jiraIssueKey", (Object)jiraIssueKey));
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public int countReviewsInProject(Project project) {
        Criteria criteria = this.session().createCriteria(Review.class);
        criteria.add((Criterion)Restrictions.eq((String)"project", (Object)project));
        criteria.setProjection(Projections.rowCount());
        Number v2 = (Number)criteria.uniqueResult();
        return v2 == null ? 0 : v2.intValue();
    }

    @Override
    public List<Review> listReviewsInStateOrderedByCreateDateTime(String[] states, boolean inState) {
        StringBuilder query = new StringBuilder("select review from Review review where ");
        query.append(this.makeSelectReviewsByStateFrag(states, inState));
        query.append(" order by review.createDateTime");
        Query q2 = this.session().createQuery(query.toString());
        return HibernateUtil.typedList(q2);
    }

    @Override
    public List<Review> listReviewsByDueDate(Project p2, Date dueBefore) {
        ReviewFilterDef filterDef = new ReviewFilters(p2).getFilterDefByKey(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS);
        String stateFrag = this.makeSelectReviewsByStateFrag(filterDef.state, true);
        Query q2 = this.session().createQuery("select review from Review review where " + (p2 != null ? "review.project = :p and " : "") + (stateFrag == null ? "" : stateFrag + " and ") + "review.dueDateTime < :dueBefore order by review.dueDateTime");
        if (p2 != null) {
            q2.setEntity("p", (Object)p2);
        }
        q2.setLong("dueBefore", dueBefore.getTime());
        return q2.list();
    }

    private String makeSelectReviewsByStateFrag(String[] states, boolean inState) {
        if (states == null || states.length == 0) {
            return null;
        }
        String cond = inState ? "=" : "<>";
        String logic = inState ? "or" : "and";
        StringBuilder qstr = new StringBuilder("(review.stateName ").append(cond).append(" '").append(states[0]).append("' ");
        for (int i2 = 1; i2 < states.length; ++i2) {
            String state = states[i2];
            qstr.append(logic).append(" review.stateName ").append(cond).append(" '").append(state).append("' ");
        }
        return qstr.append(")").toString();
    }

    @Override
    public Object2LongMap<String> getReviewCountForUsers(Path path, String repoName, Set<String> users) {
        boolean hasUsers;
        boolean shouldConstrain = path != null && !StringUtils.isEmpty((String)repoName);
        StringBuilder query = new StringBuilder("select count(distinct r.id), rp.user.username");
        query.append(" from ReviewParticipant rp join rp.review r");
        if (shouldConstrain) {
            query.append(" join r.frxs frx join frx.frxRevisions frxRev");
        }
        query.append(" where (r.stateName = 'Closed' or r.stateName = 'Review' or r.stateName = 'Summarize')");
        if (shouldConstrain) {
            query.append(" and (frxRev.revision.storedPath.path = :path or frxRev.revision.storedPath.path like :subPath)");
            query.append(" and frxRev.revision.sourceName = :repoName ");
        }
        boolean bl = hasUsers = users != null && !users.isEmpty();
        if (hasUsers) {
            query.append(" and rp.user.username in (:users)");
        }
        query.append(" group by rp.user.username");
        Query q2 = this.session().createQuery(query.toString());
        if (shouldConstrain) {
            String subPath = path.isRoot() ? "%" : StringUtil.escapeSQL(path) + "/%";
            q2.setString("path", StringUtil.escapeSQL(path));
            q2.setString("subPath", subPath);
            q2.setString("repoName", repoName);
        }
        Object2LongOpenHashMap result = new Object2LongOpenHashMap();
        StoppableVisitor<Object[]> resultCollector = new StoppableVisitor<Object[]>((Object2LongMap)result){
            final /* synthetic */ Object2LongMap val$result;
            {
                this.val$result = object2LongMap;
            }

            @Override
            public boolean visit(Object[] row) {
                Long count = (Long)row[0];
                String username = (String)row[1];
                this.val$result.put((Object)username, (Object)count);
                return true;
            }
        };
        if (hasUsers) {
            HqlBatchedInClauseHelper usersBatchHelper = new HqlBatchedInClauseHelper(q2, "users", Lists.newArrayList(users));
            usersBatchHelper.execute(resultCollector, false);
        } else {
            List queryResult = q2.list();
            for (Object[] row : queryResult) {
                resultCollector.visit(row);
            }
        }
        return result;
    }

    @Override
    public List searchReviewForTerms(List<String> terms, String selector, String grouper, Integer limit, String projectKey) {
        if (terms.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> termQueries = new ArrayList<String>();
        int termCounter = 0;
        for (String term : terms) {
            Review r2 = null;
            PermaIdKey permaKey = PermaIdKey.parsePermaId(term);
            if (permaKey != null) {
                r2 = this.getReviewByPermaId(permaKey);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(lower(review.name) like :term" + termCounter + " ").append("or lower(review.description) like :term" + termCounter + " ").append("or lower(proj.projKey) like :term" + termCounter + " ");
            if (StateManager.INSTANCE.isStateName(term)) {
                sb.append("or review.stateName = :stateName" + termCounter + " ");
            }
            if (r2 != null) {
                sb.append("or review.id = ").append(r2.getId());
            }
            sb.append(")");
            termQueries.add(sb.toString());
            ++termCounter;
        }
        String termQuery = JOINER_ON_AND.join(termQueries);
        String qstr = "select " + selector + " " + "from Review review join review.project proj where " + "( " + termQuery + ") and review.stateName <> :deadStateName " + (projectKey == null ? "" : " and proj.projKey = :projectKey ") + (grouper != null ? "group by " + grouper : "") + " order by review.id desc";
        try {
            Query q2 = this.session().createQuery(qstr);
            if (limit != null) {
                q2.setMaxResults(limit.intValue());
            }
            q2.setString("deadStateName", StateManager.INSTANCE.getDeadState().getName());
            if (projectKey != null) {
                q2.setString("projectKey", projectKey);
            }
            termCounter = 0;
            for (String term : terms) {
                q2.setString("term" + termCounter, "%" + term.toLowerCase(Locale.US) + "%");
                if (StateManager.INSTANCE.isStateName(term)) {
                    q2.setString("stateName" + termCounter, StateManager.INSTANCE.getStateByName(term).getName());
                }
                ++termCounter;
            }
            return q2.list();
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)e2);
            return Collections.emptyList();
        }
    }

    @Override
    public int countReviewsCreatedInPeriod(Date startDate, Date endDate, Project project) {
        Query q2 = this.session().createQuery("select count(review) from Review review where review.project = :project and review.createDateTime > :startDate and review.createDateTime <= :endDate and review.stateName != :deadState and review.stateName != :draftState");
        q2.setEntity("project", (Object)project);
        q2.setLong("startDate", startDate.getTime());
        q2.setLong("endDate", endDate.getTime());
        q2.setString("deadState", StateManager.INSTANCE.getDeadState().getName());
        q2.setString("draftState", StateManager.INSTANCE.getDraftState().getName());
        return ((Long)q2.uniqueResult()).intValue();
    }

    @Override
    public List<Review> getReviewChildren(Review parent, String[] states, boolean inState) {
        String stateFrag = this.makeSelectReviewsByStateFrag(states, inState);
        Query q2 = this.session().createQuery("select review from Review review where " + (stateFrag == null ? "" : stateFrag + " and ") + "review.parentReview = :parent");
        q2.setEntity("parent", (Object)parent);
        return q2.list();
    }

    @Override
    public List<Review> getReviewsByIds(Collection<Integer> ids) {
        Query q2 = this.session().createQuery("from Review review where review.id in (:ids)");
        HqlBatchedInClauseHelper helper = new HqlBatchedInClauseHelper(q2, "ids", ImmutableList.copyOf(ids));
        return helper.executeAndFetchAll();
    }

    @Override
    public void visitAllReviews(final Visitor<Review> visitor) {
        HibernateUtil.withIterator(this.session().createQuery("from Review"), new Function<Iterator<Review>, Void>(){

            public Void apply(Iterator<Review> iterator) {
                while (iterator.hasNext()) {
                    visitor.visit(iterator.next());
                }
                return null;
            }
        });
    }
}

