/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.crucible.spi.services.ProjectSearchCriteria;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.dao.HibernateDAOUtil;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateProjectDAO
implements ProjectDAO {
    private final CurrentSessionProvider currentSessionProvider;
    private static final String DEFAULT_ORDER_PROPERTY = "projKey";

    @Autowired
    public HibernateProjectDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void ensureInSession(Project project) {
        if (project != null && !this.session().contains((Object)project)) {
            throw new IllegalStateException("Project not in session: " + project);
        }
    }

    @Override
    public void add(Project project) {
        this.session().save((Object)project);
    }

    @Override
    public void delete(Project project) {
        this.session().delete((Object)project);
    }

    @Override
    public Project getById(Integer projectId) {
        return (Project)this.session().get(Project.class, (Serializable)projectId);
    }

    @Override
    public Project getByKey(String projectKey) {
        return (Project)this.session().createCriteria(Project.class).add((Criterion)Restrictions.eq((String)DEFAULT_ORDER_PROPERTY, (Object)projectKey)).uniqueResult();
    }

    @Override
    public Project ensureProjectExists(String projectKey) {
        Project project = this.getByKey(projectKey);
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (String)"Project with key: %s doesn't exist", (Object[])new Object[]{projectKey});
        return project;
    }

    @Override
    public List<Project> list() {
        Criteria criteria = this.session().createCriteria(Project.class);
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public List<Project> listWithDefaultRepositoryName(String defaultRepositoryName) {
        Criteria criteria = this.session().createCriteria(Project.class);
        criteria.add((Criterion)Restrictions.eq((String)"defaultRepositoryName", (Object)defaultRepositoryName));
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public List<Project> listWithPermissionScheme(PermissionScheme permissionScheme) {
        Criteria criteria = this.session().createCriteria(Project.class);
        criteria.add((Criterion)Restrictions.eq((String)"permissionScheme", (Object)permissionScheme));
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public int countProjects() {
        return ((Number)this.session().createQuery("select count(*) from Project").uniqueResult()).intValue();
    }

    @Override
    public List<String> listProjectKeys() {
        LinkedHashSet result = new LinkedHashSet();
        Query q2 = this.session().createQuery("select distinct p.projKey from Project p order by p.projKey");
        q2.setCacheable(true);
        result.addAll(HibernateUtil.typedList(q2));
        return new ArrayList<String>(result);
    }

    @Override
    public int countProjects(ProjectSearchCriteria projectSearchCriteria) {
        return HibernateDAOUtil.count(this.hibernateCriteria(projectSearchCriteria));
    }

    @Override
    public List<Project> list(ProjectSearchCriteria searchCriteria, int start, int limit) {
        return HibernateDAOUtil.list(this.hibernateCriteria(searchCriteria), start, limit, Order.asc((String)DEFAULT_ORDER_PROPERTY));
    }

    private Criteria hibernateCriteria(ProjectSearchCriteria projectSearchCriteria) {
        Criteria criteria = this.session().createCriteria(Project.class);
        Junction junction = HibernateDAOUtil.getJunction(projectSearchCriteria.searchCriteriaJunctionType);
        if (!Strings.isNullOrEmpty((String)projectSearchCriteria.key)) {
            junction.add((Criterion)HibernateDAOUtil.getSimpleExpressionFor(DEFAULT_ORDER_PROPERTY, projectSearchCriteria.key, projectSearchCriteria.searchCriteriaType));
        }
        if (!Strings.isNullOrEmpty((String)projectSearchCriteria.name)) {
            junction.add((Criterion)HibernateDAOUtil.getSimpleExpressionFor("name", projectSearchCriteria.name, projectSearchCriteria.searchCriteriaType));
        }
        if (!Strings.isNullOrEmpty((String)projectSearchCriteria.defaultRepositoryName)) {
            junction.add((Criterion)HibernateDAOUtil.getSimpleExpressionFor("defaultRepositoryName", projectSearchCriteria.defaultRepositoryName, projectSearchCriteria.searchCriteriaType));
        }
        if (!Strings.isNullOrEmpty((String)projectSearchCriteria.permissionSchemeName)) {
            criteria.createAlias("permissionScheme", "ps");
            junction.add((Criterion)HibernateDAOUtil.getSimpleExpressionFor("ps.name", projectSearchCriteria.permissionSchemeName, projectSearchCriteria.searchCriteriaType));
        }
        if (!Iterables.isEmpty((Iterable)junction.conditions())) {
            criteria.add((Criterion)junction);
        }
        return criteria;
    }
}

