/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.crucible.spi.services.PermissionSchemeSearchCriteria;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.dao.HibernateDAOUtil;
import com.cenqua.crucible.model.dao.PermissionSchemeDAO;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernatePermissionSchemeDAO
implements PermissionSchemeDAO {
    private final CurrentSessionProvider currentSessionProvider;
    private static final String DEFAULT_ORDER_PROPERTY = "name";

    @Autowired
    public HibernatePermissionSchemeDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void ensureInSession(PermissionScheme permissionScheme) {
        if (permissionScheme != null && !this.session().contains((Object)permissionScheme)) {
            throw new IllegalStateException("PermissionScheme not in session: " + permissionScheme);
        }
    }

    @Override
    public void add(PermissionScheme permissionScheme) {
        this.session().save((Object)permissionScheme);
    }

    @Override
    public void delete(PermissionScheme permissionScheme) {
        this.session().delete((Object)permissionScheme);
    }

    @Override
    public PermissionScheme getById(Integer id) {
        return (PermissionScheme)this.session().get(PermissionScheme.class, (Serializable)id);
    }

    @Override
    public PermissionScheme getByName(String name) {
        return (PermissionScheme)this.session().createCriteria(PermissionScheme.class).add((Criterion)Restrictions.eq((String)DEFAULT_ORDER_PROPERTY, (Object)name)).uniqueResult();
    }

    @Override
    public PermissionScheme ensurePermissionSchemeExists(String name) {
        PermissionScheme permissionScheme = this.getByName(name);
        Preconditions.checkArgument((permissionScheme != null ? 1 : 0) != 0, (String)"Permission scheme with name: %s doesn't exist", (Object[])new Object[]{name});
        return permissionScheme;
    }

    @Override
    public List<PermissionScheme> list() {
        Criteria criteria = this.session().createCriteria(PermissionScheme.class);
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public int countPermissionSchemes(PermissionSchemeSearchCriteria permissionSchemeSearchCriteria) {
        return HibernateDAOUtil.count(this.hibernateCriteria(permissionSchemeSearchCriteria));
    }

    @Override
    public List<PermissionScheme> list(PermissionSchemeSearchCriteria permissionSchemeSearchCriteria, int start, int limit) {
        return HibernateDAOUtil.list(this.hibernateCriteria(permissionSchemeSearchCriteria), start, limit, Order.asc((String)DEFAULT_ORDER_PROPERTY));
    }

    private Criteria hibernateCriteria(PermissionSchemeSearchCriteria permissionSchemeSearchCriteria) {
        Criteria criteria = this.session().createCriteria(PermissionScheme.class);
        if (permissionSchemeSearchCriteria.name != null) {
            criteria.add((Criterion)HibernateDAOUtil.getSimpleExpressionFor(DEFAULT_ORDER_PROPERTY, permissionSchemeSearchCriteria.name, permissionSchemeSearchCriteria.searchCriteriaType));
        }
        return criteria;
    }
}

