/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.PatchDAO;
import com.cenqua.crucible.revision.source.PatchRevision;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernatePatchDAO
implements PatchDAO {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public HibernatePatchDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public List<Patch> findReviewPatches(Review review) {
        Query q2 = this.session().createQuery("select patch from Patch patch where review = :review");
        q2.setEntity("review", (Object)review);
        return HibernateUtil.typedList(q2);
    }

    @Override
    public void deleteReviewPatches(Review review) {
        Query q2 = this.session().createQuery("delete from Patch where review = :review");
        q2.setEntity("review", (Object)review);
        q2.executeUpdate();
    }

    @Override
    public Patch getPatchById(Integer id) {
        return (Patch)this.session().get(Patch.class, (Serializable)id);
    }

    @Override
    public void savePatch(Patch patch) {
        this.session().save((Object)patch);
    }

    @Override
    public Iterable<Patch> getActivePatchesForSource(String sourceName) {
        ImmutableList patchIds = ImmutableList.copyOf(this.getPatchIdsForSource(sourceName));
        Query patchQuery = this.session().createQuery("select patch from Patch patch where patch.availableForAdding = true and patch.id in (:ids) order by patch.id asc");
        ImmutableList.Builder patches = ImmutableList.builder();
        new HqlBatchedInClauseHelper(patchQuery, "ids", patchIds).execute(patch -> {
            patches.add(patch);
            return true;
        }, false);
        return patches.build();
    }

    @Override
    public Iterable<Integer> getPatchIdsForSource(String sourceName) {
        Query patchRevisionsQuery = this.session().createQuery("select revision.revision from CrucibleRevision revision where revision.sourceName = :sourceName");
        patchRevisionsQuery.setParameter("sourceName", (Object)sourceName);
        List patchRevisions = patchRevisionsQuery.list();
        return ImmutableList.copyOf((Collection)ImmutableSortedSet.copyOf((Collection)Lists.transform((List)patchRevisions, input -> PatchRevision.fromCrucibleRevision((String)input).patchId)));
    }
}

