/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.crucible.spi.services.SearchCriteriaJunctionType;
import com.atlassian.crucible.spi.services.SearchCriteriaType;
import com.cenqua.crucible.hibernate.HibernateUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class HibernateDAOUtil {
    static MatchMode getMatchModeFor(SearchCriteriaType searchCriteriaType) {
        switch (searchCriteriaType) {
            case EXACT_MATCH: {
                return MatchMode.EXACT;
            }
            case PARTIAL_MATCH: {
                return MatchMode.ANYWHERE;
            }
        }
        throw new IllegalArgumentException("Unknown search criteria type: " + searchCriteriaType);
    }

    static SimpleExpression getSimpleExpressionFor(String propertyName, String value, SearchCriteriaType searchCriteriaType) {
        SimpleExpression simpleExpression = Restrictions.like((String)propertyName, (String)value, (MatchMode)HibernateDAOUtil.getMatchModeFor(searchCriteriaType));
        switch (searchCriteriaType) {
            case PARTIAL_MATCH: {
                return simpleExpression.ignoreCase();
            }
            case EXACT_MATCH: {
                return simpleExpression;
            }
        }
        throw new IllegalArgumentException("Unknown search criteria type: " + searchCriteriaType);
    }

    static Junction getJunction(SearchCriteriaJunctionType searchCriteriaJunctionType) {
        switch (searchCriteriaJunctionType) {
            case AND: {
                return Restrictions.conjunction();
            }
            case OR: {
                return Restrictions.disjunction();
            }
        }
        throw new IllegalArgumentException("Unknown search criteria junction type: " + searchCriteriaJunctionType);
    }

    static int count(Criteria criteria) {
        return ((Number)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
    }

    static <T> List<T> list(Criteria criteria, int start, int limit, Order orderBy) {
        criteria.setFirstResult(start);
        criteria.setMaxResults(limit);
        criteria.addOrder(orderBy);
        return HibernateUtil.typedList(criteria);
    }
}

