/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleActivityItem;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.CrucibleActivityItemDAO;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateCrucibleActivityItemDAO
implements CrucibleActivityItemDAO {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public HibernateCrucibleActivityItemDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void add(CrucibleActivityItem crucibleActivityItem) {
        this.session().save((Object)crucibleActivityItem);
    }

    @Override
    public void deleteWithReview(Review review) {
        Iterator it = this.session().createQuery("from CrucibleActivityItem logItem where reviewId = :reviewId").setInteger("reviewId", review.getId().intValue()).iterate();
        while (it.hasNext()) {
            this.session().delete(it.next());
        }
    }

    @Override
    public List<CrucibleActivityItem> list() {
        Criteria criteria = this.session().createCriteria(CrucibleActivityItem.class);
        return HibernateUtil.typedList(criteria);
    }
}

