/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.dao.ContentRootDAO;
import com.cenqua.fisheye.model.ContentRoot;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateContentRootDAO
implements ContentRootDAO {
    private final CurrentSessionProvider currentSessionProvider;
    private static final String DEFAULT_ORDER_PROPERTY = "id";

    @Autowired
    public HibernateContentRootDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void add(ContentRoot contentRoot) {
        this.session().save((Object)contentRoot);
    }

    @Override
    public void delete(ContentRoot contentRoot) {
        this.session().delete((Object)contentRoot);
    }

    @Override
    public void deleteByProjectIdRepositoryPath(Integer projectId, String repositoryName, String path) {
        Query query = this.session().createQuery("delete from ContentRoot cr where cr.project.id = :projectId and cr.repName = :repName and cr.path =  :path");
        query.setInteger("projectId", projectId.intValue());
        query.setString("repName", repositoryName);
        query.setString("path", path);
        query.executeUpdate();
    }

    @Override
    public ContentRoot getById(Integer id) {
        return (ContentRoot)this.session().get(ContentRoot.class, (Serializable)id);
    }

    @Override
    public ContentRoot getByProjectRepositoryPath(Project project, String repositoryName, String path) {
        Criteria criteria = this.session().createCriteria(ContentRoot.class);
        criteria.add((Criterion)Restrictions.eq((String)"project", (Object)project));
        criteria.add((Criterion)Restrictions.eq((String)"repName", (Object)repositoryName));
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        return (ContentRoot)criteria.uniqueResult();
    }

    @Override
    public List<ContentRoot> list() {
        Criteria criteria = this.session().createCriteria(ContentRoot.class);
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public List<ContentRoot> listWithRepositoryName(String repositoryName) {
        Criteria criteria = this.session().createCriteria(ContentRoot.class);
        criteria.add((Criterion)Restrictions.eq((String)"repName", (Object)repositoryName));
        criteria.addOrder(Order.asc((String)DEFAULT_ORDER_PROPERTY));
        return HibernateUtil.typedList(criteria);
    }
}

