/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SuggestedReviewer {
    private final FecruUser crucibleUser;
    private int openReviews;
    private int loc;
    private int numberOfCommits;
    private List<SuggestedReviewerFile> paths = new ArrayList<SuggestedReviewerFile>();
    private boolean sorted = true;

    public SuggestedReviewer(FecruUser crucibleUser) {
        this.crucibleUser = crucibleUser;
    }

    public void addPath(Path path, int loc, int fileLoc, int commits) {
        this.paths.add(new SuggestedReviewerFile(path, loc, fileLoc, commits));
        this.loc += loc;
        this.sorted = false;
    }

    public int getOpenReviews() {
        return this.openReviews;
    }

    public void setOpenReviews(int openReviews) {
        this.openReviews = openReviews;
    }

    public int getNumberOfCommits() {
        return this.numberOfCommits;
    }

    public void setNumberOfCommits(int numberOfCommits) {
        this.numberOfCommits = numberOfCommits;
    }

    public FecruUser getCrucibleUser() {
        return this.crucibleUser;
    }

    public int getLoc() {
        return this.loc;
    }

    public SuggestedReviewerFile getMostContributed() {
        if (!this.sorted) {
            Collections.sort(this.paths, new LOCComparator());
            this.sorted = true;
        }
        if (this.paths.isEmpty()) {
            return new SuggestedReviewerFile(null, 0, 0, 0);
        }
        return this.paths.get(0);
    }

    public static class SuggestedReviewerFile {
        private Path path;
        private int fileLoc = 1;
        private int loc;
        private int commits;

        public SuggestedReviewerFile(Path path, int loc, int fileLoc, int commits) {
            this.path = path;
            this.loc = loc;
            this.fileLoc = fileLoc == 0 ? 1 : fileLoc;
            this.commits = commits;
        }

        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public int getLoc() {
            return this.loc;
        }

        public void setLoc(int loc) {
            this.loc = loc;
        }

        public int getFileLoc() {
            return this.fileLoc;
        }

        public void setFileLoc(int fileLoc) {
            this.fileLoc = fileLoc;
        }

        public int getCommits() {
            return this.commits;
        }

        public void setCommits(int commits) {
            this.commits = commits;
        }
    }

    static class LOCComparator
    implements Comparator<SuggestedReviewerFile> {
        LOCComparator() {
        }

        @Override
        public int compare(SuggestedReviewerFile f1, SuggestedReviewerFile f2) {
            return f2.getLoc() - f1.getLoc();
        }
    }
}

