/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.fisheye.util.HashUtils;
import com.google.common.base.Function;
import com.google.common.base.Strings;

public class StoredPath {
    private Integer id;
    protected String path;
    protected String hash;
    public static final Function<String, String> PATH_HASHING_FUNCTION = new Function<String, String>(){

        public String apply(String path) {
            return HashUtils.getDefaultDigestHexEncoded(path);
        }
    };

    public StoredPath() {
    }

    public StoredPath(String path, String hash) {
        this.path = path;
        this.hash = hash;
    }

    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }

    public String getPath() {
        return Strings.nullToEmpty((String)this.path);
    }

    private void setPath(String path) {
        this.path = path;
    }

    public String getHash() {
        return this.hash;
    }

    private void setHash(String hash) {
        this.hash = hash;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (!(o2 instanceof StoredPath)) {
            return false;
        }
        Integer oid = ((StoredPath)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id;
    }
}

