/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.ModelUtils;
import com.google.common.base.Function;
import java.util.Date;

public class StateChangeLog {
    private Integer id;
    private Integer reviewId;
    private Long timeStamp;
    private String newState;
    private Long superseded;
    private FecruUser user;
    public static final Function<StateChangeLog, Integer> TO_ID = new Function<StateChangeLog, Integer>(){

        public Integer apply(StateChangeLog stateChangeLog) {
            return stateChangeLog.getId();
        }
    };
    public static final Function<StateChangeLog, Integer> TO_REVIEW_ID = new Function<StateChangeLog, Integer>(){

        public Integer apply(StateChangeLog stateChangeLog) {
            return stateChangeLog.getReviewId();
        }
    };

    StateChangeLog() {
    }

    public StateChangeLog(String newState, Integer reviewId, FecruUser user) {
        this.setReviewId(reviewId);
        this.setNewState(newState);
        this.setTimeStamp(new Date());
        this.setUser(user);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getReviewId() {
        return this.reviewId;
    }

    public void setReviewId(Integer reviewId) {
        this.reviewId = reviewId;
    }

    public Date getTimeStamp() {
        return new Date(this.timeStamp);
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp.getTime();
    }

    public Long getDateTimeStamp() {
        return this.timeStamp;
    }

    public void setDateTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getNewState() {
        return this.newState;
    }

    public void setNewState(String newState) {
        ModelUtils.ensureNotNullOrEmpty("The new state", newState);
        this.newState = newState;
    }

    public Date getSuperseded() {
        return this.superseded == null ? null : new Date(this.superseded);
    }

    public void setSuperseded(Date superseded) {
        this.superseded = superseded.getTime();
    }

    public Long getSupersededTime() {
        return this.superseded;
    }

    public void setSupersededTime(Long superseded) {
        this.superseded = superseded;
    }

    public FecruUser getUser() {
        return this.user;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }
}

