/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Review;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class ReviewPermaId {
    private Review review;
    private PermaIdKey permaIdKey;
    public static final Function<ReviewPermaId, PermaIdKey> GET_PERMA_ID_KEY = new Function<ReviewPermaId, PermaIdKey>(){

        public PermaIdKey apply(ReviewPermaId reviewPermaId) {
            Preconditions.checkNotNull((Object)reviewPermaId);
            return reviewPermaId.permaIdKey;
        }
    };

    ReviewPermaId() {
    }

    public ReviewPermaId(Review review, String prefix, int number) {
        this.setReview(review);
        this.setPermaIdKey(new PermaIdKey(prefix, number));
    }

    public ReviewPermaId(Review review, PermaIdKey key) {
        this.setReview(review);
        this.setPermaIdKey(key);
    }

    public PermaIdKey getPermaIdKey() {
        return this.permaIdKey;
    }

    public void setPermaIdKey(PermaIdKey permaIdKey) {
        if (permaIdKey == null) {
            throw new IllegalArgumentException("Perma ID keys may not be null");
        }
        this.permaIdKey = permaIdKey;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
    }

    public String toString() {
        return this.permaIdKey.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ReviewPermaId that = (ReviewPermaId)o2;
        return Objects.equal((Object)this.permaIdKey, (Object)that.permaIdKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.permaIdKey});
    }
}

