/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileReadStatus;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.discussion.CommentOperator;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.fisheye.config.SpringContext;
import com.google.common.base.Function;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReviewParticipant {
    private Integer id;
    private Review review;
    private FecruUser user = null;
    private boolean author = false;
    private boolean moderator = false;
    private boolean reviewer = false;
    private boolean allComplete = false;
    private Long lastRead = null;
    private Long completionStatusChangeDate = null;
    private Long timeSpent;
    private Long timeSubmitted;
    private Integer percentComplete;
    private Set<FileReadStatus> fileReadStatus = new HashSet<FileReadStatus>();
    private UnreadFileManager unreadFileManager;
    private Integer reviewId;
    public static final Function<ReviewParticipant, Integer> TO_ID = new Function<ReviewParticipant, Integer>(){

        public Integer apply(ReviewParticipant reviewParticipant) {
            return reviewParticipant.getId();
        }
    };

    public static ParticipantsRoles addToExistingRoles(ParticipantsRoles existing, FecruUser user, boolean reviewer, boolean author, boolean moderator) {
        if (existing != null) {
            author |= existing.author;
            moderator |= existing.moderator;
            reviewer |= existing.reviewer;
        }
        return new ParticipantsRoles(user, reviewer &= !author && !moderator, author, moderator);
    }

    private UnreadFileManager getUnreadFileManager() {
        if (this.unreadFileManager == null) {
            this.unreadFileManager = SpringContext.getComponentByClass(UnreadFileManager.class);
        }
        return this.unreadFileManager;
    }

    public Set<FileReadStatus> getFileReadStatus() {
        return this.fileReadStatus;
    }

    public void setFileReadStatus(Set<FileReadStatus> fileReadStatus) {
        this.fileReadStatus = fileReadStatus;
    }

    public FileReadStatus getReadStatus(FileRevisionExtraInfo frx) {
        for (FileReadStatus readStatus : this.getFileReadStatus()) {
            if (!readStatus.getFrx().equals(frx)) continue;
            return readStatus;
        }
        return null;
    }

    public boolean isRead(FileRevisionExtraInfo frx) {
        FileReadStatus status = this.getReadStatus(frx);
        return status != null && status.getRead() != null && status.getRead() != false;
    }

    public FileReadStatus.Status getReadStatusValue(FileRevisionExtraInfo frx) {
        FileReadStatus readStatus = this.getReadStatus(frx);
        if (readStatus == null || readStatus.getRead() == null) {
            return FileReadStatus.Status.UNREAD;
        }
        if (readStatus.getRead().booleanValue()) {
            return FileReadStatus.Status.READ;
        }
        return FileReadStatus.Status.LEAVE_UNREAD;
    }

    public boolean isUnread(FileRevisionExtraInfo frx) {
        return frx != null && this.getReadStatus(frx) == null;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public FecruUser getUser() {
        return this.user;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
        if (review != null) {
            this.reviewId = review.getId();
        }
    }

    public Integer getReviewId() {
        return this.reviewId;
    }

    protected void setReviewId(Integer reviewId) {
        this.reviewId = reviewId;
    }

    public boolean isAuthor() {
        return this.author;
    }

    public void setAuthor(boolean author) {
        this.author = author;
        if (author) {
            this.reviewer = false;
        }
    }

    public boolean isModerator() {
        return this.moderator;
    }

    public void setModerator(boolean moderator) {
        this.moderator = moderator;
        if (moderator) {
            this.reviewer = false;
        }
    }

    public boolean isReviewer() {
        return this.reviewer;
    }

    public void setReviewer(boolean reviewer) {
        this.reviewer = reviewer;
        if (reviewer) {
            this.moderator = false;
            this.author = false;
        }
    }

    public boolean isAllComplete() {
        return this.allComplete;
    }

    private void setAllComplete(boolean allComplete) {
        this.allComplete = allComplete;
    }

    public Date getLastRead() {
        return this.lastRead == null ? null : new Date(this.lastRead);
    }

    public void setLastRead(Date lastRead) {
        this.lastRead = lastRead.getTime();
    }

    public Long getLastReadTime() {
        return this.lastRead;
    }

    public void setLastReadTime(Long lastRead) {
        this.lastRead = lastRead;
    }

    public Set<FileRevisionExtraInfo> getCompletedFrxs() {
        HashSet<FileRevisionExtraInfo> completedFrxs = new HashSet<FileRevisionExtraInfo>();
        for (FileReadStatus status : this.fileReadStatus) {
            if (status.getRead() == null || !status.getRead().booleanValue()) continue;
            completedFrxs.add(status.getFrx());
        }
        return completedFrxs;
    }

    public Integer getPercentageComplete() {
        if (this.percentComplete != null && this.percentComplete >= 0 && this.percentComplete <= 100) {
            return this.percentComplete;
        }
        if (this.allComplete) {
            this.percentComplete = 100;
            return this.percentComplete;
        }
        Set<FileRevisionExtraInfo> completedFrxs = this.getCompletedFrxs();
        if (completedFrxs.isEmpty()) {
            return 0;
        }
        Set<FileRevisionExtraInfo> allFrxs = this.getReview().getFrxs();
        if (allFrxs.isEmpty()) {
            this.percentComplete = 0;
            return this.percentComplete;
        }
        long reviewedLOC = 0L;
        long totalLOC = 0L;
        for (FileRevisionExtraInfo frx : allFrxs) {
            boolean isComplete = completedFrxs.contains(frx);
            List<FRXRevision> revisions = frx.getFrxRevisions();
            for (FRXRevision revision : revisions) {
                int linesChanged = revision.getLinesChanged();
                long timeAdded = Long.MIN_VALUE;
                if (revision.getDateTimeAdded() != null) {
                    timeAdded = revision.getDateTimeAdded();
                }
                if (isComplete || this.completionStatusChangeDate != null && this.completionStatusChangeDate < timeAdded) {
                    reviewedLOC += (long)linesChanged;
                }
                totalLOC += (long)linesChanged;
            }
        }
        int percentDone = 0;
        if (totalLOC > 0L) {
            percentDone = (int)((float)reviewedLOC / (float)totalLOC * 100.0f);
        }
        this.percentComplete = percentDone;
        return this.percentComplete;
    }

    public String toString() {
        return this.getId() + ": " + (this.getUser() == null ? "null" : this.getUser().getUsername()) + (this.reviewer ? " reviewer" : "") + (this.author ? " author" : "") + (this.moderator ? " moderator" : "");
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof ReviewParticipant)) {
            return false;
        }
        Integer oid = ((ReviewParticipant)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id.hashCode();
    }

    public Date getCompletionStatusChangeDate() {
        return this.completionStatusChangeDate == null ? null : new Date(this.completionStatusChangeDate);
    }

    public void setCompletionStatusChangeDate(Date completionStatusChangeDate) {
        this.completionStatusChangeDate = completionStatusChangeDate == null ? null : Long.valueOf(completionStatusChangeDate.getTime());
    }

    public Long getCompletionStatusChangeDateTime() {
        return this.completionStatusChangeDate;
    }

    public void setCompletionStatusChangeDateTime(Long completionStatusChangeDate) {
        this.completionStatusChangeDate = completionStatusChangeDate;
    }

    public void setCompletionStatus(boolean status) {
        if (this.allComplete != status) {
            this.setAllComplete(status);
            this.setCompletionStatusChangeDate(new Date());
        }
        if (status) {
            this.getReview().cleanupAllComments(this.user);
            for (FileRevisionExtraInfo frx : this.getReview().getFrxs()) {
                if (this.isRead(frx)) continue;
                this.getUnreadFileManager().markAsRead(this, frx);
            }
            DefaultCommentManager.getInstance().comments(this.review).where(DiscussionClauses.and(DiscussionClauses.not(DiscussionClauses.author(this.getUser())), DiscussionClauses.visibleToAll(), new DiscussionClause[0])).visit(new CommentOperator(){
                private final UnreadManager unreadManager = new UnreadManager();

                @Override
                public void operate(Comment comment) {
                    this.unreadManager.markAsRead(ReviewParticipant.this.getUser(), comment);
                }
            });
            new UnreadManager().markReviewCommentsAsRead(this.user, this.getReview());
        }
    }

    public Long getTimeSpent() {
        return this.timeSpent;
    }

    public void setTimeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public Long getTimeSubmitted() {
        return this.timeSubmitted;
    }

    public Double getTimeSubmittedInMinutes() {
        return Math.floor(this.zeroIfNull(this.getTimeSubmitted()) / 60000L);
    }

    private Long zeroIfNull(Long timeSubmitted) {
        return timeSubmitted == null ? Long.valueOf(0L) : timeSubmitted;
    }

    public void setTimeSubmitted(Long timeSubmitted) {
        this.timeSubmitted = timeSubmitted;
    }

    public static class ParticipantsRoles {
        public final FecruUser user;
        public final boolean reviewer;
        public final boolean author;
        public final boolean moderator;

        public ParticipantsRoles(FecruUser user, boolean reviewer, boolean author, boolean moderator) {
            this.user = user;
            this.reviewer = reviewer;
            this.author = author;
            this.moderator = moderator;
        }
    }
}

