/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.atlassian.crucible.event.AllReviewersCompletedEventImpl;
import com.atlassian.crucible.event.AllReviewersNoLongerCompletedEventImpl;
import com.atlassian.crucible.event.ReviewerCompletedEventImpl;
import com.atlassian.crucible.event.ReviewerUncompletedEventImpl;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.services.ReviewContentTooLargeException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.JiraIssueUtil;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CommentList;
import com.cenqua.crucible.model.CommonListMixin;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.CustomFieldList;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.InlineCommentManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ParticipantManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateChangeLogManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.ObjectReference;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class Review
extends CommonListMixin
implements CommentList,
CustomFieldList {
    public static final String UNTITLED_REVIEW_NAME = "Untitled";
    private static final int DISPLAY_TRUNCATE_LENGTH = 50;
    private ReviewType type = ReviewType.REVIEW;
    private Integer id;
    private String reviewName = "no name";
    private String state = "Unknown";
    private State stateOb = null;
    private String description;
    private String summary;
    private Long createDate;
    private Long dueDate;
    private Long reminderDate;
    private Integer metricsVersion;
    private FecruUser creator = null;
    private Set<ReviewParticipant> participants = new HashSet<ReviewParticipant>();
    private Set<String> invitees = new HashSet<String>();
    private Review parentReview;
    private Set<FileRevisionExtraInfo> frxs = new LinkedHashSet<FileRevisionExtraInfo>();
    private boolean allowReviewerToJoin = false;
    private Project project;
    private String jiraIssueKey;
    private Set<ReviewPermaId> permaIds = new HashSet<ReviewPermaId>();
    private ProjectManager projectManager;
    private UnreadFileManager unreadFileManager;
    private FecruUser cachedAuthor = null;
    private ObjectReference<FecruUser> cachedModerator = null;
    private String defaultSource;
    private EventPublisher eventPublisher;
    private StateChangeLogManager stateChangeLogManager;
    private static final Function<ReviewParticipant, FecruUser> participantToUserTransform = new Function<ReviewParticipant, FecruUser>(){

        public FecruUser apply(ReviewParticipant participant) {
            return participant.getUser();
        }
    };
    private static Predicate<ReviewParticipant> activeReviewerPredicate = new Predicate<ReviewParticipant>(){

        public boolean apply(ReviewParticipant participant) {
            return participant.isReviewer() && !participant.isAllComplete();
        }
    };
    private static Predicate<ReviewParticipant> reviewerPredicate = new Predicate<ReviewParticipant>(){

        public boolean apply(ReviewParticipant participant) {
            return participant.isReviewer();
        }
    };
    private static Predicate<ReviewParticipant> completedReviewerPredicate = new Predicate<ReviewParticipant>(){

        public boolean apply(ReviewParticipant participant) {
            return participant.isReviewer() && participant.isAllComplete();
        }
    };
    private static Predicate<ReviewParticipant> authorModeratorPredicate = new Predicate<ReviewParticipant>(){

        public boolean apply(ReviewParticipant participant) {
            return participant.isAuthor() || participant.isModerator();
        }
    };
    public static final Function<Review, Integer> TO_ID = new Function<Review, Integer>(){

        public Integer apply(Review review) {
            return review.getId();
        }
    };

    public Review() {
        this.setCreateDate(new Date());
    }

    public Review(ProjectManager projectManager, Project project, ReviewType type, String name) {
        this(projectManager, project, type, name, StateManager.INSTANCE.getFirstState());
    }

    public Review(ProjectManager projectManager, Project project, ReviewType type, String name, State firstState) {
        this.type = type;
        this.projectManager = projectManager;
        this.project = project;
        this.setName(name);
        this.setState(firstState);
        this.setCreateDate(new Date());
    }

    private EventPublisher getEventPublisher() {
        if (this.eventPublisher == null) {
            this.eventPublisher = SpringContext.getComponent(EventPublisher.class, "eventPublisher");
        }
        return this.eventPublisher;
    }

    private StateChangeLogManager getStateChangeLogManager() {
        if (this.stateChangeLogManager == null) {
            this.stateChangeLogManager = SpringContext.getComponentByClass(StateChangeLogManager.class);
        }
        return this.stateChangeLogManager;
    }

    public Set<ReviewPermaId> getPermaIdHistory() {
        return this.permaIds;
    }

    public Set<String> getPermaIdHistoryAsStrings() {
        HashSet<String> history = new HashSet<String>();
        for (ReviewPermaId id : this.permaIds) {
            history.add(id.toString());
        }
        return history;
    }

    public void setPermaIdHistory(Set<ReviewPermaId> permaId) {
        this.permaIds = permaId;
    }

    public void addPermaId(ProjectManager projectManager, Project project) {
        this.getPermaIdHistory().add(projectManager.getNextPermaId(project, this));
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public ReviewType getType() {
        return this.type;
    }

    public void setType(ReviewType type) {
        this.type = type;
    }

    public boolean isSnippet() {
        return this.type == ReviewType.SNIPPET;
    }

    void setReviewType(int type) {
        this.type = ReviewType.byId(type);
    }

    int getReviewType() {
        return this.type.getId();
    }

    public List<Review> getLinkedReviews() {
        ArrayList<Review> linked = new ArrayList<Review>();
        if (this.parentReview != null) {
            linked.add(this.parentReview);
        }
        linked.addAll(this.getChildReviews());
        return linked;
    }

    public Review getParentReview() {
        return this.parentReview;
    }

    public void setParentReview(Review parentReview) {
        this.parentReview = parentReview;
    }

    public List<Review> getChildReviews() {
        return DefaultReviewManager.get().getReviewChildren(this);
    }

    public String getPermaId() {
        String fallback = null;
        for (ReviewPermaId permaId : this.permaIds) {
            if (permaId.getPermaIdKey().getProjKey().equals(this.getProject().getProjKey())) {
                return permaId.toString();
            }
            if (fallback != null) continue;
            fallback = permaId.toString();
        }
        if (fallback != null) {
            return fallback;
        }
        Logs.APP_LOG.warn((Object)("Review with id " + this.getId() + " has no permaId"));
        return "CR-" + this.getId();
    }

    public PermId<ReviewData> getPermId() {
        return new PermId(this.getPermaId());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean isAllowReviewerToJoin() {
        return this.allowReviewerToJoin;
    }

    public void setAllowReviewerToJoin(boolean allowReviewerToJoin) {
        this.allowReviewerToJoin = allowReviewerToJoin;
    }

    public Date getCreateDate() {
        return new Date(this.createDate);
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate.getTime();
    }

    public Long getCreateDateTime() {
        return this.createDate;
    }

    public void setCreateDateTime(Long createDate) {
        this.createDate = createDate;
    }

    public Date getDueDate() {
        return this.dueDate == null ? null : new Date(this.dueDate);
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate == null ? null : Long.valueOf(dueDate.getTime());
    }

    public Long getDueDateTime() {
        return this.dueDate;
    }

    public void setDueDateTime(Long dueDate) {
        this.dueDate = dueDate;
    }

    public Date getReminderDate() {
        return this.reminderDate == null ? null : new Date(this.reminderDate);
    }

    public void setReminderDate(Date reminderDate) {
        this.reminderDate = reminderDate == null ? null : Long.valueOf(reminderDate.getTime());
    }

    Long getReminderDateTime() {
        return this.reminderDate;
    }

    void setReminderDateTime(Long reminderDate) {
        this.reminderDate = reminderDate;
    }

    public String getJiraIssueKey() {
        return this.jiraIssueKey;
    }

    public void setJiraIssueKey(String jiraIssueKey) {
        this.jiraIssueKey = jiraIssueKey;
    }

    public boolean isOverDue() {
        if (this.getDueDate() == null || this.getState().isClosedMetaState()) {
            return false;
        }
        return System.currentTimeMillis() > this.getDueDate().getTime();
    }

    public Date getClosedDate() {
        List<StateChangeLog> changes = this.getStateChanges();
        for (StateChangeLog changeLog : changes) {
            if (!changeLog.getNewState().equals("Closed")) continue;
            return changeLog.getTimeStamp();
        }
        return null;
    }

    public String getName() {
        return this.reviewName;
    }

    public String getNameTruncated() {
        return this.getNameTruncatedWithLength(50);
    }

    public String getNameTruncatedWithLength(int length) {
        if (this.reviewName == null) {
            return "";
        }
        return StringUtil.truncate(this.reviewName, length, true);
    }

    public void setName(String name) {
        this.reviewName = name;
    }

    public String getPermaIdAndName() {
        StringBuilder sb = new StringBuilder(this.getPermaId());
        sb.append(": ");
        if (this.getName() == null || this.getName().trim().length() == 0) {
            sb.append(UNTITLED_REVIEW_NAME);
        } else {
            sb.append(this.getName());
        }
        return sb.toString();
    }

    public String getPermaIdAndNameTruncated() {
        return StringUtil.truncate(this.getPermaIdAndName(), 50, true);
    }

    public String getStateName() {
        return this.getState().getName();
    }

    public Date getStateSetDate() {
        Date setDate = null;
        List<StateChangeLog> changes = this.getStateChanges();
        for (StateChangeLog changeLog : changes) {
            if (!changeLog.getNewState().equals(this.getStateName())) continue;
            setDate = changeLog.getTimeStamp();
        }
        return setDate;
    }

    public State getState() {
        if (this.stateOb == null) {
            this.stateOb = StateManager.INSTANCE.getStateByName(this.state);
        }
        return this.stateOb;
    }

    public void setStateName(String state) {
        this.state = state;
        this.stateOb = null;
    }

    public void setState(State state) {
        this.state = state.getName();
        this.stateOb = state;
    }

    public boolean isAllReviewersComplete() {
        return !Iterables.any(this.participants, activeReviewerPredicate);
    }

    @Override
    public Integer getMetricsVersion() {
        return this.metricsVersion;
    }

    public void setMetricsVersion(Integer metricsVersion) {
        this.metricsVersion = metricsVersion;
    }

    @Override
    public Map<String, FieldDefinition> getFieldDefinitions() {
        if (this.getMetricsVersion() != null) {
            return MetricsManager.INSTANCE.getConfig(this.getMetricsVersion()).getReviewFields();
        }
        return new HashMap<String, FieldDefinition>();
    }

    public FileRevisionExtraInfo getFRX(CrucibleRevision fr) {
        for (FileRevisionExtraInfo frx : this.getFrxs()) {
            for (FRXRevision frxRevision : frx.getFrxRevisions()) {
                if (!frxRevision.getRevision().equals(fr)) continue;
                return frx;
            }
        }
        return null;
    }

    public List<StateChangeLog> getStateChanges() {
        return this.getStateChangeLogManager().getStateChanges(this.getId(), false);
    }

    public boolean isCreator(FecruUser user) {
        return this.getCreator() != null && user != null && this.getCreator().equals(user);
    }

    public ReviewParticipant getParticipant(FecruUser user) {
        for (ReviewParticipant participant : this.getParticipants()) {
            if (participant.getUser() == null || !participant.getUser().equals(user)) continue;
            return participant;
        }
        return null;
    }

    public boolean isAuthor(FecruUser user) {
        ReviewParticipant p2 = this.getParticipant(user);
        return p2 != null && p2.isAuthor();
    }

    public boolean isModerator(FecruUser user) {
        ReviewParticipant p2 = this.getParticipant(user);
        return p2 != null && p2.isModerator();
    }

    public boolean isReviewer(FecruUser user) {
        ReviewParticipant p2 = this.getParticipant(user);
        return p2 != null && p2.isReviewer();
    }

    public FecruUser getCreator() {
        return this.creator;
    }

    public void setCreator(FecruUser creator) {
        this.creator = creator;
    }

    public Set<ReviewParticipant> getParticipants() {
        return this.participants;
    }

    private void setParticipants(Set<ReviewParticipant> participants) {
        this.participants = participants;
    }

    public Set<String> getInvitees() {
        return this.invitees;
    }

    private void setInvitees(Set<String> invitedParticipants) {
        this.invitees = invitedParticipants;
    }

    public Project getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getDefaultProject();
        }
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setParticipants(Map<FecruUser, ReviewParticipant.ParticipantsRoles> newParticipants) {
        ArrayList<ReviewParticipant> participantsToRemove = new ArrayList<ReviewParticipant>();
        for (ReviewParticipant p2 : this.getParticipants()) {
            if (newParticipants.containsKey(p2.getUser())) continue;
            participantsToRemove.add(p2);
        }
        for (ReviewParticipant p2 : participantsToRemove) {
            this.removeParticipant(p2.getUser());
        }
        for (FecruUser user : newParticipants.keySet()) {
            ReviewParticipant.ParticipantsRoles tuple = newParticipants.get(user);
            ReviewParticipant p3 = ParticipantManager.getOrCreateParticipant(this, user);
            p3.setAuthor(tuple.author);
            p3.setModerator(tuple.moderator);
            p3.setReviewer(tuple.reviewer);
            if (tuple.author) {
                this.cachedAuthor = user;
            }
            if (!tuple.moderator) continue;
            if (this.cachedModerator == null) {
                this.cachedModerator = new ObjectReference();
            }
            this.cachedModerator.set(user);
        }
    }

    public void setAuthor(FecruUser user) {
        ReviewParticipant oldAuth = this.getAuthorP();
        if (oldAuth != null) {
            if (!oldAuth.isModerator()) {
                this.removeParticipant(oldAuth);
            } else {
                oldAuth.setAuthor(false);
            }
        }
        ReviewParticipant p2 = ParticipantManager.getOrCreateParticipant(this, user);
        p2.setAuthor(true);
        this.participants.add(p2);
        this.cachedAuthor = user;
    }

    public ReviewParticipant getAuthorP() {
        for (ReviewParticipant p2 : this.participants) {
            if (!p2.isAuthor()) continue;
            return p2;
        }
        return null;
    }

    public FecruUser getAuthor() {
        ReviewParticipant p2;
        if (this.cachedAuthor == null && (p2 = this.getAuthorP()) != null) {
            this.cachedAuthor = p2.getUser();
        }
        return this.cachedAuthor;
    }

    public void setModerator(FecruUser user) {
        ReviewParticipant oldMod = this.getModeratorP();
        if (oldMod != null && user.equals(oldMod.getUser())) {
            return;
        }
        if (oldMod != null) {
            if (!oldMod.isAuthor()) {
                this.removeParticipant(oldMod);
            } else {
                oldMod.setModerator(false);
            }
        }
        ReviewParticipant p2 = ParticipantManager.getOrCreateParticipant(this, user);
        p2.setModerator(true);
        this.participants.add(p2);
        if (this.cachedModerator == null) {
            this.cachedModerator = new ObjectReference();
        }
        this.cachedModerator.set(user);
    }

    public ReviewParticipant getModeratorP() {
        for (ReviewParticipant p2 : this.participants) {
            if (!p2.isModerator()) continue;
            return p2;
        }
        return null;
    }

    public boolean isModerated() {
        return this.getModerator() != null;
    }

    public FecruUser getModerator() {
        if (this.cachedModerator == null) {
            ReviewParticipant p2 = this.getModeratorP();
            this.cachedModerator = new ObjectReference<FecruUser>(p2 != null ? p2.getUser() : null);
        }
        return this.cachedModerator.get();
    }

    public String getModeratorEquivRole() {
        return this.isModerated() ? "Moderator" : "Author";
    }

    public FecruUser getModeratorEquivUser() {
        return this.isModerated() ? this.getModerator() : this.getAuthor();
    }

    public void inviteReviewer(String address) {
        this.invitees.add(address);
    }

    public void removeInvitee(String address) {
        if (address != null) {
            this.invitees.remove(address);
        }
    }

    public void removeInviteReviewer(String address) {
        this.removeInvitee(address);
    }

    public ReviewParticipant addReviewer(FecruUser user) {
        ReviewParticipant p2 = ParticipantManager.getOrCreateParticipant(this, user);
        if (!p2.isAuthor() && !p2.isModerator()) {
            p2.setReviewer(true);
            this.participants.add(p2);
        }
        return p2;
    }

    public void removeParticipant(ReviewParticipant p2) {
        if (p2 != null) {
            this.participants.remove(p2);
            ParticipantManager.deleteParticipant(p2);
        }
    }

    public void removeParticipant(FecruUser user) {
        ReviewParticipant p2 = this.getParticipant(user);
        this.removeParticipant(p2);
    }

    public void removeReviewer(FecruUser user) {
        this.removeParticipant(user);
    }

    public Set<FecruUser> getActiveReviewers() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(this.participants, activeReviewerPredicate), participantToUserTransform));
    }

    public Set<ReviewParticipant> getTeam() {
        return ImmutableSet.copyOf(this.participants);
    }

    public Set<ReviewParticipant> getOps() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.participants, authorModeratorPredicate));
    }

    public Set<ReviewParticipant> getReviewerParticipants() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.participants, reviewerPredicate));
    }

    public Set<FecruUser> getReviewers() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(this.participants, reviewerPredicate), participantToUserTransform));
    }

    public int getCountAllParticipants() {
        return this.participants.size();
    }

    public int getCountAllReviewers() {
        return Iterables.size((Iterable)Iterables.filter(this.participants, reviewerPredicate));
    }

    public int getCountActiveReviewers() {
        return Iterables.size((Iterable)Iterables.filter(this.participants, activeReviewerPredicate));
    }

    public Set<FecruUser> getCompletedReviewers() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(this.participants, completedReviewerPredicate), participantToUserTransform));
    }

    public int getCountCompletedReviewers() {
        return Iterables.size((Iterable)Iterables.filter(this.participants, completedReviewerPredicate));
    }

    public boolean setReviewerComplete(FecruUser user) {
        ReviewParticipant p2 = this.getParticipant(user);
        return p2 != null && this.setReviewerComplete(p2);
    }

    public boolean setReviewerComplete(ReviewParticipant p2) {
        if (!p2.isAllComplete()) {
            p2.setCompletionStatus(true);
            if (!this.isSnippet()) {
                if (this.getCountActiveReviewers() == 0) {
                    this.getEventPublisher().publish((Object)new AllReviewersCompletedEventImpl(this.getPermaId(), this.getSPIUserUtils().createUserData(p2.getUser())));
                } else {
                    this.getEventPublisher().publish((Object)new ReviewerCompletedEventImpl(this.getPermId(), this.getSPIUserUtils().createReviewerData(p2)));
                }
                LogManager.logReviewCompleted(this, p2.getUser());
            }
            return true;
        }
        return false;
    }

    private SPIUserUtils getSPIUserUtils() {
        return SpringContext.getComponentByClass(SPIUserUtils.class);
    }

    public void setReviewerIncomplete(FecruUser user) {
        ReviewParticipant p2 = this.getParticipant(user);
        this.setReviewerIncomplete(p2);
    }

    public void setReviewerIncomplete(ReviewParticipant p2) {
        if (p2 != null && p2.isAllComplete()) {
            p2.setCompletionStatus(false);
            if (!this.isSnippet()) {
                if (this.getCountActiveReviewers() == 1) {
                    this.getEventPublisher().publish((Object)new AllReviewersNoLongerCompletedEventImpl(this.getPermId(), this.getSPIUserUtils().createUserData(p2.getUser())));
                } else {
                    this.getEventPublisher().publish((Object)new ReviewerUncompletedEventImpl(this.getPermId(), this.getSPIUserUtils().createReviewerData(p2)));
                }
                LogManager.logReviewUncompleted(this, p2.getUser());
            }
        }
    }

    public List<Role> getUsersRoles(FecruUser user) {
        ReviewParticipant p2;
        LinkedList<Role> result = new LinkedList<Role>();
        if (this.creator != null && this.creator.equals(user)) {
            result.add(ReviewManager.CREATOR);
        }
        if ((p2 = this.getParticipant(user)) != null) {
            if (p2.isModerator()) {
                result.add(ReviewManager.MODERATOR);
            }
            if (p2.isAuthor()) {
                result.add(ReviewManager.AUTHOR);
            }
            if (p2.isReviewer()) {
                result.add(ReviewManager.REVIEWER);
            }
        }
        return result;
    }

    public Set<FecruUser> getUsersFromRoles(List roles) {
        HashSet<FecruUser> users = new HashSet<FecruUser>();
        if (roles.contains(ReviewManager.AUTHOR)) {
            users.add(this.getAuthor());
        }
        if (this.isModerated() && roles.contains(ReviewManager.MODERATOR)) {
            users.add(this.getModerator());
        }
        if (roles.contains(ReviewManager.CREATOR)) {
            users.add(this.getCreator());
        }
        if (roles.contains(ReviewManager.REVIEWER)) {
            users.addAll(this.getReviewers());
        }
        return users;
    }

    public boolean checkWriteAccess(FecruUser user) {
        return this.isNotClosed() && user != null && this.getParticipant(user) != null;
    }

    public boolean isNotClosed() {
        return !this.getState().isClosedMetaState();
    }

    public Set<FecruUser> getParticipantsAsUsers() {
        HashSet<FecruUser> users = new HashSet<FecruUser>();
        for (ReviewParticipant p2 : this.getParticipants()) {
            if (p2.getUser() == null) continue;
            users.add(p2.getUser());
        }
        return users;
    }

    public boolean isParticipant(@Nullable FecruUser user) {
        return user != null && this.getParticipant(user) != null;
    }

    public boolean isUncompletedParticipant(FecruUser user) {
        ReviewParticipant p2 = this.getParticipant(user);
        return p2 != null && !p2.isAllComplete();
    }

    public boolean isCompletedParticipant(FecruUser user) {
        ReviewParticipant p2 = this.getParticipant(user);
        return p2 != null && p2.isAllComplete();
    }

    public List<FRXRevision> getFRXRevisions() {
        ArrayList<FRXRevision> result = new ArrayList<FRXRevision>();
        for (FileRevisionExtraInfo frx : this.frxs) {
            result.addAll(frx.getFrxRevisions());
        }
        return result;
    }

    public int getFrxsCount() {
        return this.frxs.size();
    }

    public List<CrucibleRevision> getRevisions() {
        List<FRXRevision> frxRevisions = this.getFRXRevisions();
        ArrayList<CrucibleRevision> cruRevisions = new ArrayList<CrucibleRevision>();
        for (FRXRevision frxRev : frxRevisions) {
            cruRevisions.add(frxRev.getRevision());
        }
        return cruRevisions;
    }

    public Set<FileRevisionExtraInfo> getFrxs() {
        return this.frxs;
    }

    protected void setFrxs(Set<FileRevisionExtraInfo> frxs) {
        this.frxs = frxs;
    }

    public FileRevisionExtraInfo addRevision(CrucibleRevision fr) {
        return FRXManager.createAndAddFRX(fr, this);
    }

    public synchronized boolean removeRevision(CrucibleRevision fr) {
        if (fr == null) {
            return false;
        }
        FileRevisionExtraInfo frx = this.getFRX(fr);
        boolean success = false;
        if (frx != null) {
            success = this.removeCrucibleRevision(frx, fr);
        }
        return success;
    }

    public synchronized boolean removeFRXRevision(FRXRevision frxRev) {
        FileRevisionExtraInfo frx = frxRev.getFrx();
        for (InlineCommentRevisionDetail icd : frxRev.getInlineCommentRevisionDetails()) {
            if (icd.getInlineComment().isDeleted() || icd.getInlineComment().isDraft()) continue;
            Logs.APP_LOG.warn((Object)("FRXRevision " + frxRev.getId() + " has comments and cannot be deleted."));
            return false;
        }
        frx.removeInlineCommentDetails(frxRev.getInlineCommentRevisionDetails());
        frx.getFrxRevisions().remove(frxRev);
        this.removeFRXRevisionImpl(frxRev);
        boolean success = true;
        if (frx.getFrxRevisions() != null) {
            int i2 = 0;
            for (FRXRevision dbFrxRev : frx.getFrxRevisions()) {
                if (dbFrxRev == null) continue;
                dbFrxRev.setOrder(i2++);
            }
        }
        if (frx.getFrxRevisions().isEmpty()) {
            success = this.removeFRX(frx);
        }
        return success;
    }

    private void removeFRXRevisionImpl(FRXRevision frxRev) {
        FRXManager.delete(frxRev);
        frxRev.setFrx(null);
    }

    private synchronized boolean removeCrucibleRevision(FileRevisionExtraInfo frx, CrucibleRevision fr) {
        FRXRevision toRemove = null;
        for (FRXRevision rev : frx.getFrxRevisions()) {
            if (!rev.getRevision().equals(fr)) continue;
            toRemove = rev;
            break;
        }
        return toRemove != null && this.removeFRXRevision(toRemove);
    }

    public synchronized boolean removeFRX(FileRevisionExtraInfo frx) {
        if (!this.getState().isDraftState() && frx.isAnyPostedComments()) {
            return false;
        }
        for (FRXComment fc : frx.getFrxComments()) {
            FRXCommentManager.deleteFrxComment(fc);
        }
        frx.getFrxComments().clear();
        for (InlineComment ic : frx.getInlineComments()) {
            InlineCommentManager.delete(ic);
        }
        frx.getInlineComments().clear();
        for (FRXRevision frxRevision : frx.getFrxRevisions()) {
            this.removeFRXRevisionImpl(frxRevision);
        }
        this.getUnreadFileManager().deleteReadStatuses(frx);
        List<FRXRevision> frxRevs = frx.getFrxRevisions();
        for (FRXRevision frxRev : frxRevs) {
            HibernateUtil.currentSession().delete((Object)frxRev);
        }
        frxRevs.clear();
        HibernateUtil.currentSession().delete((Object)frx);
        return this.frxs.remove(frx);
    }

    public String toString() {
        return this.getPermaId() + ": " + super.toString();
    }

    public String getLink() {
        return AppConfig.getsConfig().getSiteURL() + "/cru/" + this.getPermaId();
    }

    public void cleanupAllComments() {
        this.cleanupAllComments(null);
    }

    public void cleanupAllComments(FecruUser user) {
        this.cleanUpComments(user);
        for (FileRevisionExtraInfo frx : this.frxs) {
            frx.cleanUpRevisionComments(user);
        }
    }

    @Override
    public void deleteAllComments() {
        super.deleteAllComments();
        for (FileRevisionExtraInfo frx : this.frxs) {
            frx.deleteAllComments();
        }
    }

    private ProjectManager getProjectManager() {
        if (this.projectManager == null) {
            this.projectManager = (ProjectManager)SpringContext.getComponent("projectManager");
        }
        return this.projectManager;
    }

    private UnreadFileManager getUnreadFileManager() {
        if (this.unreadFileManager == null) {
            this.unreadFileManager = SpringContext.getComponentByClass(UnreadFileManager.class);
        }
        return this.unreadFileManager;
    }

    public boolean isDescendantOf(Review parent) {
        return this != parent && this.isUnseenDescendantOf(parent, new HashSet<Integer>());
    }

    private boolean isUnseenDescendantOf(Review parent, Set<Integer> seenReviews) {
        if (this.getParentReview() == null) {
            return false;
        }
        seenReviews.add(this.getParentReview().getId());
        return seenReviews.contains(parent.getId()) || this.getParentReview().isUnseenDescendantOf(parent, seenReviews);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof Review)) {
            return false;
        }
        Integer oid = ((Review)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id;
    }

    public String getDefaultSource() {
        return this.defaultSource;
    }

    public void setDefaultSource(String defaultSource) {
        this.defaultSource = defaultSource;
    }

    public int getStatePercentComplete() {
        if (!this.getState().isReviewState()) {
            return 100;
        }
        int total = 0;
        int numReviewers = 0;
        for (ReviewParticipant participant : this.getParticipants()) {
            if (!participant.isReviewer()) continue;
            total = (int)((double)total + (participant.isAllComplete() ? 100.0 : 0.9 * (double)participant.getPercentageComplete().intValue()));
            ++numReviewers;
        }
        if (numReviewers == 0) {
            return 0;
        }
        double result = total / numReviewers;
        int chunkSize = 12;
        return (int)(Math.floor(result / (double)chunkSize) * (double)chunkSize);
    }

    public String getBestSuggestedJiraIssueKey() {
        Set<String> suggestedKeys = this.getSuggestedJiraIssueKeys();
        if (!suggestedKeys.isEmpty()) {
            return suggestedKeys.iterator().next();
        }
        return null;
    }

    public Set<String> getSuggestedJiraIssueKeys() {
        String name = this.getName();
        String description = this.getDescription();
        String message = StringUtils.defaultString((String)name) + " " + StringUtils.defaultString((String)description);
        return new LinkedHashSet<String>(JiraIssueUtil.getJiraKeysFromString(message));
    }

    public void checkRoomForMoreContentExists() throws ReviewContentTooLargeException {
        int limit = CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT;
        int count = 0;
        for (FileRevisionExtraInfo frx : this.getFrxs()) {
            if ((count += frx.getFrxRevisions().size()) < limit) continue;
            throw new ReviewContentTooLargeException(limit);
        }
    }

    public static enum ReviewType {
        REVIEW(1, ReviewData.ReviewType.REVIEW, "Review"),
        SNIPPET(2, ReviewData.ReviewType.SNIPPET, "Snippet");

        private static final Map<Integer, ReviewType> idToType;
        private final int dbId;
        private final String name;
        private final ReviewData.ReviewType apiReviewType;

        public static ReviewType byId(int id) {
            return idToType.get(id);
        }

        public static ReviewType fromApiReviewType(ReviewData.ReviewType apiReviewType) {
            for (ReviewType type : ReviewType.values()) {
                if (!type.getApiReviewType().equals((Object)apiReviewType)) continue;
                return type;
            }
            throw new IllegalArgumentException("Could not convert ReviewData.ReviewType to ReviewType from: " + apiReviewType);
        }

        private ReviewType(int dbId, ReviewData.ReviewType apiReviewType, String name) {
            this.dbId = dbId;
            this.apiReviewType = apiReviewType;
            this.name = name;
        }

        public int getId() {
            return this.dbId;
        }

        public ReviewData.ReviewType getApiReviewType() {
            return this.apiReviewType;
        }

        public String getName() {
            return this.name;
        }

        static {
            HashMap<Integer, ReviewType> map = new HashMap<Integer, ReviewType>(ReviewType.values().length);
            for (ReviewType type : ReviewType.values()) {
                map.put(type.getId(), type);
            }
            idToType = Collections.unmodifiableMap(map);
        }
    }

    public static enum AttachMethod {
        DIFF_TO_PREVIOUS,
        ITERATION,
        SPECIFIC_DIFF,
        REVIEWED_DIFF,
        WHOLE_FILE,
        LAST_BRANCH_POINT,
        SINGLE_REVISION;


        public String getName() {
            return this.name();
        }
    }
}

