/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.ModelUtils;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.SuggestedReviewerConfig;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.rep.DbException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Project
implements Serializable {
    private Integer id;
    private String name;
    private String projKey;
    private Set<FecruUser> defaultReviewerUsers = new HashSet<FecruUser>();
    private Set<FecruUser> allowedReviewerUsers = new HashSet<FecruUser>();
    private Set<String> defaultReviewerGroups = new HashSet<String>();
    private Set<String> allowedReviewerGroups = new HashSet<String>();
    private FecruUser defaultModerator;
    private String defaultRepositoryName;
    private PermissionScheme permissionScheme;
    private boolean allowReviewersToJoin;
    private boolean storeRevisions;
    private SuggestedReviewerConfig suggestedReviewerConfig = new SuggestedReviewerConfig();
    private Integer defaultDuration;
    private Set<ContentRoot> contentRoots = new HashSet<ContentRoot>();
    private String defaultObjectives;
    private boolean moderatorDisabled;

    public String getDefaultObjectives() {
        return this.defaultObjectives;
    }

    public void setDefaultObjectives(String defaultObjectives) {
        this.defaultObjectives = defaultObjectives;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        ModelUtils.ensureNotNullOrEmpty("name", name);
        this.name = name;
    }

    public String getkey() {
        return this.projKey;
    }

    public String getProjKey() {
        return this.projKey;
    }

    public void setProjKey(String projKey) {
        ModelUtils.ensureNotNullOrEmpty("project key", projKey);
        this.projKey = projKey;
    }

    public SuggestedReviewerConfig getSuggestedReviewerConfig() {
        return this.suggestedReviewerConfig;
    }

    public void setSuggestedReviewerConfig(SuggestedReviewerConfig suggestedReviewerConfig) {
        this.suggestedReviewerConfig = suggestedReviewerConfig;
    }

    public Set<FecruUser> getDefaultReviewerUsers() {
        return this.defaultReviewerUsers;
    }

    public void setDefaultReviewerUsers(Set<FecruUser> defaultReviewerUsers) {
        this.defaultReviewerUsers = defaultReviewerUsers;
    }

    public Set<FecruUser> getAllowedReviewerUsers() {
        return this.allowedReviewerUsers;
    }

    public Set<FecruUser> getAllowedReviewers() throws DbException {
        HashSet<FecruUser> allUsers = new HashSet<FecruUser>(this.getAllowedReviewerUsers());
        CrucibleUserManager cum = (CrucibleUserManager)SpringContext.getComponent("crucibleUserManager");
        for (String groupName : this.allowedReviewerGroups) {
            allUsers.addAll(cum.getGroupOfUsers(groupName));
        }
        return allUsers;
    }

    public void setAllowedReviewerUsers(Set<FecruUser> allowedReviewerUsers) {
        this.allowedReviewerUsers = allowedReviewerUsers;
    }

    public Set<String> getDefaultReviewerGroups() {
        return this.defaultReviewerGroups;
    }

    public Set<FecruUser> getDefaultReviewers() throws DbException {
        HashSet<FecruUser> allUsers = new HashSet<FecruUser>(this.getDefaultReviewerUsers());
        CrucibleUserManager cum = (CrucibleUserManager)SpringContext.getComponent("crucibleUserManager");
        for (String groupName : this.defaultReviewerGroups) {
            allUsers.addAll(cum.getGroupOfUsers(groupName));
        }
        return allUsers;
    }

    public void setDefaultReviewerGroups(Set<String> defaultReviewerGroups) {
        this.defaultReviewerGroups = defaultReviewerGroups;
    }

    public Set<String> getAllowedReviewerGroups() {
        return this.allowedReviewerGroups;
    }

    public void setAllowedReviewerGroups(Set<String> allowedReviewerGroups) {
        this.allowedReviewerGroups = allowedReviewerGroups;
    }

    public FecruUser getDefaultModerator() {
        return this.defaultModerator;
    }

    public void setDefaultModerator(FecruUser defaultModerator) {
        this.defaultModerator = defaultModerator;
    }

    public String getDefaultRepositoryName() {
        return this.defaultRepositoryName;
    }

    public String getDefaultRepositoryNameIfFisheyeRepository() {
        String result = null;
        if (StringUtils.isEmpty((String)this.defaultRepositoryName)) {
            result = null;
        } else if (this.hasExtantDefaultFisheyeRepo()) {
            result = this.defaultRepositoryName;
        }
        return result;
    }

    protected boolean hasExtantDefaultFisheyeRepo() {
        return !StringUtils.isEmpty((String)this.defaultRepositoryName) && AppConfig.getsConfig().getRepositoryManager().getRepository(this.defaultRepositoryName) != null;
    }

    public void setDefaultRepositoryName(String defaultRepositoryName) {
        this.defaultRepositoryName = defaultRepositoryName;
    }

    public PermissionScheme getPermissionScheme() {
        return this.permissionScheme;
    }

    public void setPermissionScheme(PermissionScheme permissionScheme) {
        this.permissionScheme = permissionScheme;
    }

    public boolean isAllowReviewersToJoin() {
        return this.allowReviewersToJoin;
    }

    public void setAllowReviewersToJoin(boolean allowReviewersToJoin) {
        this.allowReviewersToJoin = allowReviewersToJoin;
    }

    public void removeReview(Review review) {
        if (!this.equals(review.getProject())) {
            throw new IllegalArgumentException("this review does not belong to this project");
        }
        review.setProject(null);
    }

    public boolean isStoreRevisions() {
        return this.storeRevisions;
    }

    public void setStoreRevisions(boolean storeRevisions) {
        this.storeRevisions = storeRevisions;
    }

    public boolean isModeratorEnabled() {
        return !this.isModeratorDisabled();
    }

    public boolean isModeratorDisabled() {
        return this.moderatorDisabled;
    }

    public void setModeratorDisabled(boolean moderatorDisabled) {
        this.moderatorDisabled = moderatorDisabled;
    }

    public Integer getDefaultDuration() {
        return this.defaultDuration;
    }

    public Long getDefaultDurationInMillis() {
        if (this.getDefaultDuration() == null) {
            return null;
        }
        return (long)(this.getDefaultDuration() * 24 * 60 * 60) * 1000L;
    }

    public void setDefaultDuration(Integer defaultDuration) {
        this.defaultDuration = defaultDuration != null && defaultDuration == 0 ? null : defaultDuration;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof Project)) {
            return false;
        }
        Integer oid = ((Project)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id;
    }

    public Set<ContentRoot> getContentRoots() {
        return this.contentRoots;
    }

    public void setContentRoots(Set<ContentRoot> contentRoots) {
        this.contentRoots = contentRoots;
    }

    public void addContentRoot(ContentRoot contentRoot) {
        this.contentRoots.add(contentRoot);
    }

    public void removeContentRoot(ContentRoot contentRoot) {
        if (!this.contentRoots.remove(contentRoot)) {
            throw new IllegalStateException("Failed deletion of content root from project " + this.name);
        }
        contentRoot.setProject(null);
    }

    public List<ContentRoot> getAllContentRootsForRep(String repname) {
        ArrayList<ContentRoot> results = new ArrayList<ContentRoot>();
        for (ContentRoot contentRoot : this.contentRoots) {
            if (!contentRoot.getRepName().equals(repname)) continue;
            results.add(contentRoot);
        }
        return results;
    }

    public boolean contentRootExists(String repname, String path) {
        Iterator<ContentRoot> it = this.contentRoots.iterator();
        boolean found = false;
        while (it.hasNext()) {
            ContentRoot current = it.next();
            if (!current.getRepName().equals(repname) || !current.getPath().equals(path)) continue;
            found = true;
        }
        return found;
    }

    public static String upperCaseProjectKey(String projectKey) {
        if (projectKey != null) {
            String projectKeyUppercase = projectKey.toUpperCase(Locale.US);
            if (!projectKey.equals(projectKeyUppercase)) {
                Logs.APP_LOG.debug((Object)String.format("Uppercasing project key: %s to %s", projectKey, projectKeyUppercase));
            }
            return projectKeyUppercase;
        }
        return null;
    }

    public static class NameComparator
    implements Comparator<Project> {
        @Override
        public int compare(Project p1, Project p2) {
            return p1.getName().compareToIgnoreCase(p2.getName());
        }
    }
}

