/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.crucible.actions.admin.permschemes.ActionData;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.BasePrincipalAssociation;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PermissionScheme
implements Serializable,
Comparable<PermissionScheme> {
    private Integer id;
    private String name;
    private Set<AnonymousPA> anonymousPAs = new HashSet<AnonymousPA>();
    private Set<AllUserPA> allUsersPAs = new HashSet<AllUserPA>();
    private Set<UserPA> userPAs = new HashSet<UserPA>();
    private Set<GroupPA> groupPAs = new HashSet<GroupPA>();
    private Set<RolePA> reviewRolePAs = new HashSet<RolePA>();

    public PermissionScheme() {
    }

    public PermissionScheme(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<AnonymousPA> getAnonymousPAs() {
        return this.anonymousPAs;
    }

    private void setAnonymousPAs(Set<AnonymousPA> anonymousPAs) {
        this.anonymousPAs = anonymousPAs;
    }

    public boolean addAnonAction(String actionName) {
        AnonymousPA pa;
        if (this.anonymousPAs == null) {
            this.anonymousPAs = new HashSet<AnonymousPA>();
        }
        if (!this.anonymousPAs.contains(pa = new AnonymousPA(this, actionName))) {
            HibernateUtil.currentSession().save((Object)pa);
            this.anonymousPAs.add(pa);
            return true;
        }
        return false;
    }

    public boolean removeAnonAction(String actionName) {
        if (this.anonymousPAs == null) {
            return false;
        }
        for (AnonymousPA pa : this.anonymousPAs) {
            if (!actionName.equals(pa.getActionName())) continue;
            HibernateUtil.currentSession().delete((Object)pa);
            this.anonymousPAs.remove(pa);
            return true;
        }
        return false;
    }

    public Set<AllUserPA> getAllUsersPAs() {
        return this.allUsersPAs;
    }

    private void setAllUsersPAs(Set<AllUserPA> allUsersPAs) {
        this.allUsersPAs = allUsersPAs;
    }

    public boolean addAllUsersAction(String actionName) {
        AllUserPA pa;
        if (this.allUsersPAs == null) {
            this.allUsersPAs = new HashSet<AllUserPA>();
        }
        if (!this.allUsersPAs.contains(pa = new AllUserPA(this, actionName))) {
            HibernateUtil.currentSession().save((Object)pa);
            this.allUsersPAs.add(pa);
            return true;
        }
        return false;
    }

    public boolean removeAllUsersAction(String actionName) {
        if (this.allUsersPAs == null) {
            return false;
        }
        for (AllUserPA pa : this.allUsersPAs) {
            if (!actionName.equals(pa.getActionName())) continue;
            HibernateUtil.currentSession().delete((Object)pa);
            return this.allUsersPAs.remove(pa);
        }
        return false;
    }

    public Set<UserPA> getUserPAs() {
        return this.userPAs;
    }

    private void setUserPAs(Set<UserPA> userPAs) {
        this.userPAs = userPAs;
    }

    private static <E> boolean removeDetachedEntityFromSet(E entity, @Nullable Set<E> set) {
        Preconditions.checkNotNull(entity);
        if (set == null) {
            return false;
        }
        if (set.remove(entity)) {
            HibernateUtil.currentSession().delete(HibernateUtil.currentSession().merge(entity));
            return true;
        }
        return false;
    }

    private static <E> boolean addDetachedEntityToSet(E entity, Set<E> set) {
        Preconditions.checkNotNull(entity);
        Preconditions.checkNotNull(set);
        if (!set.contains(entity)) {
            HibernateUtil.currentSession().save(entity);
            set.add(entity);
            return true;
        }
        return false;
    }

    public boolean addUserAction(String pid, String actionName) {
        if (this.userPAs == null) {
            this.userPAs = new HashSet<UserPA>();
        }
        return PermissionScheme.addDetachedEntityToSet(new UserPA(this, pid, actionName), this.userPAs);
    }

    public boolean removeUserAction(String pid, String actionName) {
        return PermissionScheme.removeDetachedEntityFromSet(new UserPA(this, pid, actionName), this.userPAs);
    }

    public void clearUserAction(String actionName) {
        this.clearAction(actionName, this.userPAs);
    }

    public Set<GroupPA> getGroupPAs() {
        return this.groupPAs;
    }

    private void setGroupPAs(Set<GroupPA> groupPAs) {
        this.groupPAs = groupPAs;
    }

    public boolean addGroupAction(String pid, String actionName) {
        return PermissionScheme.addDetachedEntityToSet(new GroupPA(this, pid, actionName), this.groupPAs);
    }

    public boolean removeGroupAction(String pid, String actionName) {
        return PermissionScheme.removeDetachedEntityFromSet(new GroupPA(this, pid, actionName), this.groupPAs);
    }

    public void clearGroupAction(String actionName) {
        this.clearAction(actionName, this.groupPAs);
    }

    public Set<RolePA> getReviewRolePAs() {
        return this.reviewRolePAs;
    }

    private void setReviewRolePAs(Set<RolePA> reviewRolePAs) {
        this.reviewRolePAs = reviewRolePAs;
    }

    public boolean addReviewRoleAction(String pid, String actionName) {
        return PermissionScheme.addDetachedEntityToSet(new RolePA(this, pid, actionName), this.reviewRolePAs);
    }

    public boolean removeReviewRoleAction(String pid, String actionName) {
        return PermissionScheme.removeDetachedEntityFromSet(new RolePA(this, pid, actionName), this.reviewRolePAs);
    }

    public void clearReviewRoleAction(String actionName) {
        this.clearAction(actionName, this.reviewRolePAs);
    }

    private void clearAction(String actionName, Collection c2) {
        if (c2 == null) {
            return;
        }
        HashSet<BasePrincipalAssociation> removed = new HashSet<BasePrincipalAssociation>();
        for (Object pa : c2) {
            BasePrincipalAssociation bpa = (BasePrincipalAssociation)pa;
            if (!actionName.equals(bpa.getActionName())) continue;
            HibernateUtil.currentSession().delete(HibernateUtil.currentSession().merge(pa));
            removed.add(bpa);
        }
        c2.removeAll(removed);
    }

    public boolean isAnonymousAllowed(String actionName) {
        UserActionManager.Action a2 = UserActionManager.getInstance().getAction(actionName);
        if (a2 != null && !a2.allowsAnonymousPermission()) {
            return false;
        }
        for (AnonymousPA pa : this.anonymousPAs) {
            if (!pa.getActionName().equals(actionName)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllUserAllowed(String actionName) {
        for (AllUserPA pa : this.allUsersPAs) {
            if (!pa.getActionName().equals(actionName)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedByGroup(List<String> groups, String actionName) {
        for (String group : groups) {
            if (!this.groupPAs.contains(new GroupPA(this, group, actionName))) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedByUser(String userName, String actionName) {
        for (UserPA pa : this.userPAs) {
            if (!pa.getActionName().equals(actionName) || !pa.getPid().equals(UserManager.USERNAME_NORMALIZATION.apply(userName))) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedByRole(List<Role> roles, String actionName) {
        for (Role role : roles) {
            for (RolePA pa : this.reviewRolePAs) {
                if (!pa.getActionName().equals(actionName) || !pa.getPid().equals(role.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof PermissionScheme)) {
            return false;
        }
        Integer oid = ((PermissionScheme)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id;
    }

    @Override
    public int compareTo(PermissionScheme o2) {
        return StringUtils.defaultString((String)this.getName()).compareTo(StringUtils.defaultString((String)o2.getName()));
    }

    public boolean getRequiresModerator() {
        return this.calculateRequiresModerator(null);
    }

    public List<String> getModeratorPermissionConflicts() {
        ArrayList<String> conflicts = new ArrayList<String>();
        this.calculateRequiresModerator(conflicts);
        return conflicts;
    }

    public String toString() {
        return "PermissionScheme{id=" + this.id + ", name='" + this.name + '\'' + '}';
    }

    private boolean calculateRequiresModerator(List<String> conflicts) {
        LinkedHashMap<String, ActionData> actionMap = new LinkedHashMap<String, ActionData>();
        for (UserActionManager.Action action : UserActionManager.getInstance().getActions()) {
            actionMap.put(action.getName(), new ActionData(action));
        }
        for (RolePA rolePA : this.getReviewRolePAs()) {
            ActionData ad2 = (ActionData)actionMap.get(rolePA.getActionName());
            ad2.addRole(rolePA.getPid());
        }
        for (AllUserPA allUserPA : this.getAllUsersPAs()) {
            actionMap.remove(allUserPA.getActionName());
        }
        for (AnonymousPA anonymousPA : this.getAnonymousPAs()) {
            actionMap.remove(anonymousPA.getActionName());
        }
        for (UserPA userPA : this.getUserPAs()) {
            actionMap.remove(userPA.getActionName());
        }
        for (GroupPA groupPA : this.getGroupPAs()) {
            actionMap.remove(groupPA.getActionName());
        }
        boolean requiresModerator = false;
        for (ActionData ad2 : actionMap.values()) {
            String role;
            Set<String> roles = ad2.getRoles();
            if (roles.size() != 1 || !(role = roles.iterator().next()).equals(ReviewManager.MODERATOR.getName())) continue;
            if (conflicts != null) {
                String conflict = UserActionManager.getInstance().getAction(ad2.getName()).getDisplayName();
                conflicts.add(conflict);
                requiresModerator = true;
                continue;
            }
            return true;
        }
        return requiresModerator;
    }
}

