/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;

public class PermaIdKey
implements Serializable {
    private String projKey;
    private int number;

    PermaIdKey() {
    }

    public PermaIdKey(String projKey, int number) {
        this.setProjKey(projKey);
        this.setNumber(number);
    }

    public static PermaIdKey parsePermaId(String permaId) {
        Matcher m2 = ReviewManager.PERMAID_PROG.matcher(PermaIdKey.upperCasePermaId(permaId));
        if (m2.matches()) {
            return new PermaIdKey(m2.group(1), Integer.parseInt(m2.group(2)));
        }
        return null;
    }

    public String getkey() {
        return this.projKey;
    }

    public String getProjKey() {
        return this.projKey;
    }

    public void setProjKey(String projKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projKey) ? 1 : 0) != 0, (Object)("Project key may not be null or empty: " + projKey));
        String projectKeyUppercase = projKey.toUpperCase(Locale.US);
        Preconditions.checkArgument((boolean)projectKeyUppercase.equals(projKey), (Object)("Project key must be uppercase: " + projKey + " != " + projectKeyUppercase));
        this.projKey = projKey;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        PermaIdKey that = (PermaIdKey)o2;
        return Objects.equal((Object)this.projKey, (Object)that.projKey) && Objects.equal((Object)this.number, (Object)that.number);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projKey, this.number});
    }

    public String toString() {
        return this.projKey + "-" + this.number;
    }

    public static String upperCasePermaId(String permaId) {
        if (permaId != null) {
            String permaIdUppercase = permaId.toUpperCase(Locale.US);
            if (!permaId.equals(permaIdUppercase)) {
                Logs.APP_LOG.debug((Object)String.format("Uppercasing permaId: %s to %s", permaId, permaIdUppercase));
            }
            return permaIdUppercase;
        }
        return null;
    }
}

