/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.diff.unified.DiffDirectory;
import com.cenqua.crucible.revision.source.PatchRevision;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public class Patch {
    private Integer id;
    private Review review;
    private UploadItem uploadItem;
    private List<CrucibleRevision> crucibleRevisions;
    private List<DiffRevisionsInfo> diffRevisionsInfos;
    private boolean anchored;
    private String anchorSource;
    private Integer stripCount;
    private String anchorPath;
    private boolean availableForAdding;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
    }

    public UploadItem getUploadItem() {
        return this.uploadItem;
    }

    public void setUploadItem(UploadItem uploadItem) throws IOException {
        this.uploadItem = uploadItem;
        this.crucibleRevisions = new LinkedList<CrucibleRevision>();
    }

    public List<CrucibleRevision> getFileRevisions() {
        return this.crucibleRevisions;
    }

    public void setFileRevisions(List<CrucibleRevision> crucibleRevisions) {
        this.crucibleRevisions = crucibleRevisions;
    }

    public CrucibleRevision getFileRevisionFromDRI(DiffRevisionsInfo dri) {
        String revId = new PatchRevision(this, dri, false).toString();
        for (CrucibleRevision fr : this.crucibleRevisions) {
            if (!fr.getRevision().equals(revId)) continue;
            return fr;
        }
        return null;
    }

    public CrucibleRevision getFromRevisionFromDRI(DiffRevisionsInfo dri) {
        String revId = new PatchRevision(this, dri, true).toString();
        for (CrucibleRevision fr : this.crucibleRevisions) {
            if (!fr.getRevision().equals(revId)) continue;
            return fr;
        }
        return null;
    }

    public DiffRevisionsInfo getDiffRevisionInfo(CrucibleRevision crucibleRevision) throws IOException {
        try {
            for (DiffRevisionsInfo dri : this.getDiffRevisions()) {
                if (!this.driRevisionMatch(crucibleRevision, dri)) continue;
                return dri;
            }
        }
        catch (PatchException e2) {
            Logs.APP_LOG.error((Object)"Problem getting patch information.", (Throwable)e2);
        }
        return null;
    }

    private boolean driRevisionMatch(CrucibleRevision cruRev, DiffRevisionsInfo dri) {
        int driIndex = PatchRevision.fromCrucibleRevision((CrucibleRevision)cruRev).driIndex;
        return dri.getIndex() == driIndex;
    }

    public List<DiffRevisionsInfo> getDiffRevisions() throws IOException, PatchException {
        if (this.diffRevisionsInfos == null) {
            String charSet = this.uploadItem.getCharset() == null ? "UTF-8" : this.uploadItem.getCharset();
            this.diffRevisionsInfos = DiffDirectory.list(this.uploadItem.getItemFile(), Charset.forName(charSet));
        }
        return this.diffRevisionsInfos;
    }

    public File getPatchFile() {
        return this.uploadItem.getItemFile();
    }

    public String getAnchorPath() {
        return this.anchorPath;
    }

    public void setAnchorPath(String anchorPath) {
        this.anchorPath = anchorPath;
    }

    public Integer getStripCount() {
        return this.stripCount == null ? 0 : this.stripCount;
    }

    public void setStripCount(Integer stripCount) {
        this.stripCount = stripCount;
    }

    public String getAnchorSource() {
        return this.anchorSource;
    }

    public void setAnchorSource(String anchorSource) {
        this.anchorSource = anchorSource;
    }

    public String getAnchoredPath(String path) {
        return new Path(this.getAnchorPath(), new Path(path).trimFirst(this.getStripCount())).getPath();
    }

    public Path getAnchoredPath(Path path) {
        return new Path(this.getAnchoredPath(path.toString()));
    }

    public void setAnchored(boolean anchored) {
        this.anchored = anchored;
    }

    public boolean isAnchored() {
        return this.anchored;
    }

    public String getSourceName() {
        if (!this.crucibleRevisions.isEmpty()) {
            return this.crucibleRevisions.get(0).getSourceName();
        }
        return null;
    }

    public boolean isAvailableForAdding() {
        return this.availableForAdding;
    }

    public void setAvailableForAdding(boolean availableForAdding) {
        this.availableForAdding = availableForAdding;
    }
}

