/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.ModelUtils;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.util.SortedSet;

public class InlineCommentRevisionDetail {
    private Integer id;
    private FRXRevision frxRevision;
    private String lineRange;
    private InlineComment inlineComment;

    InlineCommentRevisionDetail() {
    }

    public InlineCommentRevisionDetail(FRXRevision frxRevision, InlineComment inlineComment, String lineRange) {
        this.setFrxRevision(frxRevision);
        this.setInlineComment(inlineComment);
        this.setLineRange(lineRange);
    }

    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }

    public FRXRevision getFrxRevision() {
        return this.frxRevision;
    }

    public void setFrxRevision(FRXRevision frxRevision) {
        this.frxRevision = frxRevision;
    }

    public String getLineRange() {
        return this.lineRange;
    }

    public SortedSet<Integer> getIndividualLines() {
        IntAVLTreeSet lines = new IntAVLTreeSet();
        for (String continualRange : this.lineRange.split(",")) {
            int start;
            if (Strings.isNullOrEmpty((String)(continualRange = continualRange.trim()))) continue;
            String[] startAndEnd = continualRange.split("-");
            int end = start = Integer.parseInt(startAndEnd[0].trim());
            if (startAndEnd.length == 2) {
                end = Integer.parseInt(startAndEnd[1].trim());
            }
            while (start <= end) {
                lines.add(start++);
            }
        }
        return lines;
    }

    public void setLineRange(String lineRange) {
        ModelUtils.ensureNotNullOrEmpty("Line ranges", lineRange);
        this.lineRange = lineRange;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof InlineCommentRevisionDetail)) {
            return false;
        }
        Integer oid = ((InlineCommentRevisionDetail)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id;
    }

    public InlineComment getInlineComment() {
        return this.inlineComment;
    }

    public void setInlineComment(InlineComment inlineComment) {
        this.inlineComment = inlineComment;
    }
}

