/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentWrapper;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.cenqua.fisheye.util.Pair;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InlineComment
extends CommentWrapper {
    private FileRevisionExtraInfo frx;
    private Set<InlineCommentRevisionDetail> details = new HashSet<InlineCommentRevisionDetail>();
    public static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("^(.*[^\\d]+)?([\\d]+)$");

    public InlineComment() {
    }

    public InlineComment(FileRevisionExtraInfo frx, Comment comment) {
        this.frx = frx;
        this.setComment(comment);
    }

    public FileRevisionExtraInfo getFrx() {
        return this.frx;
    }

    public void setFrx(FileRevisionExtraInfo frx) {
        this.frx = frx;
    }

    public Set<InlineCommentRevisionDetail> getDetails() {
        return this.details;
    }

    private Pair<InlineCommentRevisionDetail, InlineCommentRevisionDetail> computeToFrom() {
        Set<InlineCommentRevisionDetail> details = this.getDetails();
        InlineCommentRevisionDetail from = null;
        InlineCommentRevisionDetail to = null;
        if (details.size() == 1) {
            to = details.iterator().next();
        } else {
            for (InlineCommentRevisionDetail detail : details) {
                int idx = detail.getFrxRevision().getOrder();
                if (idx == 0) {
                    from = detail;
                }
                if (idx != details.size() - 1) continue;
                to = detail;
            }
        }
        return Pair.newInstance(from, to);
    }

    public InlineCommentRevisionDetail getToDetail() {
        return this.computeToFrom().getSecond();
    }

    public InlineCommentRevisionDetail getFromDetail() {
        return this.computeToFrom().getFirst();
    }

    private void setDetails(Set<InlineCommentRevisionDetail> details) {
        this.details = details;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof InlineComment)) {
            return false;
        }
        Integer oid = ((InlineComment)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    @Override
    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id;
    }

    public int getHighestLineNumber() {
        int highest = 0;
        for (InlineCommentRevisionDetail detail : this.getDetails()) {
            int i2 = InlineComment.parseLineNumber(detail.getLineRange());
            if (i2 <= highest) continue;
            highest = i2;
        }
        return highest;
    }

    @VisibleForTesting
    static int parseLineNumber(String toStr) {
        Matcher matcher = LINE_NUMBER_PATTERN.matcher(toStr.trim());
        matcher.find();
        return Integer.parseInt(matcher.group(matcher.groupCount()));
    }
}

