/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.InlineCommentManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class FileRevisionExtraInfo {
    public static final String PERMAID_PREFIX = "CFR-";
    public static final int SCOPE_REVIEW_ALL = 0;
    public static final int SCOPE_REVIEW_CHANGES = 1;
    public static final int REVIEWED_NOT = -1;
    public static final int REVIEWED_ALL = 0;
    public static final int REVIEWED_CHANGES = 1;
    public static final int FURTHER_ACTION_NO = 0;
    public static final int FURTHER_ACTION_YES = 1;
    public static final int FURTHER_ACTION_COMPLETED = 2;
    private Integer id;
    private Review review;
    private Long whenAdded;
    private Integer reviewed = -1;
    private Integer furtherAction = 0;
    private Integer reviewScope = 0;
    private Set<FRXComment> frxComments = new HashSet<FRXComment>();
    private Set<InlineComment> inlineComments = new HashSet<InlineComment>();
    private Integer frx_order;
    private Boolean showAsDiff = true;
    protected List<FRXRevision> frxRevisions = new ArrayList<FRXRevision>();
    private static final HibernateUtil.ListAccessor<FRXRevision> indexSetter = new HibernateUtil.ListAccessor<FRXRevision>(){

        @Override
        public void resetIndexOf(FRXRevision frxRevision, int i2) {
            frxRevision.setOrder(i2);
        }

        @Override
        public int getIndexOf(FRXRevision frxRevision) {
            return frxRevision.getOrder();
        }

        @Override
        public Comparator<? super FRXRevision> getComparator(@Nonnull FRXRevision r2) {
            final Source source = ((SourceFactory)SpringContext.getComponent("sourceFactory")).getSource(r2.getRevision().getSourceName(), (Principal)Principal.SuperUser.INSTANCE);
            if (!source.isAvailable()) {
                return null;
            }
            return new Comparator<FRXRevision>(){

                @Override
                public int compare(FRXRevision o1, FRXRevision o2) {
                    try {
                        return source.compareFileRevisions(o1.getRevision(), o2.getRevision());
                    }
                    catch (SourceException e2) {
                        Logs.APP_LOG.warn((Object)("Error comparing FRXRevisions " + o1 + " and " + o2), (Throwable)e2);
                        return 0;
                    }
                }
            };
        }
    };
    protected boolean frxRevisionsIsClean = false;
    private Integer reviewId;

    public Integer getReviewId() {
        return this.reviewId;
    }

    protected void setReviewId(Integer reviewId) {
        this.reviewId = reviewId;
    }

    public FileRevisionExtraInfo() {
    }

    public FileRevisionExtraInfo(Review review, Date whenAdded) {
        this.review = review;
        this.reviewId = review.getId();
        this.whenAdded = whenAdded.getTime();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPermaId() {
        return PERMAID_PREFIX + this.id;
    }

    public static Integer getIdFromPermaId(String permaId) {
        if (permaId == null || !permaId.startsWith(PERMAID_PREFIX)) {
            return null;
        }
        try {
            return new Integer(permaId.substring(PERMAID_PREFIX.length()));
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public Integer getFrx_order() {
        return this.frx_order;
    }

    public void setFrx_order(Integer frx_order) {
        this.frx_order = frx_order;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
        if (review != null) {
            this.setReviewId(review.getId());
        }
    }

    public CrucibleRevision getFileRevision() {
        FRXRevision frxRev = this.getFileFRXRevision();
        return frxRev == null ? null : frxRev.getRevision();
    }

    public FRXRevision getFileFRXRevision() {
        List<FRXRevision> frxRevs = this.getFrxRevisions();
        if (frxRevs.size() == 0) {
            return null;
        }
        return frxRevs.get(frxRevs.size() - 1);
    }

    public Set<FRXComment> getFrxComments() {
        return this.frxComments;
    }

    public boolean isAnyPostedComments() {
        return !DefaultCommentManager.getInstance().comments(this).where(DiscussionClauses.visibleToAll()).isEmpty();
    }

    public void setFrxComments(Set<FRXComment> frxComment) {
        this.frxComments = frxComment;
    }

    public void addFrxComment(FRXComment frxComment) {
        this.frxComments.add(frxComment);
    }

    public void removeFrxComment(FRXComment frxComment) {
        frxComment.setFrx(null);
        this.frxComments.remove(frxComment);
    }

    public void removeInlineComment(InlineComment inlineComment) {
        inlineComment.setFrx(null);
        this.inlineComments.remove(inlineComment);
    }

    public Date getWhenAdded() {
        return new Date(this.whenAdded);
    }

    public void setWhenAdded(Date whenAdded) {
        this.whenAdded = whenAdded.getTime();
    }

    public Long getWhenAddedTime() {
        return this.whenAdded;
    }

    public void setWhenAddedTime(Long whenAdded) {
        this.whenAdded = whenAdded;
    }

    public Integer getReviewed() {
        return this.reviewed;
    }

    public void setReviewed(Integer reviewed) {
        this.reviewed = reviewed;
    }

    public Integer getFurtherAction() {
        return this.furtherAction;
    }

    public void setFurtherAction(Integer furtherAction) {
        this.furtherAction = furtherAction;
    }

    public Integer getReviewScope() {
        return this.reviewScope;
    }

    public void setReviewScope(Integer reviewScope) {
        this.reviewScope = reviewScope;
    }

    public Path getFePath() {
        CrucibleRevision fr = this.getFileRevision();
        return fr == null ? null : fr.getFePath();
    }

    public CrucibleRevision getFromRevision() {
        FRXRevision frxRev = this.getFromFRXRevision();
        return frxRev == null ? null : frxRev.getRevision();
    }

    public FRXRevision getFromFRXRevision() {
        List<FRXRevision> frxRevs = this.getFrxRevisions();
        if (frxRevs.size() == 0 || frxRevs.size() == 1) {
            return null;
        }
        return frxRevs.get(0);
    }

    public void removeRevision(CrucibleRevision revision) {
        this.getReview().removeRevision(revision);
    }

    public FRXRevision addRevision(int insertAt, CrucibleRevision revision) {
        return new FRXRevisionManager().createFRXRevisionAndUnread(this, insertAt, revision);
    }

    public void cleanUpRevisionComments(FecruUser user) {
        this.cleanUpFrxComments(user);
        this.cleanUpInlineComments(user);
    }

    private void cleanUpFrxComments(FecruUser user) {
        HashSet<FRXComment> removeThese = new HashSet<FRXComment>();
        for (FRXComment rc : this.frxComments) {
            rc.getComment().cleanUpComments(user);
            if (user != null && !rc.getComment().getUser().equals(user) || !rc.isDeleted() && !rc.isDraft()) continue;
            removeThese.add(rc);
        }
        this.removeFrxComments(removeThese);
    }

    private void cleanUpInlineComments(FecruUser user) {
        HashSet<InlineComment> removeThese = new HashSet<InlineComment>();
        for (InlineComment rc : this.inlineComments) {
            rc.getComment().cleanUpComments(user);
            if (user != null && !rc.getComment().getUser().equals(user) || !rc.isDeleted() && !rc.isDraft()) continue;
            removeThese.add(rc);
        }
        this.removeInlineComments(removeThese);
    }

    private void removeFrxComments(Set<FRXComment> removeThese) {
        for (FRXComment rc : removeThese) {
            Comment comment = rc.getComment();
            Review review = comment.getReview();
            this.removeFrxComment(rc);
            FRXCommentManager.deleteFrxComment(rc);
            comment.deleteAllComments();
            DefaultCommentManager.getInstance().deleteCommentAndAnnounce(comment, review);
        }
    }

    public void removeInlineCommentDetails(Set<InlineCommentRevisionDetail> removeThese) {
        HashSet<InlineComment> inlineComments = new HashSet<InlineComment>();
        for (InlineCommentRevisionDetail icd : removeThese) {
            inlineComments.add(icd.getInlineComment());
        }
        this.removeInlineComments(inlineComments);
    }

    private void removeInlineComments(Set<InlineComment> removeThese) {
        for (InlineComment rc : removeThese) {
            Comment comment = rc.getComment();
            Review review = comment.getReview();
            this.removeInlineComment(rc);
            InlineCommentManager.delete(rc);
            comment.deleteAllComments();
            DefaultCommentManager.getInstance().deleteCommentAndAnnounce(comment, review);
        }
    }

    public void deleteAllComments() {
        this.removeFrxComments(new HashSet<FRXComment>(this.getFrxComments()));
        this.removeInlineComments(new HashSet<InlineComment>(this.getInlineComments()));
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof FileRevisionExtraInfo)) {
            return false;
        }
        Integer oid = ((FileRevisionExtraInfo)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id.hashCode();
    }

    public List<CrucibleRevision> getCrucibleRevisions() {
        ArrayList<CrucibleRevision> revisions = new ArrayList<CrucibleRevision>();
        for (FRXRevision frxRev : this.getFrxRevisions()) {
            revisions.add(frxRev.getRevision());
        }
        return revisions;
    }

    public List<FRXRevision> getFrxRevisions() {
        if (!this.frxRevisionsIsClean) {
            HibernateUtil.repairList(this.frxRevisions, indexSetter);
            this.frxRevisionsIsClean = true;
        }
        return this.frxRevisions;
    }

    public void setFrxRevisions(List<FRXRevision> frxRevisions) {
        this.frxRevisions = frxRevisions;
    }

    public boolean isEmpty() {
        return this.getFrxRevisions() == null || this.getFrxRevisions().size() == 0;
    }

    public Set<InlineComment> getInlineComments() {
        return this.inlineComments;
    }

    public void setInlineComments(Set<InlineComment> inlineComments) {
        this.inlineComments = inlineComments;
    }

    public Boolean getShowAsDiff() {
        return this.showAsDiff;
    }

    public void setShowAsDiff(Boolean showAsDiff) {
        this.showAsDiff = showAsDiff;
    }

    public FRXRevision getFRXRevision(CrucibleRevision fr) {
        for (FRXRevision frxRevision : this.getFrxRevisions()) {
            if (!frxRevision.getRevision().equals(fr)) continue;
            return frxRevision;
        }
        return null;
    }

    public List<Comment> getComments() {
        return DefaultCommentManager.getInstance().comments(this).where(DiscussionClauses.visibleToAll()).collect();
    }

    public Long getLatestRevisionAddDateTime() {
        Long time = 0L;
        for (FRXRevision rev : this.getFrxRevisions()) {
            if (rev.getDateTimeAdded().compareTo(time) <= 0) continue;
            time = rev.getDateTimeAdded();
        }
        return time;
    }

    public boolean isDir() {
        CrucibleRevision fr = this.getFileRevision();
        if (fr == null) {
            return false;
        }
        String type = fr.getFileType();
        return ContentManager.FileType.DIRECTORY.name().equals(type);
    }
}

