/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class FRXRevision {
    private Integer id;
    private Long dateAdded;
    private FileRevisionExtraInfo frx;
    private CrucibleRevision revision;
    private Set<InlineCommentRevisionDetail> inlineCommentRevisionDetails = new HashSet<InlineCommentRevisionDetail>();
    private int order;

    public FRXRevision() {
    }

    public FRXRevision(FileRevisionExtraInfo frx, CrucibleRevision fr, Date dateAdded) {
        this.frx = frx;
        this.dateAdded = dateAdded.getTime();
        this.setRevision(fr);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public FileRevisionExtraInfo getFrx() {
        return this.frx;
    }

    public void setFrx(FileRevisionExtraInfo frx) {
        this.frx = frx;
    }

    public void setRevision(CrucibleRevision crucibleRevision) {
        this.revision = crucibleRevision;
    }

    public CrucibleRevision getRevision() {
        return this.revision;
    }

    public String getRevisionDisplayName() {
        return this.getRevision() == null ? null : this.getRevision().getRevisionDisplayName();
    }

    public boolean hasComments() {
        return this.inlineCommentRevisionDetails.size() > 0;
    }

    public boolean isAnyPostedComments() {
        for (InlineCommentRevisionDetail icrd : this.inlineCommentRevisionDetails) {
            InlineComment ic = icrd.getInlineComment();
            if (!FRXRevision.isCommentViewable(ic.getComment())) continue;
            return true;
        }
        return false;
    }

    public int getCommentCount() {
        Set<Comment> comments = this.getDistinctComments();
        int count = 0;
        for (Comment c2 : comments) {
            if (!FRXRevision.isCommentViewable(c2)) continue;
            ++count;
        }
        return count;
    }

    private Set<Comment> getDistinctComments() {
        HashSet<Comment> comments = new HashSet<Comment>();
        for (InlineCommentRevisionDetail icrd : this.inlineCommentRevisionDetails) {
            comments.add(icrd.getInlineComment().getComment());
        }
        HashSet<Comment> replies = new HashSet<Comment>();
        for (Comment c2 : comments) {
            replies.addAll(c2.getComments());
        }
        comments.addAll(replies);
        return comments;
    }

    private static boolean isCommentViewable(Comment c2) {
        return !c2.isDeleted() && !c2.isDraft();
    }

    public void addInlineComment(InlineCommentRevisionDetail inlineComment) {
        this.inlineCommentRevisionDetails.add(inlineComment);
    }

    public void removeInlineComment(InlineCommentRevisionDetail inlineComment) {
        inlineComment.getInlineComment().setFrx(null);
        inlineComment.setFrxRevision(null);
        this.inlineCommentRevisionDetails.remove(inlineComment);
    }

    public Date getDateAdded() {
        return new Date(this.dateAdded);
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded.getTime();
    }

    public Long getDateTimeAdded() {
        return this.dateAdded;
    }

    public void setDateTimeAdded(Long dateAdded) {
        this.dateAdded = dateAdded;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof FRXRevision)) {
            return false;
        }
        Integer oid = ((FRXRevision)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id.hashCode();
    }

    public String toString() {
        return "FRXRevision{, id=" + this.id + ", order=" + this.order + ", revision=" + this.revision + '}';
    }

    public Set<InlineCommentRevisionDetail> getInlineCommentRevisionDetails() {
        return this.inlineCommentRevisionDetails;
    }

    public void setInlineCommentRevisionDetails(Set<InlineCommentRevisionDetail> inlineCommentRevisionDetails) {
        this.inlineCommentRevisionDetails = inlineCommentRevisionDetails;
    }

    public int getReadInlineCommentCount(FecruUser user) {
        int count = 0;
        Set<Comment> comments = this.getDistinctComments();
        for (Comment comment : comments) {
            if (!FRXRevision.isCommentViewable(comment) || !comment.isRead(user)) continue;
            ++count;
        }
        return count;
    }

    public int getLinesChanged() {
        int linesChanged = 1;
        String linesAddedDetail = this.getRevision().getDetail("linesAdded");
        String linesRemovedDetail = this.getRevision().getDetail("linesRemoved");
        if (!Strings.isNullOrEmpty((String)linesAddedDetail) && !Strings.isNullOrEmpty((String)linesRemovedDetail)) {
            try {
                int linesAdded = Integer.parseInt(linesAddedDetail);
                int linesRemoved = Integer.parseInt(linesRemovedDetail);
                linesChanged = linesAdded + linesRemoved;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return linesChanged;
    }
}

