/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import java.util.Date;

public class CustomField {
    private Integer id;
    private Integer configVersion;
    private String fieldScope = "";
    private String name;
    private Object value;
    private int type = -1;
    private FieldDefinition fd;

    public CustomField() {
    }

    public CustomField(Object value) {
        this.setValue(value);
    }

    public CustomField(CustomField field) {
        this.setConfigVersion(field.getConfigVersion());
        this.setValue(field.getValue());
        this.setName(field.getName());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(Integer configVersion) {
        this.configVersion = configVersion;
    }

    public String getFieldScope() {
        return this.fieldScope;
    }

    public void setFieldScope(String fieldScope) {
        this.fieldScope = fieldScope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSet() {
        return this.type != -1;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) throws ClassCastException {
        this.value = value;
        if (value == null) {
            this.type = -1;
            return;
        }
        if (value instanceof String) {
            this.type = 0;
            return;
        }
        if (value instanceof Integer) {
            this.type = 1;
            return;
        }
        if (value instanceof Boolean) {
            this.type = 2;
            return;
        }
        if (value instanceof Date) {
            this.type = 3;
            return;
        }
        this.value = null;
        throw new ClassCastException("Unsupported Field type");
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        switch (this.type) {
            case 0: {
                return "String";
            }
            case 1: {
                return "Integer";
            }
            case 2: {
                return "Boolean";
            }
            case 3: {
                return "Date";
            }
        }
        return "Not Set";
    }

    public String getStringVal() {
        if (this.type == 0) {
            return (String)this.value;
        }
        return null;
    }

    public void setStringVal(String stringVal) {
        if (stringVal != null) {
            this.value = stringVal;
            this.type = 0;
        }
    }

    public boolean isString() {
        return this.type == 0;
    }

    public Integer getIntVal() {
        if (this.type == 1) {
            return (Integer)this.value;
        }
        return null;
    }

    public void setIntVal(Integer intVal) {
        if (intVal != null) {
            this.value = intVal;
            this.type = 1;
        }
    }

    public boolean isInteger() {
        return this.type == 1;
    }

    public Boolean getBooleanVal() {
        if (this.type == 2) {
            return (Boolean)this.value;
        }
        return null;
    }

    public void setBooleanVal(Boolean booleanVal) {
        if (booleanVal != null) {
            this.value = booleanVal;
            this.type = 2;
        }
    }

    public boolean isBoolean() {
        return this.type == 2;
    }

    public Date getDateVal() {
        if (this.type == 3) {
            return (Date)this.value;
        }
        return null;
    }

    public Long getDateTimeVal() {
        return this.getDateVal() == null ? null : Long.valueOf(this.getDateVal().getTime());
    }

    public void setDateVal(Date dateVal) {
        if (dateVal != null) {
            this.value = dateVal;
            this.type = 3;
        }
    }

    public void setDateTimeVal(Long dateVal) {
        this.setDateVal(dateVal == null ? null : new Date(dateVal));
    }

    public boolean isDate() {
        return this.type == 3;
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        FieldDefinition fd = this.getFieldDefinition();
        String valName = fd.getValueName(this.value);
        if (valName != null) {
            return valName + " (" + this.value.toString() + ")";
        }
        return this.value.toString();
    }

    public String getHrValue() {
        if (this.value == null) {
            return "not set";
        }
        FieldDefinition fd = this.getFieldDefinition();
        String valName = fd.getValueName(this.value);
        if (valName != null) {
            return valName;
        }
        return this.value.toString();
    }

    public String getLabel() {
        return this.getFieldDefinition().getLabel();
    }

    public FieldDefinition getFieldDefinition() {
        if (this.fd == null) {
            MetricsConfig mc = MetricsManager.INSTANCE.getConfig(this.getConfigVersion());
            this.fd = mc.getField(this.getFieldScope(), this.getName());
        }
        return this.fd;
    }
}

