/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.util.concurrent.LazyReference;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUser;
import com.cenqua.crucible.model.ModelUtils;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import java.lang.ref.Reference;

@Deprecated
public final class CrucibleUser
implements LegacyUser {
    private Integer id;
    private String username;
    private Reference<FEUser> feUser = new FeUserLazyReference();
    private boolean dontSendMeMyNotifications = true;
    private int stateChangeEmailNotification = DeliverySchedule.IMMEDIATE;
    private int commentEmailNotification = DeliverySchedule.IMMEDIATE;
    private int replyEmailNotification = DeliverySchedule.IMMEDIATE;
    private int generalEmailNotification = DeliverySchedule.IMMEDIATE;
    private int completeEmailNotification = DeliverySchedule.IMMEDIATE;
    private int autoUncompleteEmailNotification = DeliverySchedule.BATCH;
    private boolean uncompleteOnDefect = true;
    private boolean uncompleteOnRevisionAdded = true;

    CrucibleUser() {
    }

    public CrucibleUser(String username) {
        this.setUsername(username);
    }

    public CrucibleUser(Integer id, String username) {
        this(username);
        this.setId(id);
    }

    @Deprecated
    public FEUser getFEUser() {
        return this.feUser != null ? this.feUser.get() : null;
    }

    public void setFEUser(final FEUser feUser) {
        this.setFEUserRef((Reference<FEUser>)new LazyReference<FEUser>(){

            public FEUser create() {
                return feUser;
            }
        });
    }

    public void setFEUserRef(Reference<FEUser> feUser) {
        this.feUser = feUser;
    }

    private boolean hasFEUser() {
        return this.getFEUser() != null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    private void setUsername(String username) {
        ModelUtils.ensureNotNullOrEmpty("User names", username);
        this.username = username;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        if (this.hasFEUser()) {
            return this.getFEUser().getDisplayName();
        }
        return this.username;
    }

    @Override
    public String getEmail() {
        if (this.hasFEUser()) {
            return this.getFEUser().getEmail();
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.hasFEUser();
    }

    public int getAutoUncompleteEmailNotification() {
        return this.autoUncompleteEmailNotification;
    }

    public void setAutoUncompleteEmailNotification(int autoUncompleteEmailNotification) {
        this.autoUncompleteEmailNotification = autoUncompleteEmailNotification;
    }

    public boolean getUncompleteOnDefect() {
        return this.uncompleteOnDefect;
    }

    public void setUncompleteOnDefect(boolean uncompleteOnDefect) {
        this.uncompleteOnDefect = uncompleteOnDefect;
    }

    public boolean getUncompleteOnRevisionAdded() {
        return this.uncompleteOnRevisionAdded;
    }

    public void setUncompleteOnRevisionAdded(boolean uncompleteOnRevisionAdded) {
        this.uncompleteOnRevisionAdded = uncompleteOnRevisionAdded;
    }

    public boolean getDontSendMeMyNotifications() {
        return this.dontSendMeMyNotifications;
    }

    public void setDontSendMeMyNotifications(boolean dontSendMeMyNotifications) {
        this.dontSendMeMyNotifications = dontSendMeMyNotifications;
    }

    public int getStateChangeEmailNotification() {
        return this.stateChangeEmailNotification;
    }

    public void setStateChangeEmailNotification(int stateChangeEmailNotification) {
        this.stateChangeEmailNotification = stateChangeEmailNotification;
    }

    public int getCommentEmailNotification() {
        return this.commentEmailNotification;
    }

    public void setCommentEmailNotification(int commentEmailNotification) {
        this.commentEmailNotification = commentEmailNotification;
    }

    public int getReplyEmailNotification() {
        return this.replyEmailNotification;
    }

    public void setReplyEmailNotification(int replyEmailNotification) {
        this.replyEmailNotification = replyEmailNotification;
    }

    public int getGeneralEmailNotification() {
        return this.generalEmailNotification;
    }

    public void setGeneralEmailNotification(int generalEmailNotification) {
        this.generalEmailNotification = generalEmailNotification;
    }

    public int getCompleteEmailNotification() {
        return this.completeEmailNotification;
    }

    public void setCompleteEmailNotification(int completeEmailNotification) {
        this.completeEmailNotification = completeEmailNotification;
    }

    @Override
    public String getGravatarHash() {
        if (this.hasFEUser()) {
            return this.getFEUser().getGravatarHash();
        }
        return null;
    }

    @Override
    public String getPasswordHash() {
        if (this.hasFEUser()) {
            return this.getFEUser().getPasswordHash();
        }
        return null;
    }

    @Override
    public LegacyUser.AuthType getAuthType() {
        if (this.hasFEUser()) {
            return this.getFEUser().getAuthType();
        }
        return null;
    }

    @Override
    public boolean isCrucibleEnabled() {
        return this.hasFEUser() && this.getFEUser().isCrucibleEnabled();
    }

    @Override
    public String getPasswordResetSRnd() {
        if (this.hasFEUser()) {
            return this.getFEUser().getPasswordResetSRnd();
        }
        return null;
    }

    @Override
    public long getPasswordResetTimeStamp() {
        if (this.hasFEUser()) {
            return this.getFEUser().getPasswordResetTimeStamp();
        }
        return 0L;
    }

    @Override
    public long getFailedLoginAttempts() {
        if (this.hasFEUser()) {
            return this.getFEUser().getFailedLoginAttempts();
        }
        return 0L;
    }

    @Override
    public boolean hasExceededMaxFailedLoginAttempts() {
        if (this.hasFEUser()) {
            return this.getFEUser().hasExceededMaxFailedLoginAttempts();
        }
        return true;
    }

    @Override
    public void setEmail(String email) {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot set email on inactive user");
        }
        this.getFEUser().setEmail(email);
    }

    @Override
    public void setDisplayName(String displayName) {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot set displayName on inactive user");
        }
        this.getFEUser().setDisplayName(displayName);
    }

    @Override
    public void setPasswordHash(String passwordHash) {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot set passwordHash on inactive user");
        }
        this.getFEUser().setPasswordHash(passwordHash);
    }

    @Override
    public void setAuthType(LegacyUser.AuthType authType) {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot set authType on inactive user");
        }
        this.getFEUser().setAuthType(authType);
    }

    @Override
    public void setCrucibleEnabled(boolean crucibleEnabled) {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot set crucibleEnabled on inactive user");
        }
        this.getFEUser().setCrucibleEnabled(crucibleEnabled);
    }

    @Override
    public void setPasswordResetSRnd(String passwordResetSRnd) {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot set passwordResetSRnd on inactive user");
        }
        this.getFEUser().setPasswordResetSRnd(passwordResetSRnd);
    }

    @Override
    public void setPasswordResetTimeStamp(long passwordResetTimeStamp) {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot set passwordResetTimeStamp on inactive user");
        }
        this.getFEUser().setPasswordResetTimeStamp(passwordResetTimeStamp);
    }

    @Override
    public void setFailedLoginAttempts(long failedLoginAttempts) {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot set failedLoginAttempts on inactive user");
        }
        this.getFEUser().setFailedLoginAttempts(failedLoginAttempts);
    }

    @Override
    public long incrementAndGetFailedLoginAttempts() {
        if (!this.hasFEUser()) {
            throw new IllegalStateException("Cannot increment failedLoginAttempts on inactive user");
        }
        return this.getFEUser().incrementAndGetFailedLoginAttempts();
    }

    public LegacyUser getUser() {
        return this;
    }

    public String toString() {
        return this.getId() + ": " + this.getUsername();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CrucibleUser)) {
            return false;
        }
        CrucibleUser other = (CrucibleUser)obj;
        return this.getUsername().equals(other.getUsername());
    }

    public int hashCode() {
        return this.getUsername().hashCode();
    }

    @Override
    public int compareTo(LegacyUser other) {
        return USERNAME_COMPARATOR.compare(this, other);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CrucibleUser user) {
        return new Builder(user);
    }

    class FeUserLazyReference
    extends LazyReference<FEUser> {
        FeUserLazyReference() {
        }

        protected FEUser create() throws Exception {
            if (CrucibleUser.this.username == null) {
                return null;
            }
            if (CrucibleUser.this.id == null) {
                return new FEUser(CrucibleUser.this.username);
            }
            try {
                throw new UnsupportedOperationException();
            }
            catch (DbException e2) {
                Logs.APP_LOG.debug((Object)("Could not retrieve feUser for username" + CrucibleUser.this.username), (Throwable)e2);
                return null;
            }
        }
    }

    public static class Builder {
        private Integer id;
        private String username;
        private FEUser feUser = new FEUser();
        private boolean dontSendMeMyNotifications = true;
        private int stateChangeEmailNotification = DeliverySchedule.IMMEDIATE;
        private int commentEmailNotification = DeliverySchedule.IMMEDIATE;
        private int replyEmailNotification = DeliverySchedule.IMMEDIATE;
        private int generalEmailNotification = DeliverySchedule.IMMEDIATE;
        private int completeEmailNotification = DeliverySchedule.IMMEDIATE;
        private int autoUncompleteEmailNotification = DeliverySchedule.BATCH;
        private boolean uncompleteOnDefect = true;
        private boolean uncompleteOnRevisionAdded = true;

        public Builder() {
        }

        public Builder(CrucibleUser user) {
            FEUser feUser = user.getFEUser();
            this.feUser = feUser != null ? feUser.clone() : new FEUser();
            this.setId(user.getId());
            this.setUsername(user.getUsername());
        }

        public Builder setId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            this.feUser.setUsername(username);
            return this;
        }

        public Builder setEmail(String email) {
            this.feUser.setEmail(email);
            return this;
        }

        public Builder setPasswordHash(String passwordHash) {
            this.feUser.setPasswordHash(passwordHash);
            return this;
        }

        public Builder setCrucibleEnabled(boolean crucibleEnabled) {
            this.feUser.setCrucibleEnabled(crucibleEnabled);
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.feUser.setDisplayName(displayName);
            return this;
        }

        public Builder setDontSendMeMyNotifications(boolean dontSendMeMyNotifications) {
            this.dontSendMeMyNotifications = dontSendMeMyNotifications;
            return this;
        }

        public Builder setStateChangeEmailNotification(int stateChangeEmailNotification) {
            this.stateChangeEmailNotification = stateChangeEmailNotification;
            return this;
        }

        public Builder setCommentEmailNotification(int commentEmailNotification) {
            this.commentEmailNotification = commentEmailNotification;
            return this;
        }

        public Builder setReplyEmailNotification(int replyEmailNotification) {
            this.replyEmailNotification = replyEmailNotification;
            return this;
        }

        public Builder setGeneralEmailNotification(int generalEmailNotification) {
            this.generalEmailNotification = generalEmailNotification;
            return this;
        }

        public Builder setCompleteEmailNotification(int completeEmailNotification) {
            this.completeEmailNotification = completeEmailNotification;
            return this;
        }

        public Builder setAutoUncompleteEmailNotification(int autoUncompleteEmailNotification) {
            this.autoUncompleteEmailNotification = autoUncompleteEmailNotification;
            return this;
        }

        public Builder setUncompleteOnDefect(boolean uncompleteOnDefect) {
            this.uncompleteOnDefect = uncompleteOnDefect;
            return this;
        }

        public Builder setUncompleteOnRevisionAdded(boolean uncompleteOnRevisionAdded) {
            this.uncompleteOnRevisionAdded = uncompleteOnRevisionAdded;
            return this;
        }

        public CrucibleUser build() {
            CrucibleUser user = new CrucibleUser(this.id, this.username);
            user.setFEUser(this.feUser);
            user.setAutoUncompleteEmailNotification(this.autoUncompleteEmailNotification);
            user.setCommentEmailNotification(this.commentEmailNotification);
            user.setCompleteEmailNotification(this.completeEmailNotification);
            user.setDontSendMeMyNotifications(this.dontSendMeMyNotifications);
            user.setGeneralEmailNotification(this.generalEmailNotification);
            user.setReplyEmailNotification(this.replyEmailNotification);
            user.setStateChangeEmailNotification(this.stateChangeEmailNotification);
            user.setUncompleteOnDefect(this.uncompleteOnDefect);
            user.setUncompleteOnRevisionAdded(this.uncompleteOnRevisionAdded);
            return user;
        }
    }
}

