/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.model.ModelUtils;
import com.cenqua.crucible.model.StoredPath;
import com.cenqua.crucible.revision.managers.DefaultContentManager;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;

public class CrucibleRevision {
    private Integer id;
    private String source;
    private StoredPath storedPath;
    private String revisionDisplayName;
    private String revision;
    private Long commitDate;
    private String authorName;
    private String fileType;
    private Boolean deletion = false;
    private Map<String, String> otherDetails = new HashMap<String, String>();
    private Long createDate;
    private UploadItem uploadItem = null;
    private Boolean binary;
    private Boolean added;
    private Boolean modified;
    private Boolean moved;
    private Boolean copied;
    private Boolean oversize;
    private Integer detailVersion;

    @VisibleForTesting
    public CrucibleRevision() {
        this.setCreateDate(new Date());
    }

    public CrucibleRevision(String source, StoredPath path, String revision, String revisionDisplayName, Date createDate) {
        this.setSourceName(source);
        this.setStoredPath(path);
        this.setRevisionDisplayName(revisionDisplayName);
        this.setRevision(revision);
        this.setCreateDate(createDate);
    }

    public RevInfoKey getRevInfoKey() {
        return new RevInfoKey(this.getFePath(), this.getRevision());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Long getCreateDateTime() {
        return this.createDate;
    }

    public void setCreateDateTime(Long createDate) {
        this.createDate = createDate;
    }

    public Date getCreateDate() {
        return new Date(this.createDate);
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate.getTime();
    }

    public String getRevisionDisplayName() {
        return this.revisionDisplayName;
    }

    public void setRevisionDisplayName(String revision) {
        ModelUtils.ensureNotNullOrEmpty("revision display name", revision);
        this.revisionDisplayName = revision;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        ModelUtils.ensureNotNullOrEmpty("revision", revision);
        this.revision = revision;
    }

    public String getSourceName() {
        return this.source.trim();
    }

    public void setSourceName(String source) {
        ModelUtils.ensureNotNullOrEmpty("source name", source);
        this.source = source;
    }

    public boolean isStored() {
        return this.uploadItem != null;
    }

    public String getPath() {
        return this.storedPath == null || this.storedPath.getPath() == null ? "" : this.storedPath.getPath();
    }

    public StoredPath getStoredPath() {
        return this.storedPath;
    }

    public void setStoredPath(StoredPath storedPath) {
        this.storedPath = storedPath;
    }

    public Path getFePath() {
        return new Path(this.storedPath.getPath());
    }

    public String getFileName() {
        return this.getFePath().getName();
    }

    public Long getCommitDateTime() {
        return this.commitDate;
    }

    public void setCommitDateTime(Long commitDate) {
        this.commitDate = commitDate;
    }

    public Date getCommitDate() {
        return this.commitDate == null ? null : new Date(this.commitDate);
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate.getTime();
    }

    public String getCommitMessage() {
        return this.getDetail("comment");
    }

    public String getBranch() {
        return this.getDetail("branch");
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public Boolean isDeletion() {
        return this.deletion;
    }

    public void setDeletion(Boolean deletion) {
        this.deletion = deletion;
    }

    public Map<String, String> getDetails() {
        return new DetailsMap();
    }

    public String getDetail(String detail) {
        return this.getDetails().get(detail);
    }

    public boolean isDetailSetTrue(String detail) {
        String value = this.getDetail(detail);
        return value != null && Boolean.valueOf(value) != false;
    }

    @Deprecated
    private Map<String, String> getOtherDetails() {
        return this.otherDetails;
    }

    @Deprecated
    private void setOtherDetails(Map<String, String> details) {
        this.otherDetails = details;
    }

    public UploadItem getUploadItem() {
        return this.uploadItem;
    }

    public void setUploadItem(UploadItem uploadItem) {
        this.uploadItem = uploadItem;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o2 == null || !(o2 instanceof CrucibleRevision)) {
            return false;
        }
        Integer oid = ((CrucibleRevision)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id.hashCode();
    }

    public String toString() {
        return this.getPath() + " : " + this.getRevision() + "(" + (this.id != null ? this.id : System.identityHashCode(this)) + ")";
    }

    public Boolean isBinary() {
        return this.binary;
    }

    public void setBinary(Boolean binary) {
        this.binary = binary;
    }

    public Boolean isOversize() {
        return this.oversize;
    }

    public void setOversize(Boolean oversize) {
        this.oversize = oversize;
    }

    public Boolean isAdded() {
        return this.added;
    }

    public void setAdded(Boolean added) {
        this.added = added;
    }

    public Boolean isModified() {
        return this.modified;
    }

    public void setModified(Boolean modified) {
        this.modified = modified;
    }

    public Boolean isMoved() {
        return this.moved;
    }

    public void setMoved(Boolean moved) {
        this.moved = moved;
    }

    public Boolean isCopied() {
        return this.copied;
    }

    public void setCopied(Boolean copied) {
        this.copied = copied;
    }

    public Integer getDetailVersion() {
        return this.detailVersion;
    }

    public void setDetailVersion(Integer detailVersion) {
        this.detailVersion = detailVersion;
    }

    public void setSnippetSyntax(String syntax) {
        if (syntax != null) {
            this.getDetails().put("snippetSyntax", syntax);
        }
    }

    public String getSnippetSyntax() {
        String synhi = this.getDetails().get("snippetSyntax");
        if (synhi == null) {
            synhi = new Path(this.getFileName()).getExtension();
        }
        if (synhi == null) {
            return "txt";
        }
        return synhi;
    }

    public boolean isMetadataOnlyChange() {
        if (!(!CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES || !Boolean.TRUE.equals(this.isModified()) || Boolean.TRUE.equals(this.isAdded()) || Boolean.TRUE.equals(this.isDeletion()) || Boolean.TRUE.equals(this.isBinary()) || Boolean.TRUE.equals(this.isOversize()) || Boolean.TRUE.equals(this.isCopied()))) {
            Integer linesAdded = DefaultContentManager.getIntegerDetail(this, "linesAdded");
            Integer linesRemoved = DefaultContentManager.getIntegerDetail(this, "linesRemoved");
            return !(linesAdded != null && linesAdded != 0 || linesRemoved != null && linesRemoved != 0);
        }
        return false;
    }

    public boolean isBinaryOrOversize() {
        return this.binary != null && this.binary != false || this.oversize != null && this.oversize != false;
    }

    private class DetailsMap
    extends AbstractMap<String, String> {
        private DetailsMap() {
        }

        @Override
        public final Set<Map.Entry<String, String>> entrySet() {
            return new AbstractSet<Map.Entry<String, String>>(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    UnmodifiableIterator commonFieldIterator = Iterators.filter((Iterator)Iterators.forArray((Object[])CommonDetailField.values()), (Predicate)Predicates.notNull());
                    return Iterators.concat((Iterator)new Iterator<Map.Entry<String, String>>((Iterator)commonFieldIterator){
                        private CommonDetailField currentField;
                        final /* synthetic */ Iterator val$commonFieldIterator;
                        {
                            this.val$commonFieldIterator = iterator;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.val$commonFieldIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<String, String> next() {
                            this.currentField = (CommonDetailField)((Object)this.val$commonFieldIterator.next());
                            return this.currentField.getEntry(CrucibleRevision.this);
                        }

                        @Override
                        public void remove() {
                            this.currentField.remove(CrucibleRevision.this);
                        }
                    }, CrucibleRevision.this.otherDetails.entrySet().iterator());
                }

                @Override
                public int size() {
                    int size = CrucibleRevision.this.otherDetails.size();
                    for (CommonDetailField field : CommonDetailField.values()) {
                        if (!field.has(CrucibleRevision.this)) continue;
                        ++size;
                    }
                    return size;
                }
            };
        }

        @Override
        public final String put(String key, String value) {
            CommonDetailField field = CommonDetailField.withName(key);
            if (field == null) {
                if (StringUtils.isEmpty((String)value)) {
                    return (String)CrucibleRevision.this.otherDetails.remove(key);
                }
                return CrucibleRevision.this.otherDetails.put(key, value);
            }
            String oldValue = field.get(CrucibleRevision.this);
            field.put(CrucibleRevision.this, value);
            return oldValue;
        }

        @Override
        public final String get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            String keyString = (String)key;
            CommonDetailField field = CommonDetailField.withName(keyString);
            if (field == null) {
                return (String)CrucibleRevision.this.otherDetails.get(keyString);
            }
            return field.get(CrucibleRevision.this);
        }
    }

    private static enum CommonDetailField {
        BINARY("binary"){

            @Override
            String get(CrucibleRevision crucibleRevision) {
                return CommonDetailField.stringFromBoolean(crucibleRevision.binary);
            }

            @Override
            boolean has(CrucibleRevision crucibleRevision) {
                return crucibleRevision.binary != null;
            }

            @Override
            void put(CrucibleRevision crucibleRevision, String value) {
                crucibleRevision.binary = CommonDetailField.booleanFromString(value);
            }

            @Override
            void remove(CrucibleRevision crucibleRevision) {
                crucibleRevision.binary = null;
            }
        }
        ,
        ADDED("added"){

            @Override
            String get(CrucibleRevision crucibleRevision) {
                return CommonDetailField.stringFromBoolean(crucibleRevision.added);
            }

            @Override
            boolean has(CrucibleRevision crucibleRevision) {
                return crucibleRevision.added != null;
            }

            @Override
            void put(CrucibleRevision crucibleRevision, String value) {
                crucibleRevision.added = CommonDetailField.booleanFromString(value);
            }

            @Override
            void remove(CrucibleRevision crucibleRevision) {
                crucibleRevision.added = null;
            }
        }
        ,
        MODIFIED("modified"){

            @Override
            String get(CrucibleRevision crucibleRevision) {
                return CommonDetailField.stringFromBoolean(crucibleRevision.modified);
            }

            @Override
            boolean has(CrucibleRevision crucibleRevision) {
                return crucibleRevision.modified != null;
            }

            @Override
            void put(CrucibleRevision crucibleRevision, String value) {
                crucibleRevision.modified = CommonDetailField.booleanFromString(value);
            }

            @Override
            void remove(CrucibleRevision crucibleRevision) {
                crucibleRevision.modified = null;
            }
        }
        ,
        MOVED("moved"){

            @Override
            String get(CrucibleRevision crucibleRevision) {
                return CommonDetailField.stringFromBoolean(crucibleRevision.moved);
            }

            @Override
            boolean has(CrucibleRevision crucibleRevision) {
                return crucibleRevision.moved != null;
            }

            @Override
            void put(CrucibleRevision crucibleRevision, String value) {
                crucibleRevision.moved = CommonDetailField.booleanFromString(value);
            }

            @Override
            void remove(CrucibleRevision crucibleRevision) {
                crucibleRevision.moved = null;
            }
        }
        ,
        COPIED("copied"){

            @Override
            String get(CrucibleRevision crucibleRevision) {
                return CommonDetailField.stringFromBoolean(crucibleRevision.copied);
            }

            @Override
            boolean has(CrucibleRevision crucibleRevision) {
                return crucibleRevision.copied != null;
            }

            @Override
            void put(CrucibleRevision crucibleRevision, String value) {
                crucibleRevision.copied = CommonDetailField.booleanFromString(value);
            }

            @Override
            void remove(CrucibleRevision crucibleRevision) {
                crucibleRevision.copied = null;
            }
        }
        ,
        OVERSIZE("oversize"){

            @Override
            String get(CrucibleRevision crucibleRevision) {
                return CommonDetailField.stringFromBoolean(crucibleRevision.oversize);
            }

            @Override
            boolean has(CrucibleRevision crucibleRevision) {
                return crucibleRevision.oversize != null;
            }

            @Override
            void put(CrucibleRevision crucibleRevision, String value) {
                crucibleRevision.oversize = CommonDetailField.booleanFromString(value);
            }

            @Override
            void remove(CrucibleRevision crucibleRevision) {
                crucibleRevision.oversize = null;
            }
        };

        private static final ConcurrentMap<String, CommonDetailField> nameMap;
        private final String key;

        private static CommonDetailField withName(String name) {
            return (CommonDetailField)((Object)nameMap.get(name));
        }

        private static Boolean booleanFromString(String value) {
            return value == null ? null : Boolean.valueOf(value);
        }

        private static String stringFromBoolean(Boolean value) {
            return value == null ? null : String.valueOf(value);
        }

        private CommonDetailField(String key) {
            this.key = key;
        }

        public Map.Entry<String, String> getEntry(final CrucibleRevision crucibleRevision) {
            return new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public String getValue() {
                    return this.get(crucibleRevision);
                }

                @Override
                public String setValue(String value) {
                    String oldValue = this.getValue();
                    this.put(crucibleRevision, value);
                    return oldValue;
                }
            };
        }

        abstract String get(CrucibleRevision var1);

        abstract boolean has(CrucibleRevision var1);

        abstract void put(CrucibleRevision var1, String var2);

        abstract void remove(CrucibleRevision var1);

        static {
            nameMap = new ConcurrentHashMap<String, CommonDetailField>(CommonDetailField.values().length);
            for (CommonDetailField field : CommonDetailField.values()) {
                nameMap.put(field.key, field);
            }
        }
    }
}

