/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentList;
import com.cenqua.crucible.model.CommentVisitor;
import com.cenqua.crucible.model.CommentVisitorContext;
import com.cenqua.crucible.model.CommentVisitorContextImpl;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.util.CommentComparators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommentListImpl
implements CommentList {
    private Set<Comment> comments = new HashSet<Comment>();

    @Override
    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    @Override
    public Set<Comment> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(Set<Comment> comments) {
        this.comments = comments;
    }

    public List<Comment> getCommentAndReplies() {
        final ArrayList<Comment> commentsAndReplies = new ArrayList<Comment>();
        this.visit(new CommentVisitor(){

            @Override
            public void visit(CommentVisitorContext ctx) {
                commentsAndReplies.add(ctx.getComment());
                ctx.proceed();
            }
        });
        return commentsAndReplies;
    }

    @Override
    public void visit(CommentVisitor visitor) {
        this.visitChildren(visitor, new CommentVisitorContextImpl(visitor));
    }

    void visitChildren(CommentVisitor visitor, CommentVisitorContextImpl ctx) {
        ArrayList<Comment> sorted = new ArrayList<Comment>(this.comments);
        Collections.sort(sorted, CommentComparators.oldestFirst);
        for (Comment c2 : sorted) {
            ctx.setComment(c2);
            c2.visit(visitor, ctx);
        }
    }

    @Override
    public boolean removeComment(Comment comment) {
        comment.clearFields();
        return this.comments.remove(comment);
    }

    @Override
    public void cleanUpComments() {
        this.cleanUpComments(null);
    }

    @Override
    public void cleanUpComments(FecruUser user) {
        this.deleteComments(user, false);
    }

    @Override
    public void deleteAllComments() {
        this.deleteComments(null, true);
    }

    @Override
    public void deleteComments(FecruUser user, boolean deleteAll) {
        HashSet<Comment> removeThese = new HashSet<Comment>();
        for (Comment comment : this.comments) {
            comment.deleteComments(user, deleteAll);
            if (user != null && !comment.getUser().equals(user) || !deleteAll && !comment.isDeleted() && !comment.isDraft()) continue;
            removeThese.add(comment);
        }
        for (Comment comment : removeThese) {
            Review review = comment.getReview();
            this.removeComment(comment);
            DefaultCommentManager.getInstance().deleteCommentAndAnnounce(comment, review);
        }
    }
}

