/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.CommentList;
import com.cenqua.crucible.model.CommentReadStatus;
import com.cenqua.crucible.model.CommentVisitor;
import com.cenqua.crucible.model.CommentVisitorContextImpl;
import com.cenqua.crucible.model.CommonListMixin;
import com.cenqua.crucible.model.CustomFieldList;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Comment
extends CommonListMixin
implements CommentList,
CustomFieldList {
    private static final int DISPLAY_TRUNCATE_LENGTH = 47;
    public static final String PERMAID_PREFIX = "CMT:";
    private String message = null;
    private boolean draft = false;
    private boolean deleted = false;
    private boolean defectRaised = false;
    private boolean defectApproved = false;
    private String jiraIssueKey;
    private FecruUser user = null;
    private Integer id;
    private Long createDate;
    private Long updatedDate;
    private Review review;
    private Comment replyToComment;
    private FRXComment frxComment;
    private InlineComment inlineComment;
    private Set<CommentReadStatus> commentReadStatus = new HashSet<CommentReadStatus>();
    private Integer reviewId;
    public static final Function<Comment, Integer> TO_ID = new Function<Comment, Integer>(){

        public Integer apply(Comment input) {
            return input.getId();
        }
    };

    public Integer getReviewId() {
        return this.reviewId;
    }

    protected void setReviewId(Integer reviewId) {
        this.reviewId = reviewId;
    }

    public Set<CommentReadStatus> getCommentReadStatus() {
        return this.commentReadStatus;
    }

    public void setCommentReadStatus(Set<CommentReadStatus> commentReadStatus) {
        this.commentReadStatus = commentReadStatus;
    }

    public Comment() {
        this.setCreateDate(new Date());
        this.setUpdatedDateTime(this.getCreateDateTime());
    }

    @Override
    public void addComment(Comment comment) {
        super.addComment(comment);
        comment.setReplyToComment(this);
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public String getPermaId() {
        return PERMAID_PREFIX + this.id;
    }

    public PermId<CommentData> getPermId() {
        return new PermId(this.getPermaId());
    }

    @Override
    public void visit(CommentVisitor visitor) {
        CommentVisitorContextImpl ctx = new CommentVisitorContextImpl(visitor);
        ctx.setComment(this);
        this.visit(visitor, ctx);
    }

    void visit(CommentVisitor visitor, CommentVisitorContextImpl ctx) {
        visitor.visit(ctx);
    }

    public Long getCreateDateTime() {
        return this.createDate;
    }

    public void setCreateDateTime(Long createDate) {
        this.createDate = createDate;
    }

    public Date getCreateDate() {
        return new Date(this.createDate);
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate.getTime();
    }

    public Long getUpdatedDateTime() {
        return this.updatedDate;
    }

    public void setUpdatedDateTime(Long updatedDate) {
        this.updatedDate = updatedDate;
    }

    public Date getUpdatedDate() {
        return new Date(this.updatedDate);
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate.getTime();
    }

    public String getMessage() {
        return this.message;
    }

    public String getTruncatedMessage() {
        return StringUtil.truncate(this.message, 47, true);
    }

    public void setMessage(String message) {
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Comment messages may not be null or empty");
        }
        this.message = message;
    }

    public boolean getDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isVisible(FecruUser user) {
        return !this.isDeleted() && (!this.isDraft() || this.getUser().equals(user));
    }

    public boolean isVisibleToAll() {
        return !this.isDeleted() && !this.isDraft();
    }

    public boolean getDefectRaised() {
        return this.defectRaised;
    }

    public void setDefectRaised(boolean defectRaised) {
        this.defectRaised = defectRaised;
    }

    public boolean isDefectRaised() {
        return this.defectRaised;
    }

    public boolean isDefectApproved() {
        return this.defectApproved;
    }

    public void setDefectApproved(boolean defectApproved) {
        this.defectApproved = defectApproved;
    }

    public String getJiraIssueKey() {
        return this.jiraIssueKey;
    }

    public void setJiraIssueKey(String jiraIssueKey) {
        this.jiraIssueKey = Strings.emptyToNull((String)jiraIssueKey);
    }

    public FecruUser getUser() {
        return this.user;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
        if (review != null) {
            this.setReviewId(review.getId());
        }
    }

    public Comment getReplyToComment() {
        return this.replyToComment;
    }

    public Comment getRootComment() {
        Comment parent = this.getReplyToComment();
        return parent == null ? this : parent.getRootComment();
    }

    public void setReplyToComment(Comment replyToComment) {
        this.replyToComment = replyToComment;
    }

    public boolean isReviewComment() {
        return this.getReview().getComments().contains(this.getRootComment());
    }

    public boolean isRevision() {
        return !this.isReply() && !this.isReviewComment();
    }

    public boolean isReply() {
        return this.getReplyToComment() != null;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (!(o2 instanceof Comment)) {
            return false;
        }
        Integer oid = ((Comment)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id;
    }

    @Override
    public Integer getMetricsVersion() {
        return this.getReview().getMetricsVersion();
    }

    public FRXComment getFrxComment() {
        if (this.frxComment == null) {
            this.frxComment = DefaultCommentManager.getInstance().findFrxComment(this);
        }
        return this.frxComment;
    }

    public InlineComment getInlineComment() {
        if (this.inlineComment == null) {
            this.inlineComment = DefaultCommentManager.getInstance().findInlineComment(this);
        }
        return this.inlineComment;
    }

    @Override
    public Map<String, FieldDefinition> getFieldDefinitions() {
        if (this.getMetricsVersion() != null) {
            return MetricsManager.INSTANCE.getConfig(this.getMetricsVersion()).getCommentFields();
        }
        return new HashMap<String, FieldDefinition>();
    }

    public boolean isNegative() {
        return this.isDefectRaised();
    }

    public boolean isPositive() {
        return !this.isNegative();
    }

    public String toString() {
        return super.toString() + "(" + this.getId() + ": " + this.getUser().getUsername() + ", " + this.getCreateDate() + (this.isDraft() ? ", Draft" : "") + (this.isDefectRaised() ? ", Defect" : "") + ", " + this.getMessage() + ")";
    }

    public CommentReadStatus getReadStatus(FecruUser user) {
        for (CommentReadStatus readStatus : this.getCommentReadStatus()) {
            if (!readStatus.getUser().equals(user)) continue;
            return readStatus;
        }
        return null;
    }

    public CommentReadStatus.Status getReadStatusValue(FecruUser user) {
        if (user == null) {
            return CommentReadStatus.Status.READ;
        }
        CommentReadStatus readStatus = this.getReadStatus(user);
        if (readStatus == null) {
            return CommentReadStatus.Status.UNREAD;
        }
        if (readStatus.isRead()) {
            return CommentReadStatus.Status.READ;
        }
        return CommentReadStatus.Status.LEAVE_UNREAD;
    }

    public boolean isRead(FecruUser user) {
        CommentReadStatus status = this.getReadStatus(user);
        return status != null && status.isRead();
    }

    public Type getType() {
        if (this.getFrxComment() != null) {
            return Type.FRX_COMMENT;
        }
        if (this.getInlineComment() != null) {
            return Type.INLINE_COMMENT;
        }
        Comment root = this.getRootComment();
        if (root != null) {
            if (root.getFrxComment() != null) {
                return Type.FRX_COMMENT;
            }
            if (root.getInlineComment() != null) {
                return Type.INLINE_COMMENT;
            }
        }
        return Type.GENERAL_COMMENT;
    }

    public static enum Type {
        GENERAL_COMMENT,
        FRX_COMMENT,
        INLINE_COMMENT;

    }
}

