/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.ModelUtils;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.crucible.model.managers.LogData;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.Date;
import javax.annotation.Nullable;

public abstract class AbstractLogItem
implements LogData {
    private String description;
    private long createDate;
    private Integer id;
    private Integer reviewId;
    private Integer userId;
    private String action;
    private Integer entityId;
    private Integer entityId2;
    private String entityString;
    private String oldValue;
    private String newValue;
    public static final Function<? super LogItem, ? extends Integer> TO_ID = new Function<LogItem, Integer>(){

        public Integer apply(@Nullable LogItem logItem) {
            return logItem != null ? logItem.getId() : null;
        }
    };

    public String getAction() {
        return this.action;
    }

    @Override
    public LogAction getLogAction() {
        return LogAction.getAction(this.getAction());
    }

    public void setAction(String action) {
        ModelUtils.ensureNotNullOrEmpty("Log item actions", action);
        this.action = action;
    }

    @Nullable
    public Integer getUserId() {
        return this.userId;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.getUserId() != null ? CrucibleUserManager.getUserById(this.getUserId()).getUsername() : null;
    }

    public void setUserId(@Nullable Integer userId) {
        this.userId = userId;
    }

    @Override
    public Integer getReviewId() {
        return this.reviewId;
    }

    public void setReviewId(Integer reviewId) {
        this.reviewId = reviewId;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getCreateDate() {
        return new Date(this.createDate);
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate.getTime();
    }

    @Override
    public long getCreateDateTime() {
        return this.createDate;
    }

    public void setCreateDateTime(long createDate) {
        this.createDate = createDate;
    }

    @Override
    public Integer getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    @Override
    public Integer getEntityId2() {
        return this.entityId2;
    }

    public void setEntityId2(Integer entityId2) {
        this.entityId2 = entityId2;
    }

    @Override
    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    @Override
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @Override
    public String getEntityString() {
        return this.entityString;
    }

    public void setEntityString(String entityString) {
        this.entityString = entityString;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("description", (Object)this.description).add("createDate", this.createDate).add("id", (Object)this.id).add("reviewId", (Object)this.reviewId).add("userId", (Object)this.userId).add("action", (Object)this.action).add("entityId", (Object)this.entityId).add("entityId2", (Object)this.entityId2).add("entityString", (Object)this.entityString).add("oldValue", (Object)this.oldValue).add("newValue", (Object)this.newValue).toString();
    }
}

