/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.iterative;

import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.config.SpringContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ReviewByCommentFinder {
    private final ReviewManager reviewManager;
    private final String commitMessage;
    private final Principal principal;

    public ReviewByCommentFinder(ReviewManager reviewManager, CrucibleChangeSet cs, Principal principal) {
        this(reviewManager, cs.getComment(), principal);
    }

    public ReviewByCommentFinder(ReviewManager reviewManager, String commitMessage, Principal principal) {
        this.reviewManager = reviewManager;
        this.commitMessage = commitMessage;
        this.principal = principal;
    }

    public List<Review> find() {
        List<State> openStates = Arrays.asList(StateManager.INSTANCE.getOpenStates());
        List<State> draftStates = Arrays.asList(StateManager.INSTANCE.getDraftStates());
        ArrayList<Review> reviews = new ArrayList<Review>();
        for (String id : this.extractReviewIds(this.commitMessage)) {
            Review review = this.reviewManager.getReviewByPermaId(id);
            if (review == null || !openStates.contains(review.getState()) && (!ReviewUtil.principalCanDoReviewAction(this.principal, null, UserActionManager.ACTION_MOD_FILES, review) || !draftStates.contains(review.getState()))) continue;
            reviews.add(review);
        }
        return reviews;
    }

    protected Set<String> extractReviewIds(String commitMsg) {
        ProjectManager projectManager = SpringContext.getComponentByClass(ProjectManager.class);
        List<String> codes = projectManager.getAllCurrentAndHistoricalProjectKeys();
        return this.extractReviewIds(commitMsg, codes);
    }

    protected Set<String> extractReviewIds(String commitMsg, List<String> projectKeys) {
        if (projectKeys == null || projectKeys.size() == 0 || commitMsg == null) {
            return Collections.EMPTY_SET;
        }
        StringBuilder buf = new StringBuilder();
        HashSet<String> ids = new HashSet<String>();
        String sep = "";
        for (String code : projectKeys) {
            buf.append(sep).append(Pattern.quote(code));
            sep = "|";
        }
        Matcher matcher = Pattern.compile("((" + buf.toString() + ")-\\d{1,9})").matcher(commitMsg);
        matcher.useTransparentBounds(true);
        matcher.useAnchoringBounds(false);
        while (matcher.find()) {
            ids.add(matcher.group(1));
        }
        return ids;
    }
}

