/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.iterative;

import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;

class ReviewByChangeSetFinder {
    private final List<CrucibleRevision> revs;
    private final Principal principal;
    private final Set<String> draftStateNames;
    private final Set<String> openStateNames;

    public ReviewByChangeSetFinder(CrucibleChangeSet cs, Principal principal) {
        this(cs.getRevisions(), principal);
    }

    public ReviewByChangeSetFinder(List<CrucibleRevision> revisions, Principal principal) {
        this.revs = revisions;
        this.principal = principal;
        this.openStateNames = new HashSet<String>(Arrays.asList(StateManager.INSTANCE.getOpenStateNames()));
        this.draftStateNames = new HashSet<String>(Arrays.asList(StateManager.INSTANCE.getDraftStateNames()));
    }

    public List<Review> find() {
        if (this.revs.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder openAndDraftStates = new StringBuilder();
        ArrayList<String> stateNames = new ArrayList<String>(this.openStateNames);
        stateNames.addAll(this.draftStateNames);
        String sep = "";
        for (String stateName : stateNames) {
            openAndDraftStates.append(sep);
            openAndDraftStates.append("'" + stateName + "'");
            sep = ",";
        }
        List<CrucibleRevision> revisions = this.revs.subList(0, Math.min(50, this.revs.size()));
        StringBuilder buf = new StringBuilder("select review from Review review where review.stateName in (" + openAndDraftStates.toString() + ") " + "and exists " + "(select 1 from review.frxs frxx " + "join frxx.frxRevisions frxRev " + "join frxRev.revision rev " + "where ( ");
        sep = "";
        for (int i2 = 0; i2 < revisions.size(); ++i2) {
            buf.append(sep).append(" (").append(" rev.spr.storedPath.path = :path" + i2).append(" and rev.spr.sourceName = :source" + i2).append(" )");
            sep = " or ";
        }
        buf.append("))");
        Query query = HibernateUtil.currentSession().createQuery(buf.toString());
        for (int i3 = 0; i3 < revisions.size(); ++i3) {
            query.setString("path" + i3, revisions.get(i3).getPath());
            query.setString("source" + i3, revisions.get(i3).getSourceName());
        }
        List result = query.list();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Review r2 = (Review)it.next();
            if (!this.draftStateNames.contains(r2.getStateName()) || ReviewUtil.principalCanDoReviewAction(this.principal, null, UserActionManager.ACTION_MOD_FILES, r2)) continue;
            it.remove();
        }
        return result;
    }
}

