/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.iterative;

import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.cenqua.crucible.iterative.IterativeReviewHelper;
import com.cenqua.crucible.iterative.ReviewByChangeSetFinder;
import com.cenqua.crucible.iterative.ReviewByCommentFinder;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DefaultIterativeReviewHelper
implements IterativeReviewHelper {
    @Override
    public List<Review> getReviewsByCommitMessage(CrucibleChangeSet cs, Principal principal) {
        return this.getReviewsByCommitMessage(cs.getComment(), principal);
    }

    @Override
    public List<Review> getReviewsByCommitMessage(String commitMessage, Principal principal) {
        ReviewByCommentFinder finder = new ReviewByCommentFinder(DefaultReviewManager.get(), commitMessage, principal);
        return finder.find();
    }

    @Override
    public List<Review> getReviewsByRevisions(CrucibleChangeSet cs, Principal principal) {
        return this.getReviewsByRevisions(cs.getRevisions(), principal);
    }

    @Override
    public List<Review> getReviewsByRevisions(List<CrucibleRevision> revisions, Principal principal) {
        ReviewByChangeSetFinder finder = new ReviewByChangeSetFinder(revisions, principal);
        return finder.find();
    }
}

