/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.interceptors;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ReviewInterceptor
implements Interceptor {
    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        String result = null;
        if (actionInvocation.getAction() instanceof ReviewBaseAction) {
            ReviewBaseAction action = (ReviewBaseAction)((Object)actionInvocation.getAction());
            Review review = action.getReview();
            if (review == null) {
                Map contextMap = actionInvocation.getInvocationContext().getContextMap();
                HttpServletRequest request = (HttpServletRequest)contextMap.get("com.opensymphony.xwork.dispatcher.HttpServletRequest");
                Logs.APP_LOG.warn((Object)("Unable to find requested review: " + request.getParameter("reviewid") + ", referer = " + request.getHeader("Referer") + ", request uri = [" + request.getRequestURI() + "]"));
                result = "nosuchreview";
            } else if (!ReviewUtil.canDoReviewAction(UserActionManager.ACTION_VIEW, review)) {
                result = Principal.Anonymous.isAnon((Principal)TotalityFilter.getCurrentPrincipal()) ? "loginRequired" : "nopermission";
            }
        }
        if (result == null) {
            result = actionInvocation.invoke();
        }
        return result;
    }
}

