/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.interceptors;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.fisheye.config.RootConfig;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import org.springframework.beans.factory.annotation.Autowired;

public class CruciblePermissionInterceptor
implements Interceptor {
    private final EffectiveUserProvider effectiveUserProvider;
    private final GlobalPermissionManager globalPermissionManager;
    private final RootConfig rootConfig;

    @Autowired
    public CruciblePermissionInterceptor(EffectiveUserProvider effectiveUserProvider, GlobalPermissionManager globalPermissionManager, RootConfig rootConfig) {
        this.effectiveUserProvider = effectiveUserProvider;
        this.globalPermissionManager = globalPermissionManager;
        this.rootConfig = rootConfig;
    }

    public CruciblePermissionInterceptor() {
        this(null, null, null);
    }

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        boolean anonOk = this.rootConfig.getConfig().getSecurity().getAllowCruAnon();
        FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        if (!anonOk) {
            if (user == null) {
                return "loginRequired";
            }
            if (!this.globalPermissionManager.hasPermission(user.getUsername(), GlobalPermissionType.CRUCIBLE_USER)) {
                return "notCruUser";
            }
        }
        return actionInvocation.invoke();
    }
}

