/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.user;

import com.cenqua.crucible.hibernate.upgrade.user.FEUserEAV;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.DB0Handle;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.googlecode.ehcache.annotations.TriggersRemove;
import java.util.List;
import java.util.Map;

@Deprecated
public final class LegacyUserManager {
    private final DB0Handle dbHandle;

    public LegacyUserManager(DB0Handle dbHandle) throws DbException {
        this.dbHandle = dbHandle;
        this.upgradeData();
    }

    private void upgradeData() throws DbException {
        this.updateCrucibleUserCount();
    }

    private void updateCrucibleUserCount() throws DbException {
        if (AppConfig.isCrucible()) {
            final LicenseInfo license = AppConfig.getsConfig().getLicense();
            if (license != null) {
                this.dbHandle.write(new DB0Handle.Writer<Void>(){

                    @Override
                    public Void write(InfinityDbHandle db) throws DbException {
                        FEUserEAV eav = new FEUserEAV(db);
                        int max = !license.getCrucibleLicense().isUnlimitedNumberOfUsers() ? license.getCrucibleLicense().getMaximumNumberOfUsers() : Integer.MAX_VALUE;
                        eav.updateInitialCrucibleUsers(max);
                        return null;
                    }
                });
            } else {
                Logs.APP_LOG.warn((Object)"No license info available, not updating Crucible user count.");
            }
        }
    }

    public List<String> getAllUsernames() throws DbException {
        return this.dbHandle.read(new DB0Handle.Reader<List<String>>(){

            @Override
            public List<String> read(InfinityDbHandle db) throws DbException {
                FEUserEAV eav = new FEUserEAV(db);
                return eav.listAllUserNames();
            }
        });
    }

    @Deprecated
    public Map<String, Map<String, String>> getAllLegacyAuthorMappings() throws DbException {
        return this.dbHandle.read(new DB0Handle.Reader<Map<String, Map<String, String>>>(){

            @Override
            public Map<String, Map<String, String>> read(InfinityDbHandle db) throws DbException {
                FEUserEAV eav = new FEUserEAV(db);
                return eav.listAllMappings();
            }
        });
    }

    @TriggersRemove(cacheName={"userCommitterMappings", "users"}, removeAll=true)
    public void deleteMapping(final String user) throws DbException {
        this.dbHandle.write(new DB0Handle.Writer<Void>(){

            @Override
            public Void write(InfinityDbHandle db) throws DbException {
                FEUserEAV eav = new FEUserEAV(db);
                eav.deleteAuthorMappings(user);
                return null;
            }
        });
    }
}

