/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.user;

import com.cenqua.crucible.hibernate.upgrade.LegacyUserProfileManager;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUser;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUserProfile;
import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.X;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

@Deprecated
public final class FEUserEAV {
    public static final I ENTITY = DB0EAV.FEUSER;
    public static final p A_EMAIL = new p(10L);
    public static final p A_PASSWORDHASH = new p(11L);
    public static final p A_AUTHTYPE = new p(12L);
    public static final p A_TIMEZONE = new p(13L);
    public static final p A_TABWIDTH = new p(14L);
    public static final p A_COOKIEPREFS = new p(15L);
    public static final p A_WATCHMODE = new p(16L);
    public static final p A_EMAILFORMAT = new p(17L);
    public static final p A_AUTHORMAPPING = new p(18L);
    public static final p A_CHANGESETSPERPAGE = new p(19L);
    public static final p A_MAXFILESPERCHANGESET = new p(20L);
    public static final p A_DISPLAYNAME = new p(21L);
    public static final p A_CRU_ENABLED = new p(22L);
    public static final p A_PASSWORDRESET_SRND = new p(23L);
    public static final p A_PASSWORDRESET_TIMESTAMP = new p(24L);
    public static final p A_IDECONNECTORPORT = new p(25L);
    public static final p A_ENABLEIDE = new p(26L);
    public static final p A_CONTEXT = new p(27L);
    public static final p A_UPLOAD_TYPE = new p(28L);
    public static final p A_UPLOAD_METHOD = new p(29L);
    public static final p A_UPLOAD_CHARSET = new p(30L);
    public static final p A_AUTO_MARK_FILES = new p(31L);
    public static final p A_GROUP = new p(40L);
    public static final p A_FAILEDLOGINCOUNT = new p(50L);
    public static final p IDX_EMAIL = new p(100L);
    public static final X INV_EMAIL = new X(DB0EAV.SCHEMA, ENTITY, A_EMAIL, DB0EAV.INDEX_EMAIL_TO_FEUSER, IDX_EMAIL);
    public static final X INV_EMAIL_SECONDARY = INV_EMAIL.b();
    public static final String CRU_USER_UPGRADE_ALREADY_PERFORMED = "crucible.user.upgrade.performed";
    private final InfinityDbHandle dbh;

    public FEUserEAV(InfinityDbHandle dbh) {
        this.dbh = dbh;
    }

    public boolean usernameExists(String username) throws DbException {
        y cu = y.a();
        try {
            cu.b(username);
            EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, cu);
            boolean bl = ecu.exists();
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public String getUsernameForEmail(String email) throws DbException {
        y val = y.a();
        y cu = y.a();
        cu.b(email);
        try {
            if (INV_EMAIL_SECONDARY.a(this.dbh.get(), cu, val)) {
                return val.m(0);
            }
            return null;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public FEUser load(String username) throws DbException {
        y cu = y.a();
        try {
            cu.b(username);
            EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, cu);
            if (!ecu.exists()) {
                FEUser fEUser = null;
                return fEUser;
            }
            FEUser user = new FEUser(username);
            user.setEmail(ecu.getString(A_EMAIL, null));
            user.setDisplayName(ecu.getString(A_DISPLAYNAME, null));
            user.setPasswordHash(ecu.getString(A_PASSWORDHASH, null));
            user.setAuthType(LegacyUser.AuthType.fromKey(ecu.getInt(A_AUTHTYPE, LegacyUser.AuthType.BUILTIN.getKey())));
            user.setCrucibleEnabled(ecu.getBoolean(A_CRU_ENABLED, false));
            user.setPasswordResetSRnd(ecu.getString(A_PASSWORDRESET_SRND, null));
            user.setPasswordResetTimeStamp(ecu.getLong(A_PASSWORDRESET_TIMESTAMP, 0L));
            user.setFailedLoginAttempts(ecu.getLong(A_FAILEDLOGINCOUNT, 0L));
            FEUser fEUser = user;
            return fEUser;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public void update(FEUser user) throws DbException {
        y cu = y.a();
        try {
            cu.b(user.getUsername());
            EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, cu);
            ecu.createPK();
            ecu.updateStringInversion(INV_EMAIL, StringUtils.isBlank((String)user.getEmail()) ? null : user.getEmail());
            ecu.updateString(A_DISPLAYNAME, user.getDisplayName());
            ecu.updateString(A_PASSWORDHASH, user.getPasswordHash());
            ecu.updateInt(A_AUTHTYPE, user.getAuthType().getKey());
            ecu.updateString(A_PASSWORDRESET_SRND, user.getPasswordResetSRnd());
            ecu.updateLong(A_PASSWORDRESET_TIMESTAMP, user.getPasswordResetTimeStamp());
            ecu.updateLong(A_FAILEDLOGINCOUNT, user.getFailedLoginAttempts());
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public LegacyUserProfile loadProfile(String username) throws DbException {
        y cu = y.a();
        try {
            cu.b(username);
            EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, cu);
            if (!ecu.exists()) {
                LegacyUserProfile legacyUserProfile = null;
                return legacyUserProfile;
            }
            LegacyUserProfile profile = new LegacyUserProfile(username);
            profile.setTimezone(ecu.getString(A_TIMEZONE, LegacyUserProfileManager.DEFAULT_PROFILE.getTimezone()));
            profile.setTabwidth(ecu.getInt(A_TABWIDTH, LegacyUserProfileManager.DEFAULT_PROFILE.getTabwidth()));
            profile.setCookiePrefs(ecu.getString(A_COOKIEPREFS, ""));
            profile.setWatchMode(ecu.getInt(A_WATCHMODE, LegacyUserProfileManager.DEFAULT_PROFILE.getWatchMode()));
            profile.setEmailFormat(ecu.getInt(A_EMAILFORMAT, LegacyUserProfileManager.DEFAULT_PROFILE.getEmailFormat()));
            profile.setChangesetsPerPage(ecu.getInt(A_CHANGESETSPERPAGE, LegacyUserProfileManager.DEFAULT_PROFILE.getChangesetsPerPage()));
            profile.setMaxFilesPerChangeset(ecu.getInt(A_MAXFILESPERCHANGESET, LegacyUserProfileManager.DEFAULT_PROFILE.getMaxFilesPerChangeset()));
            profile.setIdeConnectorPort(ecu.getInt(A_IDECONNECTORPORT, LegacyUserProfileManager.DEFAULT_PROFILE.getIdeConnectorPort()));
            profile.setEnableIde(ecu.getBoolean(A_ENABLEIDE, LegacyUserProfileManager.DEFAULT_PROFILE.isEnableIde()));
            profile.setContext(ecu.getInt(A_CONTEXT, LegacyUserProfileManager.DEFAULT_PROFILE.getContext()));
            profile.setUploadType(ecu.getString(A_UPLOAD_TYPE, LegacyUserProfileManager.DEFAULT_PROFILE.getUploadType()));
            profile.setUploadMethod(ecu.getString(A_UPLOAD_METHOD, LegacyUserProfileManager.DEFAULT_PROFILE.getUploadMethod()));
            profile.setUploadCharset(ecu.getString(A_UPLOAD_CHARSET, LegacyUserProfileManager.DEFAULT_PROFILE.getUploadCharset()));
            profile.setAutoMarkFilesRead(ecu.getBoolean(A_AUTO_MARK_FILES, LegacyUserProfileManager.DEFAULT_PROFILE.isAutoMarkFilesRead()));
            LegacyUserProfile legacyUserProfile = profile;
            return legacyUserProfile;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public void updateProfile(LegacyUserProfile profile) throws DbException {
        y cu = y.a();
        try {
            cu.b(profile.getUsername());
            EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, cu);
            ecu.createPK();
            ecu.updateString(A_TIMEZONE, profile.getTimezone());
            ecu.updateInt(A_TABWIDTH, profile.getTabwidth());
            ecu.updateString(A_COOKIEPREFS, profile.getCookiePrefs());
            ecu.updateInt(A_WATCHMODE, profile.getWatchMode());
            ecu.updateInt(A_EMAILFORMAT, profile.getEmailFormat());
            ecu.updateInt(A_CHANGESETSPERPAGE, profile.getChangesetsPerPage());
            ecu.updateInt(A_MAXFILESPERCHANGESET, profile.getMaxFilesPerChangeset());
            ecu.updateInt(A_IDECONNECTORPORT, profile.getIdeConnectorPort());
            ecu.updateBoolean(A_ENABLEIDE, profile.isEnableIde());
            ecu.updateInt(A_CONTEXT, profile.getContext());
            ecu.updateString(A_UPLOAD_TYPE, profile.getUploadType());
            ecu.updateString(A_UPLOAD_METHOD, profile.getUploadMethod());
            ecu.updateString(A_UPLOAD_CHARSET, profile.getUploadCharset());
            ecu.updateBoolean(A_AUTO_MARK_FILES, profile.isAutoMarkFilesRead());
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public List<String> listAllUserNames() throws DbException {
        y cu = y.a();
        try {
            LinkedList<String> result = new LinkedList<String>();
            cu.a(ENTITY);
            int pl = cu.e();
            ac is = this.dbh.get();
            while (is.a(cu, pl)) {
                String uname = cu.m(pl);
                result.add(uname);
                cu.d(cu.n(pl));
                cu.ak(pl);
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public Map<String, Map<String, String>> listAllMappings() throws DbException {
        y cu = y.a();
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        try {
            cu.a(ENTITY);
            int pl = cu.e();
            ac is = this.dbh.get();
            while (is.a(cu, pl)) {
                String uname = cu.m(pl);
                cu.a(A_AUTHORMAPPING);
                int len = cu.e();
                is.a(cu, len);
                String mapping = cu.m(len);
                if (!Strings.isNullOrEmpty((String)mapping)) {
                    result.put(uname, this.parseMapping(mapping));
                }
                cu.d(cu.n(pl));
                cu.ak(pl);
            }
            HashMap<String, Map<String, String>> hashMap = result;
            return hashMap;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    private Map<String, String> parseMapping(String mapstring) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        StringTokenizer toks = new StringTokenizer(mapstring, ",");
        while (toks.hasMoreTokens()) {
            String[] mapping = toks.nextToken().split(":");
            if (mapping.length != 2) continue;
            mappings.put(mapping[0], mapping[1]);
        }
        return mappings;
    }

    public int countNumberOfCrucibleUsers() throws DbException {
        y cu = y.a();
        try {
            int count = 0;
            cu.a(ENTITY);
            int pl = cu.e();
            ac is = this.dbh.get();
            while (is.a(cu, pl)) {
                cu.d(cu.n(pl));
                cu.a(A_CRU_ENABLED).a(true);
                if (is.a_(cu)) {
                    ++count;
                }
                cu.d(cu.n(pl));
                cu.ak(pl);
            }
            int n2 = count;
            return n2;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public List<String> listAllCrucibleUserNames() throws DbException {
        y cu = y.a();
        try {
            LinkedList<String> result = new LinkedList<String>();
            cu.a(ENTITY);
            int pl = cu.e();
            ac is = this.dbh.get();
            while (is.a(cu, pl)) {
                String uname = cu.m(pl);
                cu.d(cu.n(pl));
                cu.a(A_CRU_ENABLED).a(true);
                if (is.a_(cu)) {
                    result.add(uname);
                }
                cu.d(cu.n(pl));
                cu.ak(pl);
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public List<FEUser> getAllUsers() throws DbException {
        y cu = y.a();
        try {
            LinkedList<FEUser> result = new LinkedList<FEUser>();
            cu.a(ENTITY);
            int pl = cu.e();
            ac is = this.dbh.get();
            while (is.a(cu, pl)) {
                String uname = cu.m(pl);
                result.add(this.load(uname));
            }
            LinkedList<FEUser> linkedList = result;
            return linkedList;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public List<FEUser> listUsersWithNamesMatching(String subString) throws DbException {
        subString = StringUtil.toLower(subString);
        y cu = y.a();
        y attr = y.a();
        try {
            LinkedList<FEUser> result = new LinkedList<FEUser>();
            cu.a(ENTITY);
            int pl = cu.e();
            ac is = this.dbh.get();
            while (is.a(cu, pl)) {
                String uname = cu.m(pl);
                if (StringUtil.toLower(uname).startsWith(subString)) {
                    result.add(this.load(uname));
                } else {
                    String emailAddress;
                    cu.d(cu.n(pl));
                    attr.f().e(cu);
                    attr.a(A_EMAIL);
                    int emailLocation = attr.e();
                    boolean emailMatches = false;
                    if (is.a(attr, attr.e()) && (emailAddress = attr.m(emailLocation)) != null && StringUtil.toLower(emailAddress).startsWith(subString)) {
                        result.add(this.load(uname));
                        emailMatches = true;
                    }
                    if (!emailMatches) {
                        String displayName;
                        attr.f().e(cu);
                        attr.a(A_DISPLAYNAME);
                        int displayNameLocation = attr.e();
                        if (is.a(attr, displayNameLocation) && (displayName = attr.m(displayNameLocation)) != null) {
                            String[] words;
                            for (String word : words = StringUtil.toLower(displayName).split("\\W")) {
                                if (!word.startsWith(subString)) continue;
                                result.add(this.load(uname));
                                break;
                            }
                        }
                    }
                }
                cu.ak(pl);
            }
            LinkedList<FEUser> linkedList = result;
            return linkedList;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public void setCrucibleEnabled(String username, boolean enabled) throws DbException {
        y cu = y.a();
        try {
            cu.b(username);
            EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, cu);
            if (!ecu.exists()) {
                return;
            }
            ecu.updateBoolean(A_CRU_ENABLED, enabled);
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public void updateInitialCrucibleUsers(int maxCruUsers) throws DbException {
        y cu = y.a();
        try {
            int enabledUsers;
            long val = InfinityDbUtil.getLong(this.dbh.get(), DB0EAV.CONSTANTS, CRU_USER_UPGRADE_ALREADY_PERFORMED);
            if (val != 0L) {
                return;
            }
            cu.a(ENTITY);
            int pl = cu.e();
            ac is = this.dbh.get();
            for (enabledUsers = 0; is.a(cu, pl) && enabledUsers < maxCruUsers; ++enabledUsers) {
                cu.d(cu.n(pl));
                cu.a(A_CRU_ENABLED).a(true);
                is.b(cu);
                cu.d(cu.n(pl));
                cu.ak(pl);
            }
            Logs.APP_LOG.info((Object)("Enabled " + enabledUsers + " users as Crucible users."));
            InfinityDbUtil.incrementLong(this.dbh.get(), DB0EAV.CONSTANTS, CRU_USER_UPGRADE_ALREADY_PERFORMED);
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public void deleteAuthorMappings(String username) throws DbException {
        y cu = y.a();
        try {
            cu.b(username);
            EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, cu);
            ecu.deleteValues(A_AUTHORMAPPING);
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }
}

