/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.HostAuthRepositoryConfigType;
import com.cenqua.fisheye.config1.LdapRepositoryConfigType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryType;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RepositoryExternalPermissionCleanUpTask {
    private final Logger log;

    public RepositoryExternalPermissionCleanUpTask(Logger log) {
        this.log = log;
    }

    public void perform() throws IOException {
        RootConfig rootConfig = AppConfig.getsConfig();
        this.perform(rootConfig);
        rootConfig.saveConfig();
    }

    private void perform(RootConfig rootConfig) {
        ConfigDocument.Config config = rootConfig.getConfig();
        this.log.debug((Object)"Performing repository security upgrade for config.xml");
        this.processRepositories(config);
    }

    private void processRepositories(ConfigDocument.Config config) {
        for (RepositoryType repositoryType : config.getRepositoryArray()) {
            this.processRepoSecurity(repositoryType);
        }
    }

    private void processRepoSecurity(RepositoryType repositoryType) {
        RepSecurityType security = repositoryType.getSecurity();
        if (security.isSetLdap()) {
            this.cleanLdap(repositoryType.getName(), security);
        }
        if (security.isSetHostAuth()) {
            this.cleanHost(repositoryType.getName(), security);
        }
    }

    private void cleanHost(String repoName, RepSecurityType security) {
        HostAuthRepositoryConfigType hostAuth = security.getHostAuth();
        String requiredGroup = hostAuth.getRequiredGroup();
        this.log.info((Object)("Clearing host restrictions for repository: " + repoName + " removed required groups: " + requiredGroup));
        security.unsetHostAuth();
    }

    private void cleanLdap(String repoName, RepSecurityType security) {
        LdapRepositoryConfigType ldap = security.getLdap();
        String filter = ldap.getFilter();
        String matchType = ldap.getMatchType();
        this.log.info((Object)("Clearing ldap restrictions for repository: " + repoName + " removed filer query: " + filter + " and match type: " + matchType));
        security.unsetLdap();
    }
}

