/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class MoveDataFromCruUser {
    private final Connection connection;
    private final Logger log;

    public MoveDataFromCruUser(Connection connection, Logger log) {
        this.connection = connection;
        this.log = log;
    }

    public void execute() throws SQLException {
        this.log.info((Object)"Migrating user properties");
        int count = 0;
        try (PreparedStatement userStatement = this.connection.prepareStatement("SELECT cru_user_id, cru_timezone FROM cru_user");){
            ResultSet users = userStatement.executeQuery();
            while (users.next()) {
                int userId = users.getInt(1);
                String timeZone = users.getString(2);
                try (PreparedStatement updateTimezone = this.connection.prepareStatement("UPDATE cru_user_profile SET cru_timezone = ? WHERE cru_user_id = ?");){
                    updateTimezone.setString(1, timeZone);
                    updateTimezone.setInt(2, userId);
                    updateTimezone.execute();
                }
                if (++count % 200 != 0) continue;
                this.log.info((Object)("Processed " + count + " users"));
            }
        }
        this.log.info((Object)("Done migrating properties for " + count + " users"));
    }
}

