/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.password.encoder.AtlassianSecurityPasswordEncoder;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.cenqua.crucible.hibernate.upgrade.crowd.CrowdUpgradeUtil;
import com.cenqua.crucible.hibernate.upgrade.crowd.LegacyAuthType;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigratedUsersData;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;

class MigrateUsersToCwdUsers {
    private static final String INSERT_CWD_USER = "INSERT INTO cwd_user (id, user_name, lower_user_name, active, created_date, updated_date, display_name, lower_display_name, email_address, lower_email_address, directory_id, credential) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SELECT_CRU_USERS = "SELECT cru_user_name, cru_displayname, cru_email, cru_passwordhash, cru_authtype, cru_user_id, cru_fisheye_enabled, cru_crucible_enabled FROM cru_user ORDER BY cru_fisheye_enabled ASC, cru_user_id ASC";
    static final String NO_PASS = "nopass";
    private final Connection conn;
    private final Logger log;
    private final Set<String> alreadyProcessedUsernames = new HashSet<String>();
    private final Map<Integer, MigratedUsersData> migratedUsers = new HashMap<Integer, MigratedUsersData>();
    private final Optional<Integer> ldapDirectoryId;

    public MigrateUsersToCwdUsers(Connection conn, Logger log, Optional<Integer> ldapDirectoryId) {
        this.conn = conn;
        this.log = log;
        this.ldapDirectoryId = ldapDirectoryId;
    }

    public void perform() throws SQLException {
        this.log.info((Object)"Migrating users");
        try (PreparedStatement st = this.conn.prepareStatement(SELECT_CRU_USERS);
             ResultSet users = st.executeQuery();){
            Date migrationDate = new Date(System.currentTimeMillis());
            while (users.next()) {
                String userName = users.getString(1);
                String displayName = users.getString(2);
                String email = users.getString(3);
                String passwordHash = Strings.emptyToNull((String)users.getString(4));
                LegacyAuthType authType = LegacyAuthType.fromKey(users.getInt(5));
                int cruUserId = users.getInt(6);
                boolean fishEyeEnabled = users.getBoolean(7);
                boolean crucibleEnabled = users.getBoolean(8);
                this.log.info((Object)String.format("Processing user %s. username=%s;displayName=%s;email=%s;authType=%s;enabled=%s;crucible=%s", new Object[]{cruUserId, userName, displayName, email, authType, fishEyeEnabled, crucibleEnabled}));
                String targetUsername = this.ensureUsernameValid(cruUserId, fishEyeEnabled, userName, authType);
                if (fishEyeEnabled && authType != LegacyAuthType.CROWD) {
                    int directoryId;
                    if (authType == LegacyAuthType.LDAP && !this.ldapDirectoryId.isPresent()) {
                        this.log.warn((Object)("The user " + userName + " is defined as an LDAP user, but LDAP authentication wasn't configured. User will not be migrated."));
                        continue;
                    }
                    if (authType != LegacyAuthType.BUILTIN && !Strings.isNullOrEmpty((String)passwordHash)) {
                        this.log.warn((Object)("The user " + userName + " had a non empty password for " + authType.getDisplayName() + " authentication. The password will not be migrated."));
                        passwordHash = null;
                    }
                    if (!Strings.isNullOrEmpty((String)passwordHash) && new AtlassianSecurityPasswordEncoder().isUpgradeRequired(passwordHash)) {
                        this.log.warn((Object)("The password for user " + userName + " was stored using an older scheme. The user's password needs to be reset, before he can login."));
                        passwordHash = null;
                    }
                    if (authType == LegacyAuthType.LDAP) {
                        directoryId = this.ldapDirectoryId.get();
                        passwordHash = NO_PASS;
                    } else {
                        directoryId = 1;
                        passwordHash = Optional.ofNullable(passwordHash).orElse(PasswordCredential.NONE.getCredential());
                    }
                    try (PreparedStatement createStatement = this.conn.prepareStatement(INSERT_CWD_USER);){
                        createStatement.setInt(1, cruUserId);
                        createStatement.setString(2, targetUsername);
                        createStatement.setString(3, IdentifierUtils.toLowerCase((String)targetUsername));
                        createStatement.setString(4, "T");
                        createStatement.setDate(5, migrationDate);
                        createStatement.setDate(6, migrationDate);
                        createStatement.setString(7, displayName);
                        createStatement.setString(8, IdentifierUtils.toLowerCase((String)displayName));
                        createStatement.setString(9, email);
                        createStatement.setString(10, IdentifierUtils.toLowerCase((String)email));
                        createStatement.setInt(11, directoryId);
                        createStatement.setString(12, passwordHash);
                        createStatement.executeUpdate();
                        this.log.debug((Object)("Migrating user " + targetUsername + " to cwd_users"));
                        this.migratedUsers.put(cruUserId, new MigratedUsersData(targetUsername, directoryId));
                    }
                } else if (!fishEyeEnabled) {
                    this.log.debug((Object)("Not migrating disabled user " + targetUsername + " to cwd_users"));
                } else {
                    this.log.debug((Object)("Not migrating Crowd user " + targetUsername + " to cwd_users - users will be synchronized after startup"));
                }
                this.alreadyProcessedUsernames.add(CrowdUpgradeUtil.NORMALIZE_USER.apply(userName));
            }
        }
    }

    private String ensureUsernameValid(int cruUserId, boolean userEnabled, String userName, LegacyAuthType authType) throws SQLException {
        boolean isBestCandidate;
        String normalizedUsername = CrowdUpgradeUtil.NORMALIZE_USER.apply(userName);
        boolean isUsernameNormalized = normalizedUsername.equals(userName);
        if (!userEnabled) {
            boolean isOnlyMatch = CrowdUpgradeUtil.countRows(this.conn, "cru_user", "LOWER(cru_user_name) = ?", normalizedUsername) == 1;
            isBestCandidate = !this.alreadyProcessedUsernames.contains(normalizedUsername) && isOnlyMatch;
        } else {
            boolean exactMatchExist = CrowdUpgradeUtil.countRows(this.conn, "cru_user", "cru_user_name = ?", normalizedUsername) > 0;
            boolean bl = isBestCandidate = !exactMatchExist || isUsernameNormalized;
        }
        if (!isBestCandidate) {
            String newName = CrowdUpgradeUtil.generateNewName(userName, name -> !this.alreadyProcessedUsernames.contains(CrowdUpgradeUtil.NORMALIZE_USER.apply((String)name)) && CrowdUpgradeUtil.countRows(this.conn, "cru_user", "LOWER(cru_user_name) = ?", CrowdUpgradeUtil.NORMALIZE_USER.apply((String)name)) == 0);
            String renameMsg = String.format("The user %s has a duplicate username. Will rename the user to %s.", userEnabled ? userName : userName + " (inactive)", newName);
            if (!userEnabled || authType == LegacyAuthType.BUILTIN) {
                this.log.info((Object)renameMsg);
            } else {
                this.log.warn((Object)(renameMsg + " The user uses " + authType.getDisplayName() + " authentication, you might need to reconfigure it before the user can log in."));
            }
            this.renameUser(cruUserId, userName, CrowdUpgradeUtil.NORMALIZE_USER.apply(newName));
            return newName;
        }
        if (!isUsernameNormalized) {
            this.renameUser(cruUserId, userName, normalizedUsername);
        }
        return userName;
    }

    private void renameUser(int cruUserId, String oldName, String normalizedNewName) throws SQLException {
        Preconditions.checkArgument((!oldName.equals(normalizedNewName) ? 1 : 0) != 0, (Object)("Tried to rename user to the same name: " + normalizedNewName));
        this.log.debug((Object)("Normalizing references to username " + oldName + " into " + normalizedNewName));
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_login_cookie WHERE cru_user_id = ?", cruUserId);
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_user SET cru_user_name = ? WHERE cru_user_id = ?", normalizedNewName, cruUserId);
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_base_star_model WHERE cru_user_name = ?", normalizedNewName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_base_star_model SET cru_user_name = ? WHERE cru_user_name = ?", normalizedNewName, oldName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_base_star_model WHERE cru_string_key1 = ? AND cru_item_type = ?", normalizedNewName, StarType.USER.getName());
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_base_star_model SET cru_string_key1 = ? WHERE cru_string_key1 = ? AND cru_item_type = ?", normalizedNewName, oldName, StarType.USER.getName());
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_recently_visited WHERE cru_user_name = ?", normalizedNewName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_recently_visited SET cru_user_name = ? WHERE cru_user_name = ?", normalizedNewName, oldName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_recently_visited WHERE cru_entity_id = ? AND cru_item_type = ?", normalizedNewName, RecentlyVisitedItem.Type.USER.getType());
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_recently_visited SET cru_entity_id = ? WHERE cru_entity_id = ? AND cru_item_type = ?", normalizedNewName, oldName, RecentlyVisitedItem.Type.USER.getType());
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_committer_user_mapping WHERE cru_user_name = ?", normalizedNewName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_committer_user_mapping SET cru_user_name = ? WHERE cru_user_name = ?", normalizedNewName, oldName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_ps_user WHERE cru_pid = ?", normalizedNewName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_ps_user SET cru_pid = ? WHERE cru_pid = ?", normalizedNewName, oldName);
        CrowdUpgradeUtil.updateSysAdmins(admins -> {
            HashSet adminSet = Sets.newHashSet((Object[])admins.getUserArray());
            if (adminSet.contains(normalizedNewName)) {
                adminSet.remove(normalizedNewName);
            }
            if (adminSet.contains(oldName)) {
                adminSet.remove(oldName);
                adminSet.add(normalizedNewName);
            }
            admins.setUserArray(adminSet.toArray(new String[adminSet.size()]));
        });
    }

    public Map<Integer, MigratedUsersData> getMigratedUsersData() {
        return this.migratedUsers;
    }
}

