/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.cenqua.crucible.hibernate.upgrade.crowd.CrowdUpgradeUtil;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.config1.GroupType;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.log4j.Logger;

public class MigrateUserLicenses {
    private final Connection conn;
    private final Logger log;
    private final Optional<Integer> ldapDirectoryId;
    private final Optional<Integer> crowdDirectoryId;
    private int cwdGroupId = 1;
    private long cruPermissionId = 1L;
    private String crucibleUsersGroupName;
    private Map<Integer, Integer> dirToCrucibleGroupId = Maps.newHashMap();
    private String fishEyeUsersGroupName;
    private Map<Integer, Integer> dirToFishEyeGroupId = Maps.newHashMap();

    public MigrateUserLicenses(Connection conn, Logger log, Optional<Integer> ldapDirectoryId, Optional<Integer> crowdDirectoryId) {
        this.conn = conn;
        this.log = log;
        this.ldapDirectoryId = ldapDirectoryId;
        this.crowdDirectoryId = crowdDirectoryId;
    }

    public void perform() throws SQLException {
        this.log.info((Object)"Migrating user licenses");
        this.migrateCrowdGroups();
        this.addDefaultGroups();
        this.addInternalAndLdapMigratedUsersToDefaultGroups();
        this.log.info((Object)"Done migrating user licenses");
    }

    private void migrateCrowdGroups() {
        CrowdUpgradeUtil.getSecurityConfig().ifPresent(security -> {
            Consumer<String> addGlobalPermissionForGroup = groupName -> {
                this.log.info((Object)("Adding permission to Crowd group " + groupName));
                this.addGlobalPermission((String)groupName, true);
            };
            if (security.isSetCrowd()) {
                GroupType[] groupArray = security.getCrowd().isSetResyncGroupsList() ? security.getCrowd().getResyncGroupsList().getGroupArray() : new GroupType[]{};
                if (groupArray.length > 0) {
                    Arrays.stream(groupArray).map(GroupType::getName).forEach(addGlobalPermissionForGroup);
                } else {
                    this.log.warn((Object)("No groups were selected to synchronise from Crowd. You'll have to manually set up global permissions before users can access the application (see " + HelpUtil.getFishEyeHelpPath("fisheye.global.permissions") + ")."));
                    String[] adminGroups = security.isSetAdmins() && security.getAdmins().isSetSystemAdmins() ? security.getAdmins().getSystemAdmins().getGroupArray() : new String[]{};
                    if (adminGroups.length > 0) {
                        Arrays.stream(adminGroups).forEach(addGlobalPermissionForGroup);
                    } else {
                        this.log.warn((Object)"No admin groups are present. Use admin password to log in to the administration panel.");
                    }
                }
            }
        });
    }

    private void addInternalAndLdapMigratedUsersToDefaultGroups() throws SQLException {
        int userCount = 0;
        try (PreparedStatement query = this.conn.prepareStatement("SELECT cwd_user.id, cwd_user.directory_id, cwd_user.user_name, cru_user.cru_crucible_enabled FROM cwd_user, cru_user WHERE cwd_user.id = cru_user.cru_user_id");
             ResultSet resultSet = query.executeQuery();){
            int membershipId = this.getNextId("id", "cwd_membership");
            try (PreparedStatement addMembershipStatement = this.conn.prepareStatement("INSERT INTO cwd_membership (id, parent_id, child_id, membership_type, group_type, parent_name, lower_parent_name, child_name, lower_child_name, directory_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                while (resultSet.next()) {
                    int userId = resultSet.getInt(1);
                    int directoryId = resultSet.getInt(2);
                    String username = resultSet.getString(3);
                    boolean crucible = resultSet.getBoolean(4);
                    if (this.isInternalOrLdapDir(directoryId)) {
                        ++userCount;
                        CrowdUpgradeUtil.addGroupMembershipBatch(addMembershipStatement, membershipId++, userId, username, this.dirToFishEyeGroupId.get(directoryId), this.fishEyeUsersGroupName, directoryId);
                        if (crucible) {
                            CrowdUpgradeUtil.addGroupMembershipBatch(addMembershipStatement, membershipId++, userId, username, this.dirToCrucibleGroupId.get(directoryId), this.crucibleUsersGroupName, directoryId);
                        }
                    } else if (this.isCrowdDir(directoryId)) {
                        this.log.debug((Object)("Not migrating license for " + username + " as the user is a part of the Crowd directory"));
                    } else {
                        this.log.warn((Object)("Not migrating license for " + username + " as the user is a part of an unknown directory"));
                    }
                    if (userCount % 200 != 0) continue;
                    this.log.info((Object)("Migrated " + userCount + " user licenses"));
                    addMembershipStatement.executeBatch();
                }
                addMembershipStatement.executeBatch();
            }
        }
    }

    private void addDefaultGroups() throws SQLException {
        this.cwdGroupId = this.getNextId("id", "cwd_group");
        this.fishEyeUsersGroupName = this.addDefaultGroup("fisheye-users", false);
        this.crucibleUsersGroupName = this.addDefaultGroup("crucible-users", true);
    }

    private int getNextId(String idField, String tableName) throws SQLException {
        try (Statement st = this.conn.createStatement();
             ResultSet resultSet = st.executeQuery("SELECT MAX(" + idField + ") FROM " + tableName);){
            if (resultSet.next()) {
                int n2 = resultSet.getInt(1) + 1;
                return n2;
            }
        }
        return 1;
    }

    private String addDefaultGroup(String name, boolean crucible) throws SQLException {
        Predicate<String> existsCrowdGroup = groupName -> CrowdUpgradeUtil.countRows(this.conn, "cwd_group", "lower_group_name = ?", groupName) != 0;
        String targetGroupName = existsCrowdGroup.test(name) ? CrowdUpgradeUtil.generateNewName(name, existsCrowdGroup.negate()) : name;
        this.log.info((Object)("Creating group " + targetGroupName + " with permission " + (crucible ? "'Crucible users'" : "'FishEye users'")));
        this.addGroup(targetGroupName, this.cwdGroupId++, crucible, 1);
        this.ldapDirectoryId.ifPresent(dirId -> this.addGroup(targetGroupName, this.cwdGroupId++, crucible, (int)dirId));
        this.addGlobalPermission(targetGroupName, crucible);
        return targetGroupName;
    }

    private void addGlobalPermission(String targetGroupName, boolean crucible) {
        String normalisedGroupName = UserManager.GROUPNAME_NORMALIZATION.apply(targetGroupName);
        if (CrowdUpgradeUtil.countRows(this.conn, "cru_global_permission", "cru_group = ?", normalisedGroupName) == 0) {
            this.log.debug((Object)("Adding " + normalisedGroupName + " with crucible=" + crucible + " to cru_global_permission"));
            CrowdUpgradeUtil.executeUpdate(this.conn, "INSERT INTO cru_global_permission (cru_id, cru_group, cru_fisheye_user, cru_crucible_user) VALUES (?, ?, ?, ?)", this.cruPermissionId++, normalisedGroupName, true, crucible);
        } else {
            this.log.debug((Object)("Not adding " + normalisedGroupName + " to cru_global_permission, row already exists"));
        }
    }

    private void addGroup(String targetGroupName, int cwdGroupId, boolean crucible, int directoryId) {
        CrowdUpgradeUtil.addCrowdGroup(this.conn, cwdGroupId, new Date(System.currentTimeMillis()), targetGroupName, directoryId);
        if (crucible) {
            this.dirToCrucibleGroupId.put(directoryId, cwdGroupId);
        } else {
            this.dirToFishEyeGroupId.put(directoryId, cwdGroupId);
        }
    }

    private boolean isCrowdDir(int directoryId) {
        return this.crowdDirectoryId.filter(crowdDirId -> directoryId == crowdDirId).isPresent();
    }

    private boolean isInternalOrLdapDir(int directoryId) {
        return directoryId == 1 || this.ldapDirectoryId.filter(ldapDirId -> directoryId == ldapDirId).isPresent();
    }
}

