/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.cenqua.crucible.hibernate.upgrade.crowd.CrowdUpgradeUtil;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigratedGroupsData;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;

class MigrateGroupsToCwdGroups {
    private static final String SELECT_GROUPS = "SELECT cru_builtin_group_name, cru_builtin_group_id FROM cru_builtin_group ORDER BY cru_builtin_group_id ASC";
    private final Connection conn;
    private final Logger log;
    private final Optional<Integer> ldapDirectoryId;
    private final Set<String> alreadyProcessedGroups = new HashSet<String>();
    private final Multimap<Integer, MigratedGroupsData> migratedGroups = HashMultimap.create();
    private int cwdGroupId = 1;

    public MigrateGroupsToCwdGroups(Connection conn, Logger log, Optional<Integer> ldapDirectoryId) {
        this.conn = conn;
        this.log = log;
        this.ldapDirectoryId = ldapDirectoryId;
    }

    public void perform() throws SQLException {
        this.log.info((Object)"Migrating groups");
        try (PreparedStatement st = this.conn.prepareStatement(SELECT_GROUPS);){
            Date migrationDate = new Date(System.currentTimeMillis());
            try (ResultSet groups = st.executeQuery();){
                while (groups.next()) {
                    String groupName = groups.getString(1);
                    int cruGroupId = groups.getInt(2);
                    this.log.info((Object)("Processing group " + groupName));
                    String targetGroupName = this.ensureGroupNameValid(groupName);
                    this.migratedGroups.put((Object)cruGroupId, (Object)new MigratedGroupsData(this.cwdGroupId, 1, targetGroupName));
                    CrowdUpgradeUtil.addCrowdGroup(this.conn, this.cwdGroupId, migrationDate, targetGroupName, 1);
                    ++this.cwdGroupId;
                    if (this.ldapDirectoryId.isPresent()) {
                        if (!targetGroupName.equals(groupName)) {
                            this.log.warn((Object)("The group " + groupName + " had LDAP group members, but the group was renamed to " + targetGroupName + " during the migration. "));
                        }
                        this.migratedGroups.put((Object)cruGroupId, (Object)new MigratedGroupsData(this.cwdGroupId, this.ldapDirectoryId.get(), targetGroupName));
                        CrowdUpgradeUtil.addCrowdGroup(this.conn, this.cwdGroupId, migrationDate, targetGroupName, this.ldapDirectoryId.get());
                        ++this.cwdGroupId;
                    }
                    this.alreadyProcessedGroups.add(CrowdUpgradeUtil.NORMALIZE_GROUP.apply(groupName));
                }
            }
        }
    }

    private String ensureGroupNameValid(String groupName) throws SQLException {
        boolean isBestCandidate;
        String normalizedGroupName = CrowdUpgradeUtil.NORMALIZE_GROUP.apply(groupName);
        boolean isGroupNameNormalized = normalizedGroupName.equals(groupName);
        boolean bl = isBestCandidate = isGroupNameNormalized || CrowdUpgradeUtil.countRows(this.conn, "cru_builtin_group", "cru_builtin_group_name = ?", CrowdUpgradeUtil.NORMALIZE_GROUP.apply(groupName)) == 0;
        if (!isBestCandidate) {
            String newName = CrowdUpgradeUtil.generateNewName(groupName, name -> !this.alreadyProcessedGroups.contains(CrowdUpgradeUtil.NORMALIZE_GROUP.apply((String)name)) && CrowdUpgradeUtil.countRows(this.conn, "cru_builtin_group", "LOWER(cru_builtin_group_name) = ?", name.toLowerCase(Locale.US)) == 0);
            this.log.info((Object)("The group " + groupName + " has a duplicate name. Will rename the group to " + newName));
            this.renameGroup(groupName, CrowdUpgradeUtil.NORMALIZE_GROUP.apply(newName));
            return newName;
        }
        if (!isGroupNameNormalized) {
            this.renameGroup(groupName, normalizedGroupName);
        }
        return groupName;
    }

    private void renameGroup(String oldName, String normalizedNewName) throws SQLException {
        Preconditions.checkArgument((!oldName.equals(normalizedNewName) ? 1 : 0) != 0, (Object)("Tried to rename group to the same name: " + normalizedNewName));
        this.log.debug((Object)("Normalizing references to group name " + oldName + " into " + normalizedNewName));
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_builtin_group SET cru_builtin_group_name = ? WHERE cru_builtin_group_name = ?", normalizedNewName, oldName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_ps_group WHERE cru_pid = ?", normalizedNewName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_ps_group SET cru_pid = ? WHERE cru_pid = ?", normalizedNewName, oldName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_proj_allowed_grp WHERE cru_group_name = ?", normalizedNewName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_proj_allowed_grp SET cru_group_name = ? WHERE cru_group_name = ?", normalizedNewName, oldName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "DELETE FROM cru_proj_default_grp WHERE cru_group_name = ?", normalizedNewName);
        CrowdUpgradeUtil.executeUpdate(this.conn, "UPDATE cru_proj_default_grp SET cru_group_name = ? WHERE cru_group_name = ?", normalizedNewName, oldName);
        CrowdUpgradeUtil.updateSysAdmins(admins -> {
            HashSet adminSet = Sets.newHashSet((Object[])admins.getGroupArray());
            if (adminSet.contains(normalizedNewName)) {
                adminSet.remove(normalizedNewName);
            }
            if (adminSet.contains(oldName)) {
                adminSet.remove(oldName);
                adminSet.add(normalizedNewName);
            }
            admins.setGroupArray(adminSet.toArray(new String[adminSet.size()]));
        });
    }

    public Multimap<Integer, MigratedGroupsData> getMigratedGroups() {
        return this.migratedGroups;
    }
}

