/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.cenqua.crucible.hibernate.upgrade.crowd.CrowdUpgradeUtil;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigratedGroupsData;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigratedUsersData;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class MigrateGroupMembershipsToCwdMemberships {
    static final String SELECT_CRU_MEMBERSHIPS = "SELECT cru_user_id, cru_builtin_group_id FROM cru_builtin_group_user";
    private final Connection conn;
    private final Logger log;
    private final Map<Integer, MigratedUsersData> cwdUsers;
    private final Multimap<Integer, MigratedGroupsData> cwdGroups;

    public MigrateGroupMembershipsToCwdMemberships(Connection conn, Logger log, Map<Integer, MigratedUsersData> cwdUsers, Multimap<Integer, MigratedGroupsData> cwdGroups) {
        this.conn = conn;
        this.log = log;
        this.cwdUsers = cwdUsers;
        this.cwdGroups = cwdGroups;
    }

    public void perform() throws SQLException {
        this.log.info((Object)"Migrating group memberships");
        try (PreparedStatement st = this.conn.prepareStatement(SELECT_CRU_MEMBERSHIPS);
             ResultSet groupMemberships = st.executeQuery();){
            int id = 1;
            try (PreparedStatement addMembershipStatement = this.conn.prepareStatement("INSERT INTO cwd_membership (id, parent_id, child_id, membership_type, group_type, parent_name, lower_parent_name, child_name, lower_child_name, directory_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                while (groupMemberships.next()) {
                    int cruUserId = groupMemberships.getInt(1);
                    int cruGroupId = groupMemberships.getInt(2);
                    Collection groups = this.cwdGroups.get((Object)cruGroupId);
                    MigratedUsersData user = this.cwdUsers.get(cruUserId);
                    this.log.debug((Object)("Processing user " + cruUserId + " in group " + cruGroupId));
                    if (groups.isEmpty()) {
                        throw new IllegalStateException("Group " + cruGroupId + " wasn't migrated properly");
                    }
                    if (user == null) continue;
                    MigratedGroupsData userGroup = groups.stream().filter(group -> group.directoryId == user.directoryId).findFirst().orElseThrow(() -> new IllegalStateException("No matching directory for user " + user.username + ". Groups are " + groups));
                    this.log.info((Object)("Adding user " + user.username + " to group " + userGroup.name + " in directory " + userGroup.directoryId));
                    CrowdUpgradeUtil.addGroupMembershipBatch(addMembershipStatement, id++, cruUserId, user.username, userGroup.groupId, userGroup.name, userGroup.directoryId);
                    if (id % 200 != 0) continue;
                    addMembershipStatement.executeBatch();
                    this.log.info((Object)("Migrated " + id + " group memberships"));
                }
                addMembershipStatement.executeBatch();
                this.log.info((Object)"Done migrating group memberships");
            }
        }
    }
}

