/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.cenqua.crucible.hibernate.upgrade.crowd.CrowdUpgradeUtil;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.config1.LdapConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.util.IntervalUtils;
import com.cenqua.fisheye.util.PropertiesUtil;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;

class MigrateAuthenticationConfigurations {
    static final String PASSWORD_SANITIZATION = "***";
    private static final String INSERT_CWD_DIRECTORY = "INSERT INTO cwd_directory (id, directory_name, lower_directory_name, created_date, updated_date, active, impl_class, lower_impl_class, directory_type) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_CWD_DIRECTORY_ATTRIBUTE = "INSERT INTO cwd_directory_attribute (directory_id, attribute_name, attribute_value) VALUES (?, ?, ?)";
    private static final String INSERT_CWD_DIRECTORY_OPERATION = "INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (?, ?)";
    private static final String INSERT_CWD_APP_DIR_MAPPING = "INSERT INTO cwd_app_dir_mapping (id, application_id, directory_id, allow_all, list_index) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_CWD_APP_DIR_MAPPING_LIST_INDEX = "UPDATE cwd_app_dir_mapping set list_index = ? WHERE id = ?";
    private static final String INSERT_CWD_APP_DIR_OPERATION = "INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (?, ?)";
    private static final String[] APPLICATION_DIRECTORY_MAPPING_OPERATIONS = new String[]{"CREATE_GROUP", "CREATE_ROLE", "CREATE_USER", "DELETE_GROUP", "DELETE_ROLE", "DELETE_USER", "UPDATE_GROUP", "UPDATE_GROUP_ATTRIBUTE", "UPDATE_ROLE", "UPDATE_ROLE_ATTRIBUTE", "UPDATE_USER", "UPDATE_USER_ATTRIBUTE"};
    static final int DIRECTORY_ID = 2;
    static final int APPLICATION_DIRECTORY_MAPPING_ID = 2;
    public static final ImmutableSet<String> SANITIZED_DIRECTORY_ATTRIBUTES = ImmutableSet.of((Object)"ldap.password", (Object)"application.password");
    private final Connection conn;
    private final Logger log;

    MigrateAuthenticationConfigurations(Connection conn, Logger log) {
        this.conn = conn;
        this.log = log;
    }

    void perform() throws SQLException {
        Optional<SecurityType> securityConfig = CrowdUpgradeUtil.getSecurityConfig();
        if (!securityConfig.isPresent()) {
            this.log.info((Object)"Using built-in authentication only, not creating additional directories");
            return;
        }
        SecurityType security = securityConfig.get();
        if (security.isSetLdap()) {
            this.migrateLdap(security.getLdap());
        } else if (security.isSetCrowd()) {
            this.migrateCrowd(security.getCrowd());
        } else {
            this.log.info((Object)"Neither LDAP nor Crowd authentication configuration found in config.xml");
            return;
        }
        this.updateCrowdApplicationDirectoryMappingListIndex(1, 1);
        this.insertCrowdApplicationDirectoryMapping(2, 1, 2, 0);
        for (String operation : APPLICATION_DIRECTORY_MAPPING_OPERATIONS) {
            this.insertCrowdApplicationDirectoryMappingOperation(2, operation);
        }
    }

    void cleanupSecurityConfigXml() {
        CrowdUpgradeUtil.getSecurityConfig().ifPresent(security -> {
            if (security.isSetLdap()) {
                security.unsetLdap();
                CrowdUpgradeUtil.saveConfig();
            } else if (security.isSetCrowd()) {
                boolean ssoEnabled = security.getCrowd().getSsoEnabled();
                security.unsetCrowd();
                security.addNewCrowd();
                security.getCrowd().setSsoEnabled(ssoEnabled);
                CrowdUpgradeUtil.saveConfig();
            }
        });
    }

    private void migrateCrowd(CrowdAuthConfigType config) throws SQLException {
        this.log.info((Object)"Migrating Crowd/JIRA authentication configuration");
        this.logExistingCrowdConfig(config);
        Date migrationDate = new Date(System.currentTimeMillis());
        String[] directoryOperations = new String[]{"UPDATE_GROUP_ATTRIBUTE", "UPDATE_USER_ATTRIBUTE"};
        this.insertCrowdDirectory(2, "Crowd Directory", "com.atlassian.crowd.directory.RemoteCrowdDirectory", "CROWD", migrationDate);
        this.setCrowdAttributes(config);
        for (String operation : directoryOperations) {
            this.insertCrowdDirectoryOperation(2, operation);
        }
    }

    private void setCrowdAttributes(CrowdAuthConfigType config) throws SQLException {
        Optional<String> cookieDomain;
        Optional<String> cookieTokenkey;
        Properties crowdProperties = PropertiesUtil.loadFromString(config.getCrowdProperties());
        this.insertCrowdDirectoryAttribute(2, "application.name", (String)crowdProperties.remove("application.name"));
        this.insertCrowdDirectoryAttribute(2, "application.password", (String)crowdProperties.remove("application.password"));
        this.insertCrowdDirectoryAttribute(2, "crowd.server.url", (String)crowdProperties.remove("crowd.server.url"));
        this.insertCrowdDirectoryAttribute(2, "directory.cache.synchronise.interval", String.valueOf(IntervalUtils.convertStringToLong(config.getResyncPeriod(), 3600000L) / 1000L));
        this.insertCrowdDirectoryAttribute(2, "user_encryption_method", "atlassian-security");
        this.insertCrowdDirectoryAttribute(2, "crowd.sync.incremental.enabled", "true");
        this.insertCrowdDirectoryAttribute(2, "useNestedGroups", "false");
        Optional<String> httpMaxConnections = Optional.ofNullable((String)crowdProperties.remove("http.max.connections"));
        Optional<String> httpTimeout = Optional.ofNullable((String)crowdProperties.remove("http.timeout"));
        Optional<String> httpProxyHost = Optional.ofNullable((String)crowdProperties.remove("http.proxy.host"));
        Optional<String> httpProxyPort = Optional.ofNullable((String)crowdProperties.remove("http.proxy.port"));
        Optional<String> httpProxyUsername = Optional.ofNullable((String)crowdProperties.remove("http.proxy.username"));
        Optional<String> httpProxyPassword = Optional.ofNullable((String)crowdProperties.remove("http.proxy.password"));
        if (httpMaxConnections.isPresent()) {
            this.insertCrowdDirectoryAttribute(2, "crowd.server.http.max.connections", httpMaxConnections.get());
        }
        if (httpTimeout.isPresent()) {
            this.insertCrowdDirectoryAttribute(2, "crowd.server.http.timeout", httpTimeout.get());
        }
        if (httpProxyHost.isPresent()) {
            this.insertCrowdDirectoryAttribute(2, "crowd.server.http.proxy.host", httpProxyHost.get());
        }
        if (httpProxyPort.isPresent()) {
            this.insertCrowdDirectoryAttribute(2, "crowd.server.http.proxy.port", httpProxyPort.get());
        }
        if (httpProxyUsername.isPresent()) {
            this.insertCrowdDirectoryAttribute(2, "crowd.server.http.proxy.username", httpProxyUsername.get());
        }
        if (httpProxyPassword.isPresent()) {
            this.insertCrowdDirectoryAttribute(2, "crowd.server.http.proxy.password", httpProxyPassword.get());
        }
        if ((cookieTokenkey = Optional.ofNullable((String)crowdProperties.remove("cookie.tokenkey"))).isPresent()) {
            this.log.info((Object)String.format("%s is not migrated, FeCru will retrieve this property from Crowd instance.", cookieTokenkey.get()));
        }
        if ((cookieDomain = Optional.ofNullable((String)crowdProperties.remove("cookie.domain"))).isPresent()) {
            this.log.info((Object)String.format("%s is not migrated, FeCru will retrieve this property from Crowd instance.", cookieDomain.get()));
        }
        if (!crowdProperties.isEmpty()) {
            this.log.warn((Object)("Following Crowd properties will not be migrated: " + crowdProperties.toString()));
        }
    }

    private void migrateLdap(LdapConfigType config) throws SQLException {
        this.log.info((Object)"Migrating LDAP authentication configuration");
        this.logExistingLdapConfig(config);
        Date migrationDate = new Date(System.currentTimeMillis());
        String[] directoryOperations = new String[]{"CREATE_GROUP", "DELETE_GROUP", "UPDATE_GROUP", "UPDATE_GROUP_ATTRIBUTE", "UPDATE_USER_ATTRIBUTE"};
        this.insertCrowdDirectory(2, "LDAP Directory", "com.atlassian.crowd.directory.GenericLDAP", "CONNECTOR", migrationDate);
        this.setLdapAttributes(config);
        for (String operation : directoryOperations) {
            this.insertCrowdDirectoryOperation(2, operation);
        }
    }

    private void setLdapAttributes(LdapConfigType config) throws SQLException {
        this.insertCrowdDirectoryAttribute(2, "ldap.url", config.getUrl());
        this.insertCrowdDirectoryAttribute(2, "ldap.basedn", config.getBaseDn());
        String objectFilterValue = config.getFilter() == null ? null : config.getFilter().replaceAll("\\$\\{USERNAME\\}", "*");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.filter", objectFilterValue);
        this.insertCrowdDirectoryAttribute(2, "ldap.user.username", config.getUidAttr());
        this.insertCrowdDirectoryAttribute(2, "ldap.user.email", StringUtils.defaultIfEmpty((String)config.getEmailAttr(), (String)"mail"));
        this.insertCrowdDirectoryAttribute(2, "ldap.user.displayname", StringUtils.defaultIfEmpty((String)config.getDisplaynameAttr(), (String)"displayName"));
        this.insertCrowdDirectoryAttribute(2, "ldap.read.timeout", String.valueOf(IntervalUtils.toMsStringWithDefault("LDAP read timeout", config.getServerTimeout(), "120s")));
        this.insertCrowdDirectoryAttribute(2, "directory.cache.synchronise.interval", String.valueOf(IntervalUtils.convertStringToLong(config.getResyncPeriod(), 3600000L) / 1000L));
        this.insertCrowdDirectoryAttribute(2, "ldap.userdn", StringUtils.defaultString((String)config.getInitialDn()));
        this.insertCrowdDirectoryAttribute(2, "ldap.password", StringUtils.defaultString((String)config.getInitialSecret()));
        this.insertCrowdDirectoryAttribute(2, "ldap.pagedresults", "true");
        this.insertCrowdDirectoryAttribute(2, "ldap.pagedresults.size", "1000");
        this.insertCrowdDirectoryAttribute(2, "crowd.sync.incremental.enabled", "true");
        this.insertCrowdDirectoryAttribute(2, "autoAddGroups", "");
        this.insertCrowdDirectoryAttribute(2, "localUserStatusEnabled", "false");
        this.insertCrowdDirectoryAttribute(2, "ldap.usermembership.use", "false");
        this.insertCrowdDirectoryAttribute(2, "ldap.group.usernames", "uniqueMember");
        this.insertCrowdDirectoryAttribute(2, "ldap.connection.timeout", "10000");
        this.insertCrowdDirectoryAttribute(2, "ldap.group.filter", "(objectclass=groupOfUniqueNames)");
        this.insertCrowdDirectoryAttribute(2, "ldap.roles.disabled", "true");
        this.insertCrowdDirectoryAttribute(2, "ldap.external.id", "entryUUID");
        this.insertCrowdDirectoryAttribute(2, "ldap.usermembership.use.for.groups", "false");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.password", "userPassword");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.lastname", "sn");
        this.insertCrowdDirectoryAttribute(2, "ldap.group.name", "cn");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.objectclass", "inetorgperson");
        this.insertCrowdDirectoryAttribute(2, "ldap.nestedgroups.disabled", "true");
        this.insertCrowdDirectoryAttribute(2, "ldap.secure", "false");
        this.insertCrowdDirectoryAttribute(2, "ldap.referral", "false");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.username.rdn", "cn");
        this.insertCrowdDirectoryAttribute(2, "ldap.propogate.changes", "false");
        this.insertCrowdDirectoryAttribute(2, "ldap.group.dn", "");
        this.insertCrowdDirectoryAttribute(2, "ldap.pool.timeout", "0");
        this.insertCrowdDirectoryAttribute(2, "ldap.relaxed.dn.standardisation", "false");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.firstname", "givenName");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.group", "memberOf");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.encryption", "sha");
        this.insertCrowdDirectoryAttribute(2, "ldap.local.groups", "true");
        this.insertCrowdDirectoryAttribute(2, "ldap.group.description", "description");
        this.insertCrowdDirectoryAttribute(2, "ldap.user.dn", "");
        this.insertCrowdDirectoryAttribute(2, "ldap.filter.expiredUsers", "false");
        this.insertCrowdDirectoryAttribute(2, "ldap.group.objectclass", "groupOfUniqueNames");
        this.insertCrowdDirectoryAttribute(2, "ldap.search.timelimit", "60000");
    }

    private void insertCrowdDirectory(int id, String name, String implClass, String type, Date createDate) throws SQLException {
        CrowdUpgradeUtil.executeUpdate(this.conn, INSERT_CWD_DIRECTORY, id, name, name.toLowerCase(), createDate, createDate, "T", implClass, implClass.toLowerCase(), type);
    }

    private void insertCrowdDirectoryAttribute(int directoryId, String attributeName, String attributeValue) throws SQLException {
        String sanitizedAttributeValue = SANITIZED_DIRECTORY_ATTRIBUTES.contains((Object)attributeName) ? PASSWORD_SANITIZATION : attributeValue;
        this.log.info((Object)("Setting directory attribute for directory " + directoryId + ": " + attributeName + " = " + sanitizedAttributeValue));
        CrowdUpgradeUtil.executeUpdate(this.conn, INSERT_CWD_DIRECTORY_ATTRIBUTE, directoryId, attributeName, attributeValue);
    }

    private void insertCrowdDirectoryOperation(int directoryId, String operationType) throws SQLException {
        CrowdUpgradeUtil.executeUpdate(this.conn, INSERT_CWD_DIRECTORY_OPERATION, directoryId, operationType);
    }

    private void insertCrowdApplicationDirectoryMapping(int mappingId, int applicationId, int directoryId, int listIndex) throws SQLException {
        CrowdUpgradeUtil.executeUpdate(this.conn, INSERT_CWD_APP_DIR_MAPPING, mappingId, applicationId, directoryId, "T", listIndex);
    }

    private void updateCrowdApplicationDirectoryMappingListIndex(int mappingId, int listIndex) throws SQLException {
        CrowdUpgradeUtil.executeUpdate(this.conn, UPDATE_CWD_APP_DIR_MAPPING_LIST_INDEX, mappingId, listIndex);
    }

    private void insertCrowdApplicationDirectoryMappingOperation(int applicationDirectoryMappingId, String operationType) throws SQLException {
        CrowdUpgradeUtil.executeUpdate(this.conn, INSERT_CWD_APP_DIR_OPERATION, applicationDirectoryMappingId, operationType);
    }

    private void logExistingCrowdConfig(CrowdAuthConfigType config) {
        CrowdAuthConfigType crowdConfig = (CrowdAuthConfigType)config.copy();
        Properties crowdProperties = PropertiesUtil.loadFromString(config.getCrowdProperties());
        if (Strings.emptyToNull((String)crowdProperties.getProperty("application.password")) != null) {
            crowdProperties.setProperty("application.password", PASSWORD_SANITIZATION);
        }
        crowdConfig.setCrowdProperties(PropertiesUtil.saveToString(crowdProperties));
        SecurityType securityType = SecurityType.Factory.newInstance();
        securityType.setCrowd(crowdConfig);
        this.log.info((Object)("Existing Crowd configuration: " + this.configToString(securityType)));
    }

    private void logExistingLdapConfig(LdapConfigType config) {
        LdapConfigType ldapConfig = (LdapConfigType)config.copy();
        if (ldapConfig.isSetInitialSecret()) {
            ldapConfig.setInitialSecret(PASSWORD_SANITIZATION);
        }
        SecurityType securityType = SecurityType.Factory.newInstance();
        securityType.setLdap(ldapConfig);
        this.log.info((Object)("Existing LDAP configuration: " + this.configToString(securityType)));
    }

    private String configToString(SecurityType xmlObject) {
        XmlOptions opts = new XmlOptions();
        opts.setSaveImplicitNamespaces(RootConfig.makeExplicitNamespaces());
        return xmlObject.xmlText(opts);
    }
}

